/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.ds.process.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.google.common.collect.Lists;
import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Predicate;
import com.jxdinfo.hussar.dataset.dto.DataSetConfigInfoDto;
import com.jxdinfo.hussar.dataset.dto.DataSetOperationDto;
import com.jxdinfo.hussar.dataset.model.ApiDataContent;
import com.jxdinfo.hussar.dataset.model.ApiProperty;
import com.jxdinfo.hussar.dataset.model.WordDataSetInfo;
import com.jxdinfo.hussar.dataset.service.IDataSetService;
import com.jxdinfo.hussar.dataset.vo.DataSetExecuteVO;
import com.jxdinfo.hussar.ds.common.util.FileUtil;
import com.jxdinfo.hussar.ds.process.component.model.DataSetInputConfigModel;
import com.jxdinfo.hussar.ds.process.component.model.MasterFieldConfigModel;
import com.jxdinfo.hussar.ds.process.dto.DataStreamDataResponseDto;
import com.jxdinfo.hussar.ds.process.dto.widget.CanvasDetailConfigDTO;
import com.jxdinfo.hussar.ds.process.dto.widget.CanvasPropsDTO;
import com.jxdinfo.hussar.ds.process.dto.widget.DpApiBaseWidget;
import com.jxdinfo.hussar.ds.process.enums.DataSetTypeEnum;
import com.jxdinfo.hussar.ds.process.enums.FieldTypeEnum;
import com.jxdinfo.hussar.ds.process.enums.ModuleTypeEnum;
import com.jxdinfo.hussar.ds.process.model.DataStreamCanvas;
import com.jxdinfo.hussar.ds.process.model.DataStreamDataSet;
import com.jxdinfo.hussar.ds.process.model.DpJobInfo;
import com.jxdinfo.hussar.ds.process.service.DataStreamCanvasService;
import com.jxdinfo.hussar.ds.process.service.DataStreamDataSetQueryService;
import com.jxdinfo.hussar.ds.process.service.DataStreamDataSetService;
import com.jxdinfo.hussar.ds.process.service.DpJobInfoService;
import com.jxdinfo.hussar.mail.core.util.ObjectUtil;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.JsonUtil;
import com.jxdinfo.hussar.support.cache.util.HussarFixedCacheUtil;
import com.jxdinfo.hussar.support.choreo.api.service.EngineBussnessdataInvokeService;
import com.jxdinfo.hussar.support.exception.HussarException;
import com.jxdinfo.hussar.support.mp.base.query.dto.SuperQueryConditionDto;
import dm.jdbc.util.StringUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.seatunnel.shade.com.google.common.collect.Maps;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class DataStreamDataSetQueryServiceImpl
implements DataStreamDataSetQueryService {
    Logger log = LoggerFactory.getLogger(DataStreamDataSetQueryServiceImpl.class);
    @Value(value="${data-set.reNull:true}")
    private Boolean reNull;
    @Autowired
    private DataStreamDataSetService dataStreamDataSetService;
    @Autowired
    private DataStreamCanvasService dataStreamCanvasService;
    @Autowired
    private IDataSetService dataSetService;
    @Autowired
    private DpJobInfoService jobInfoService;
    @Resource
    private EngineBussnessdataInvokeService engineBussnessdataInvokeService;

    public DataStreamDataResponseDto getDataByDataSetIdAndInstanceId(String dataSetId, String instanceId) {
        return this.getDataByDataSetIdAndInstanceId(dataSetId, instanceId, new HashMap<String, Object>(), null);
    }

    public DataStreamDataResponseDto getDataByDataSetIdAndInstanceId(String dataSetId, String instanceId, Map<String, Object> params, Boolean needConvert) {
        HussarException.throwByNull((Object)dataSetId, (String)"\u6570\u636e\u6d41id\u4e0d\u80fd\u4e3a\u7a7a");
        DpJobInfo dpJobInfo = this.jobInfoService.getByDataSetId(Long.valueOf(Long.parseLong(dataSetId)));
        if (ObjectUtil.isNotEmpty((Object)dpJobInfo)) {
            DataSetExecuteVO data = this.fetchDataFlowData(dataSetId, params, needConvert);
            List returnValue = JsonUtil.parseArray((String)data.getReturnValue(), JSONObject.class);
            List<JSONObject> result = this.changeResult(dataSetId, returnValue, needConvert);
            return DataStreamDataResponseDto.success(result);
        }
        if (StringUtil.isEmpty((String)instanceId)) {
            instanceId = (String)HussarFixedCacheUtil.get((String)"ds", (Object)"data_set_2_instance:".concat(dataSetId), String.class);
        }
        if (StringUtil.isNotEmpty((String)instanceId)) {
            DataStreamDataResponseDto workFlowInstanceResult = (DataStreamDataResponseDto)HussarFixedCacheUtil.get((String)"ds", (Object)"work_flow_instance:".concat(instanceId), DataStreamDataResponseDto.class);
            if (ObjectUtil.isEmpty((Object)workFlowInstanceResult)) {
                return new DataStreamDataResponseDto(DataStreamDataResponseDto.DataStreamDataResponseDtoEnum.WAITING);
            }
            if (workFlowInstanceResult.isSuccess()) {
                DataSetExecuteVO data = this.fetchDataFlowData(dataSetId, params, needConvert);
                List returnValue = JsonUtil.parseArray((String)data.getReturnValue(), JSONObject.class);
                List<JSONObject> result = this.changeResult(dataSetId, returnValue, needConvert);
                return DataStreamDataResponseDto.success(result);
            }
            return workFlowInstanceResult;
        }
        instanceId = this.dataStreamDataSetService.conductorStartWorkFlow(Long.valueOf(dataSetId), null, null);
        DataStreamDataResponseDto dataStreamDataResponseDto = new DataStreamDataResponseDto(DataStreamDataResponseDto.DataStreamDataResponseDtoEnum.WAITING);
        dataStreamDataResponseDto.setInstanceId(instanceId);
        HussarFixedCacheUtil.put((String)"ds", (Object)"work_flow_instance:".concat(instanceId), (Object)dataStreamDataResponseDto, (long)TimeUnit.HOURS.toSeconds(1L));
        HussarFixedCacheUtil.put((String)"ds", (Object)"data_set_2_instance:".concat(dataSetId), (Object)instanceId, (long)TimeUnit.HOURS.toSeconds(1L));
        return dataStreamDataResponseDto;
    }

    private List<JSONObject> changeResult(String dataSetId, List<JSONObject> jsonObjects, Boolean needConvert) {
        if (Boolean.FALSE.equals(needConvert)) {
            return jsonObjects;
        }
        WordDataSetInfo wordDataSetInfo = (WordDataSetInfo)this.dataSetService.getById((Serializable)((Object)dataSetId));
        if (!DataSetTypeEnum.DATA_STREAM.getCode().equals(wordDataSetInfo.getDataSetType())) {
            return jsonObjects;
        }
        DataSetConfigInfoDto dataSetDataDto = (DataSetConfigInfoDto)JsonUtil.parse((String)wordDataSetInfo.getData(), DataSetConfigInfoDto.class);
        List operations = dataSetDataDto.getOperations();
        HussarException.throwByNull((Object)operations, (String)"\u83b7\u53d6\u6570\u636e\u5b9a\u4e49\u5f02\u5e38");
        DataSetOperationDto dataSetOperationDto = (DataSetOperationDto)operations.get(0);
        ApiDataContent returnValue = dataSetOperationDto.getReturnValue();
        if (!FieldTypeEnum.ARRAY.match(returnValue.getObjectType())) {
            return jsonObjects;
        }
        List properties = returnValue.getProperties();
        if (ObjectUtil.isEmpty((Object)properties)) {
            return jsonObjects;
        }
        boolean noProperties = properties.stream().allMatch(action -> ObjectUtil.isEmpty((Object)action.getProperties()));
        if (noProperties) {
            Map<String, String> id2Name = properties.stream().collect(Collectors.toMap(ApiProperty::getId, ApiProperty::getName));
            return jsonObjects.stream().map(action -> {
                JSONObject one = new JSONObject();
                action.forEach((k, v) -> {
                    if (HussarUtils.isNotEmpty(id2Name.get(k))) {
                        one.put((String)id2Name.get(k), v);
                    }
                });
                return one;
            }).collect(Collectors.toList());
        }
        List<JSONObject> result = this.convertNestedData(jsonObjects, properties);
        return result;
    }

    private DataSetExecuteVO fetchDataFlowData(String dataSetId, Map<String, Object> params, Boolean needConvert) {
        DataStreamDataSet dataStreamDataSet = (DataStreamDataSet)this.dataStreamDataSetService.getById((Serializable)Long.valueOf(Long.parseLong(dataSetId)));
        HussarException.throwByNull((Object)dataStreamDataSet, (String)"\u6570\u636e\u96c6\u4e0d\u5b58\u5728");
        DataStreamCanvas dataStreamCanvas = (DataStreamCanvas)this.dataStreamCanvasService.getById((Serializable)dataStreamDataSet.getCanvasId());
        List<String> masterFieldIds = this.fetchMasterModelIds(dataStreamCanvas);
        List superQueryConditionDto = params.getOrDefault("superQueryConditionDto", new ArrayList());
        if (!Boolean.FALSE.equals(needConvert)) {
            Map<String, String> name2FieldIdMap = this.prepareTableFieldMap(dataStreamCanvas, masterFieldIds);
            superQueryConditionDto.stream().forEach(action -> action.setField((String)name2FieldIdMap.get(action.getField())));
        }
        if (HussarUtils.isNotEmpty(masterFieldIds)) {
            SuperQueryConditionDto superQueryCondition = new SuperQueryConditionDto();
            superQueryConditionDto.add(superQueryCondition);
            superQueryCondition.setField("pid");
            superQueryCondition.setRule("_isNull");
            params.put("superQueryConditionDto", superQueryConditionDto);
        }
        return this.processDataFlow(dataSetId, params, HussarUtils.isNotEmpty(masterFieldIds));
    }

    private DataSetExecuteVO processDataFlow(String dataSetId, Map<String, Object> params, boolean isNested) {
        DataSetExecuteVO result = this.processData(dataSetId, params);
        List returnValue = JsonUtil.parseArray((String)result.getReturnValue(), JSONObject.class);
        if (isNested && HussarUtils.isNotEmpty((Object)returnValue)) {
            ArrayList ids = Lists.newArrayListWithCapacity((int)10);
            for (JSONObject object : returnValue) {
                if (!object.containsKey((Object)"id")) continue;
                ids.add(object.getLong("id"));
            }
            if (HussarUtils.isNotEmpty((Object)ids)) {
                HashMap<String, Object> subParams = new HashMap<String, Object>();
                ArrayList<SuperQueryConditionDto> superQueryConditionDto = new ArrayList<SuperQueryConditionDto>();
                SuperQueryConditionDto superQueryCondition = new SuperQueryConditionDto();
                superQueryCondition.setField("pid");
                superQueryCondition.setRule("_in");
                superQueryCondition.setVal((Object)ids);
                superQueryConditionDto.add(superQueryCondition);
                subParams.put("superQueryConditionDto", superQueryConditionDto);
                DataSetExecuteVO subResult = this.processDataFlow(dataSetId, subParams, isNested);
                List subReturnValue = JsonUtil.parseArray((String)subResult.getReturnValue(), JSONObject.class);
                if (HussarUtils.isNotEmpty((Object)subReturnValue)) {
                    List subObjs;
                    HashMap subMap = Maps.newHashMapWithExpectedSize((int)10);
                    for (JSONObject object : subReturnValue) {
                        if (!object.containsKey((Object)"pid")) continue;
                        Long pid = object.getLong("pid");
                        subObjs = (List)subMap.get(pid);
                        if (HussarUtils.isEmpty((Object)subObjs)) {
                            subObjs = Lists.newArrayListWithCapacity((int)10);
                            subMap.put(pid, subObjs);
                        }
                        subObjs.add(object);
                    }
                    if (HussarUtils.isNotEmpty((Object)subMap)) {
                        for (JSONObject object : returnValue) {
                            Long id;
                            if (!object.containsKey((Object)"id") || !HussarUtils.isNotEmpty((Object)(subObjs = (List)subMap.get(id = object.getLong("id"))))) continue;
                            object.put("children", (Object)subObjs);
                        }
                    }
                }
            }
            result.setReturnValue(JsonUtil.toJson((Object)returnValue));
        }
        return result;
    }

    private DataSetExecuteVO processData(String dataSetId, Map<String, Object> params) {
        params.put("tfModelId", dataSetId);
        try {
            String businessId = String.format("%s /%s", "POST", FileUtil.posixPath((String[])new String[]{"sqlModelCustomSql"}));
            ApiResponse queryResult = this.engineBussnessdataInvokeService.invoke(businessId, params);
            Object data = queryResult.getData();
            DataSetExecuteVO dataSetExecuteVO = new DataSetExecuteVO();
            dataSetExecuteVO.setDataSetId(dataSetId);
            if (data instanceof Page) {
                Page page = (Page)data;
                dataSetExecuteVO.setCount(Long.valueOf(page.getTotal()).intValue());
                if (this.reNull.booleanValue()) {
                    dataSetExecuteVO.setReturnValue(JsonUtil.toJson((Object)page.getRecords()));
                } else {
                    dataSetExecuteVO.setReturnValue(JSONObject.toJSONString((Object)page.getRecords(), (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
                }
            } else if (data instanceof List) {
                dataSetExecuteVO.setCount(((List)data).size());
                if (this.reNull.booleanValue()) {
                    dataSetExecuteVO.setReturnValue(JsonUtil.toJson((Object)queryResult.getData()));
                } else {
                    dataSetExecuteVO.setReturnValue(JSONObject.toJSONString((Object)queryResult.getData(), (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
                }
            }
            return dataSetExecuteVO;
        }
        catch (Exception e) {
            this.log.error("\u8c03\u7528\u6570\u636e\u6a21\u578b\u670d\u52a1\u5931\u8d25", (Throwable)e);
            throw new HussarException(String.format("\u901a\u8fc7\u6570\u636e\u6d41\u83b7\u53d6\u6570\u636e\u5f02\u5e38\uff0c\u65b9\u6cd5\u540d\u3010processDataFlow\u3011,\u5f02\u5e38\u4fe1\u606f\uff1a%s", HussarUtils.isNotEmpty((Object)e.getCause()) ? e.getCause().getCause() : e.getMessage()));
        }
    }

    private List<String> fetchMasterModelIds(DataStreamCanvas dataStreamCanvas) {
        DocumentContext jsonContext = JsonPath.parse((String)dataStreamCanvas.getCanvasContent());
        Object read = jsonContext.read("$.data.slots.default", new Predicate[0]);
        List dpApiBaseWidgets = JSON.parseArray((String)JSON.toJSONString((Object)read), DpApiBaseWidget.class);
        List masterFieldWidgets = dpApiBaseWidgets.stream().filter(x -> HussarUtils.equals((Object)x.getName(), (Object)ModuleTypeEnum.MASTER_FIELD.getName())).collect(Collectors.toList());
        ArrayList result = Lists.newArrayListWithCapacity((int)10);
        if (HussarUtils.isNotEmpty(masterFieldWidgets)) {
            for (DpApiBaseWidget widget : masterFieldWidgets) {
                CanvasPropsDTO props = widget.getProps();
                CanvasDetailConfigDTO detailConfig = props.getDetailConfig();
                MasterFieldConfigModel configModel = (MasterFieldConfigModel)JsonUtil.parse((String)detailConfig.getConfig(), MasterFieldConfigModel.class);
                List dataSetIdList = configModel.getDataSetList().stream().map(DataSetInputConfigModel::getDataSetId).collect(Collectors.toList());
                result.addAll(dataSetIdList);
            }
        }
        return result;
    }

    private Map<String, String> prepareTableFieldMap(DataStreamCanvas dataStreamCanvas, List<String> masterFieldIds) {
        HashMap name2FieldIdMap = Maps.newHashMap();
        DocumentContext jsonContext = JsonPath.parse((String)dataStreamCanvas.getCanvasContent());
        Object read = jsonContext.read("$.data.slots.default", new Predicate[0]);
        List dpApiBaseWidgets = JSON.parseArray((String)JSON.toJSONString((Object)read), DpApiBaseWidget.class);
        DpApiBaseWidget widget = dpApiBaseWidgets.stream().filter(x -> HussarUtils.equals((Object)x.getName(), (Object)ModuleTypeEnum.OUT_PUT.getName())).findFirst().orElse(null);
        if (HussarUtils.isNotEmpty((Object)widget)) {
            CanvasPropsDTO props = widget.getProps();
            CanvasDetailConfigDTO detailConfig = props.getDetailConfig();
            List fieldList = detailConfig.getParentFieldList();
            if (HussarUtils.isNotEmpty(masterFieldIds)) {
                fieldList = fieldList.stream().filter(field -> !masterFieldIds.contains(field.getGroupId())).collect(Collectors.toList());
            }
            fieldList.stream().forEach(field -> name2FieldIdMap.put(field.getName(), field.getFieldId()));
        }
        return name2FieldIdMap;
    }

    private List<JSONObject> convertNestedData(List<JSONObject> data, List<ApiProperty> properties) {
        ArrayList result = Lists.newArrayListWithCapacity((int)data.size());
        data.stream().forEach(item -> {
            JSONObject convertedItem = new JSONObject();
            properties.stream().forEach(property -> {
                if (HussarUtils.isNotEmpty((Object)property.getProperties())) {
                    List children = JsonUtil.parseArray((String)JsonUtil.toJson((Object)item.get((Object)"children")), JSONObject.class);
                    if (HussarUtils.isNotEmpty((Object)children)) {
                        List<JSONObject> convertedChildren = this.convertNestedData(children, property.getProperties());
                        convertedItem.put(property.getName(), convertedChildren);
                    } else {
                        convertedItem.put(property.getName(), Collections.emptyList());
                    }
                } else if (HussarUtils.isNotEmpty((Object)property.getId())) {
                    Object value = item.get((Object)property.getId());
                    convertedItem.put(property.getName(), value);
                }
            });
            result.add(convertedItem);
        });
        return result;
    }
}

