/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.ds.process.http.util;

import com.jxdinfo.hussar.ds.process.http.util.EncryptUtil;
import com.jxdinfo.hussar.ds.process.model.Input;
import java.net.URL;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UrlParamUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(UrlParamUtil.class);

    public static Map<String, Object> parseUrlParameters(String url) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        try {
            URL urlObj = new URL(url);
            String query = urlObj.getQuery();
            if (query != null && !query.isEmpty()) {
                String[] pairs;
                for (String pair : pairs = query.split("&")) {
                    if (!pair.contains("=")) continue;
                    String[] keyValue = pair.split("=", 2);
                    String key = keyValue[0];
                    String value = keyValue.length > 1 ? keyValue[1] : "";
                    parameters.put(key, value);
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("Error parsing URL parameters", (Throwable)e);
        }
        return parameters;
    }

    public static Map<String, Object> encryptParameters(Input input, Map<String, Object> parameters) {
        HashMap<String, Object> encryptedParams = new HashMap<String, Object>(parameters);
        Set queryEncryptParam = input.getQueryEncryptParam();
        if (queryEncryptParam == null) {
            return encryptedParams;
        }
        for (String key : queryEncryptParam) {
            if (!encryptedParams.containsKey(key)) continue;
            String value = (String)encryptedParams.get(key);
            String encryptedValue = EncryptUtil.encrypt(input, value);
            encryptedParams.put(key, encryptedValue);
        }
        return encryptedParams;
    }

    public static String buildUrlWithEncryptedParams(String originalUrl, Map<String, Object> encryptedParams) {
        try {
            URL urlObj = new URL(originalUrl);
            StringBuilder queryBuilder = new StringBuilder();
            for (Map.Entry<String, Object> entry : encryptedParams.entrySet()) {
                if (queryBuilder.length() != 0) {
                    queryBuilder.append("&");
                }
                String key = entry.getKey();
                String value = entry.getValue().toString();
                String encodedValue = URLEncoder.encode(value, "UTF-8");
                queryBuilder.append(key).append("=").append(encodedValue);
            }
            String path = urlObj.getPath();
            String protocol = urlObj.getProtocol();
            String host = urlObj.getHost();
            int port = urlObj.getPort();
            StringBuilder newUrl = new StringBuilder();
            newUrl.append(protocol).append("://").append(host);
            if (port > 0 && port != 80 && port != 443) {
                newUrl.append(":").append(port);
            }
            newUrl.append(path);
            if (queryBuilder.length() != 0) {
                newUrl.append("?").append((CharSequence)queryBuilder);
            }
            return newUrl.toString();
        }
        catch (Exception e) {
            LOGGER.error("Error building URL with encrypted parameters", (Throwable)e);
            return originalUrl;
        }
    }

    public static String encryptParameters(Input input, String url) {
        if (input.getQueryEncryptParam() == null) {
            return url;
        }
        Map<String, Object> parameters = UrlParamUtil.parseUrlParameters(url);
        System.out.println("\u539f\u59cb\u53c2\u6570: " + parameters);
        Map<String, Object> encryptedParams = UrlParamUtil.encryptParameters(input, parameters);
        System.out.println("\u52a0\u5bc6\u540e\u7684\u53c2\u6570: " + encryptedParams);
        String newUrl = UrlParamUtil.buildUrlWithEncryptedParams(url, encryptedParams);
        System.out.println("\u65b0\u7684 URL: " + newUrl);
        return newUrl;
    }
}

