/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.ds.process.http.util;

import com.jxdinfo.hussar.ds.process.http.serve.EncryptParser;
import com.jxdinfo.hussar.ds.process.http.util.EncryptBeanUtil;
import com.jxdinfo.hussar.ds.process.http.util.KeyParseUtil;
import com.jxdinfo.hussar.ds.process.model.Input;
import com.jxdinfo.hussar.ds.process.model.Key;

public class EncryptUtil {
    public static String encrypt(Input input, String plainText) {
        Key encrypTkey = input.getEncryptKey();
        if (encrypTkey == null) {
            return plainText;
        }
        String key = encrypTkey.getKey();
        String encryptType = encrypTkey.getEncryptType();
        String keyType = encrypTkey.getKeyType();
        if (key == null || encryptType == null || keyType == null) {
            return plainText;
        }
        byte[] bytes = KeyParseUtil.parseKey(keyType, key);
        EncryptParser encryptParser = EncryptBeanUtil.getEncryptParser(encryptType);
        return encryptParser.encrypt(plainText, bytes);
    }

    public static String decrypt(Input input, String cipherText) {
        Key decryptKey = input.getDecryptKey();
        if (decryptKey == null) {
            return cipherText;
        }
        String key = decryptKey.getKey();
        String encryptType = decryptKey.getEncryptType();
        String keyType = decryptKey.getKeyType();
        if (key == null || encryptType == null || keyType == null) {
            return cipherText;
        }
        byte[] bytes = KeyParseUtil.parseKey(keyType, key);
        EncryptParser encryptParser = EncryptBeanUtil.getEncryptParser(encryptType);
        return encryptParser.decrypt(cipherText, bytes);
    }
}

