/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.ds.process.util;

import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.ds.process.enums.FieldTypeEnum;
import java.util.function.BiFunction;

public class DataTypeUtil {
    public static String getDuckDbType(String dataType) {
        FieldTypeEnum frontTypeEnum = FieldTypeEnum.fromValue(dataType);
        switch (frontTypeEnum) {
            case BOOLEAN: {
                return "BOOLEAN";
            }
            case STRING: {
                return "VARCHAR";
            }
            case INTEGER: {
                return "INTEGER";
            }
            case LONG: {
                return "BIGINT";
            }
            case DOUBLE: {
                return "DOUBLE";
            }
            case DATE: {
                return "DATE";
            }
        }
        return "VARCHAR";
    }

    public static BiFunction<JSONObject, String, Object> getFunctionByDataType(String dataType) {
        FieldTypeEnum frontTypeEnum = FieldTypeEnum.fromValue(dataType);
        switch (frontTypeEnum) {
            case BOOLEAN: {
                return JSONObject::getBoolean;
            }
            case STRING: {
                return JSONObject::getString;
            }
            case INTEGER: {
                return JSONObject::getInteger;
            }
            case LONG: {
                return JSONObject::getLong;
            }
            case DOUBLE: {
                return JSONObject::getDouble;
            }
            case DATE: {
                return JSONObject::getSqlDate;
            }
            case TIMESTAMP: {
                return JSONObject::getTimestamp;
            }
        }
        return JSONObject::getString;
    }

    public static Object getDataByKeyAndType(JSONObject param, String dataType, String key) {
        BiFunction<JSONObject, String, Object> functionByDataType = DataTypeUtil.getFunctionByDataType(dataType);
        return functionByDataType.apply(param, key);
    }
}

