/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.ds.process.formula.strategy.impl;

import com.jxdinfo.hussar.ds.process.formula.model.ExpressionParser;
import com.jxdinfo.hussar.ds.process.formula.strategy.DateCommonFunctionStrategy;
import com.jxdinfo.hussar.ds.process.formula.strategy.FunctionStrategy;
import com.jxdinfo.hussar.ds.process.formula.strategy.NumberCommonFunctionStrategy;
import com.jxdinfo.hussar.mail.core.date.DateUtil;
import com.jxdinfo.hussar.support.exception.HussarException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Date;
import java.util.List;
import java.util.Map;

public class YearFracFunctionStrategyImpl
implements FunctionStrategy,
NumberCommonFunctionStrategy,
DateCommonFunctionStrategy {
    private static final Integer[] BIG_MONTH = new Integer[]{1, 3, 5, 7, 8, 10, 12};
    private static final Integer[] SMALL_MONTH = new Integer[]{4, 6, 9, 11};

    @Override
    public Object evaluatePlus(Map<String, Object> context, List<Object> arguments) {
        HussarException.throwByNull(arguments, (String)"Yearfrac\u51fd\u6570\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        HussarException.throwBy((arguments.size() < 2 ? 1 : 0) != 0, (String)"Yearfrac\u51fd\u6570\u53c2\u6570\u4e2a\u6570\u5f02\u5e38");
        Date startDate = this.getDateByObject(arguments.get(0));
        Date endDate = this.getDateByObject(arguments.get(1));
        int basics = 0;
        if (arguments.size() > 2) {
            basics = this.getNumberByObject(arguments.get(2)).intValue();
        }
        Long nNumerator = 0L;
        Double nDenom = 0.0;
        nNumerator = YearFracFunctionStrategyImpl.tmpDiffDates(startDate, endDate, basics);
        nDenom = YearFracFunctionStrategyImpl.tmpCalcAnnualBasis(startDate, endDate, basics);
        Double result = (double)nNumerator.longValue() / nDenom;
        BigDecimal tResult = new BigDecimal(result);
        return tResult.setScale(14, RoundingMode.HALF_UP).doubleValue();
    }

    public static void main(String[] args) {
        ExpressionParser.test("YEARFRAC(DATE(2012, 1, 1), DATE(2012, 7, 30))");
        ExpressionParser.test("YEARFRAC(DATE(2012,1,1),DATE(2012,7,30),1)   ");
        ExpressionParser.test("YEARFRAC(DATE(2012,1,1),DATE(2012,7,30),3)   ");
    }

    public static boolean isLeapYear(Integer year) {
        return year % 4 == 0 && year % 100 != 0 || year % 400 == 0;
    }

    public static boolean isEndOfMonth(Integer day, Integer month, Integer year) {
        for (Integer x : BIG_MONTH) {
            if (!x.equals(month)) continue;
            return day == 31;
        }
        for (Integer y : SMALL_MONTH) {
            if (!y.equals(month)) continue;
            return day == 30;
        }
        if (YearFracFunctionStrategyImpl.isLeapYear(year)) {
            return day == 29;
        }
        return day == 28;
    }

    public static Long days360(Integer startYear, Integer endYear, Integer startMonth, Integer endMonth, Integer startDay, Integer endDay) {
        return (long)((endYear - startYear) * 360 + (endMonth - startMonth) * 30) + (long)(endDay - startDay) * 1L;
    }

    public static Long tmpdays360Nasd(Date startDate, Date endDate, Integer method, Boolean useEom) {
        Integer StartDay = DateUtil.dayOfMonth((Date)startDate);
        Integer StartMonth = DateUtil.month((Date)startDate);
        Integer StartYear = DateUtil.year((Date)startDate);
        Integer EndDay = DateUtil.dayOfMonth((Date)endDate);
        Integer EndMonth = DateUtil.month((Date)endDate);
        Integer EndYear = DateUtil.year((Date)endDate);
        if (EndMonth == 2 && YearFracFunctionStrategyImpl.isEndOfMonth(EndDay, EndMonth, EndYear) && (StartMonth == 2 && YearFracFunctionStrategyImpl.isEndOfMonth(StartDay, StartMonth, StartYear) || method == 3)) {
            EndDay = 30;
        }
        if (EndDay == 31 && (StartDay >= 30 || method == 3)) {
            EndDay = 30;
        }
        if (StartDay == 31) {
            StartDay = 30;
        }
        if (useEom.booleanValue() && StartMonth == 2 && YearFracFunctionStrategyImpl.isEndOfMonth(StartDay, StartMonth, StartYear)) {
            StartDay = 30;
        }
        return YearFracFunctionStrategyImpl.days360(StartYear, EndYear, StartMonth, EndMonth, StartDay, EndDay);
    }

    public static Long tmpdays360Euro(Date startDate, Date endDate) {
        Integer StartDay = DateUtil.dayOfMonth((Date)startDate);
        Integer StartMonth = DateUtil.month((Date)startDate);
        Integer StartYear = DateUtil.year((Date)startDate);
        Integer EndDay = DateUtil.dayOfMonth((Date)endDate);
        Integer EndMonth = DateUtil.month((Date)endDate);
        Integer EndYear = DateUtil.year((Date)endDate);
        if (StartDay == 31) {
            StartDay = 30;
        }
        if (EndDay == 31) {
            EndDay = 30;
        }
        return YearFracFunctionStrategyImpl.days360(StartYear, EndYear, StartMonth, EndMonth, StartDay, EndDay);
    }

    public static Long tmpDiffDates(Date startDate, Date endDate, Integer Basis) {
        Long tmpDiffDates = 0L;
        switch (Basis) {
            case 0: {
                tmpDiffDates = YearFracFunctionStrategyImpl.tmpdays360Nasd(startDate, endDate, 0, true);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                tmpDiffDates = DateUtil.betweenDay((Date)startDate, (Date)endDate, (boolean)true);
                break;
            }
            case 4: {
                tmpDiffDates = YearFracFunctionStrategyImpl.tmpdays360Euro(startDate, endDate);
            }
        }
        return tmpDiffDates;
    }

    public static Double tmpCalcAnnualBasis(Date startDate, Date endDate, Integer Basis) {
        Integer StartDay = 0;
        Integer StartMonth = 0;
        Integer StartYear = 0;
        Integer EndDay = 0;
        Integer EndMonth = 0;
        Integer EndYear = 0;
        Integer iYear = 0;
        Double tmpCalcAnnualBasis = 0.0;
        switch (Basis) {
            case 0: 
            case 2: 
            case 4: {
                tmpCalcAnnualBasis = 360.0;
                break;
            }
            case 3: {
                tmpCalcAnnualBasis = 365.0;
                break;
            }
            case 1: {
                StartDay = DateUtil.dayOfMonth((Date)startDate);
                StartMonth = DateUtil.month((Date)startDate);
                StartYear = DateUtil.year((Date)startDate);
                EndDay = DateUtil.dayOfMonth((Date)endDate);
                EndMonth = DateUtil.month((Date)endDate);
                EndYear = DateUtil.year((Date)endDate);
                if (StartYear == EndYear) {
                    if (YearFracFunctionStrategyImpl.isLeapYear(StartYear)) {
                        tmpCalcAnnualBasis = 366.0;
                        break;
                    }
                    tmpCalcAnnualBasis = 365.0;
                    break;
                }
                if (EndYear - 1 == StartYear && (StartMonth > EndMonth || StartMonth == EndMonth && StartDay >= EndDay)) {
                    if (YearFracFunctionStrategyImpl.isLeapYear(StartYear)) {
                        if (StartMonth < 2 || StartMonth == 2 && StartDay <= 29) {
                            tmpCalcAnnualBasis = 366.0;
                            break;
                        }
                        tmpCalcAnnualBasis = 365.0;
                        break;
                    }
                    if (YearFracFunctionStrategyImpl.isLeapYear(EndYear)) {
                        if (EndMonth > 2 || EndMonth == 2 && EndDay == 29) {
                            tmpCalcAnnualBasis = 366.0;
                            break;
                        }
                        tmpCalcAnnualBasis = 365.0;
                        break;
                    }
                    tmpCalcAnnualBasis = 365.0;
                    break;
                }
                iYear = StartYear;
                while (iYear <= EndYear) {
                    tmpCalcAnnualBasis = YearFracFunctionStrategyImpl.isLeapYear(iYear) ? Double.valueOf(tmpCalcAnnualBasis + 366.0) : Double.valueOf(tmpCalcAnnualBasis + 365.0);
                    Integer n = iYear;
                    Integer n2 = iYear = Integer.valueOf(iYear + 1);
                }
                tmpCalcAnnualBasis = tmpCalcAnnualBasis / (double)(EndYear - StartYear + 1);
            }
        }
        return tmpCalcAnnualBasis;
    }
}

