/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.ds.process.formula.strategy.impl;

import com.jxdinfo.hussar.ds.process.formula.model.ExpressionParser;
import com.jxdinfo.hussar.ds.process.formula.strategy.DateCommonFunctionStrategy;
import com.jxdinfo.hussar.ds.process.formula.strategy.FunctionStrategy;
import com.jxdinfo.hussar.ds.process.formula.strategy.NumberCommonFunctionStrategy;
import com.jxdinfo.hussar.support.exception.HussarException;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;

public class WeekdayFunctionStrategyImpl
implements FunctionStrategy,
DateCommonFunctionStrategy,
NumberCommonFunctionStrategy {
    private static final Map<Integer, Function<Integer, Integer>> INDEX_FUNCTION = new HashMap<Integer, Function<Integer, Integer>>();
    int DEFAULT_INDEX = 1;

    @Override
    public Integer evaluatePlus(Map<String, Object> context, List<Object> arguments) {
        HussarException.throwByNull(arguments, (String)"Weekday\u51fd\u6570\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        HussarException.throwBy((arguments.size() < 1 ? 1 : 0) != 0, (String)"Weekday\u51fd\u6570\u53c2\u6570\u4e2a\u6570\u5f02\u5e38");
        int index = this.DEFAULT_INDEX;
        if (arguments.size() > 1) {
            index = this.getNumberByObject(arguments.get(1)).intValue();
        }
        Date date = this.getDateByObject(arguments.get(0));
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return INDEX_FUNCTION.get(index).apply(calendar.get(7));
    }

    public static void main(String[] args) {
        ExpressionParser.test("WEEKDAY(DATE(2025, 9, 22),1) ");
        ExpressionParser.test("WEEKDAY(DATE(2025, 9, 22),2) ");
        ExpressionParser.test("WEEKDAY(DATE(2025, 9, 22),3) ");
        ExpressionParser.test("WEEKDAY(DATE(2025, 9, 22),11) ");
        ExpressionParser.test("WEEKDAY(DATE(2025, 9, 22),12) ");
        ExpressionParser.test("WEEKDAY(DATE(2025, 9, 22),13) ");
        ExpressionParser.test("WEEKDAY(DATE(2025, 9, 22),14) ");
        ExpressionParser.test("WEEKDAY(DATE(2025, 9, 22),15) ");
        ExpressionParser.test("WEEKDAY(DATE(2025, 9, 22),16) ");
        ExpressionParser.test("WEEKDAY(DATE(2025, 9, 22),17) ");
    }

    static {
        INDEX_FUNCTION.put(1, action -> action);
        INDEX_FUNCTION.put(2, action -> (action + 5) % 7 + 1);
        INDEX_FUNCTION.put(3, action -> (action + 5) % 7);
        INDEX_FUNCTION.put(11, action -> (action + 5) % 7 + 1);
        INDEX_FUNCTION.put(12, action -> (action + 4) % 7 + 1);
        INDEX_FUNCTION.put(13, action -> (action + 3) % 7 + 1);
        INDEX_FUNCTION.put(14, action -> (action + 2) % 7 + 1);
        INDEX_FUNCTION.put(15, action -> (action + 1) % 7 + 1);
        INDEX_FUNCTION.put(16, action -> (action + 7) % 7 + 1);
        INDEX_FUNCTION.put(17, action -> (action + 6) % 7 + 1);
    }
}

