/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.ds.process.formula.strategy.impl;

import com.jxdinfo.hussar.ds.process.formula.model.ExpressionParser;
import com.jxdinfo.hussar.ds.process.formula.strategy.DateCommonFunctionStrategy;
import com.jxdinfo.hussar.ds.process.formula.strategy.FunctionStrategy;
import com.jxdinfo.hussar.ds.process.formula.strategy.NumberCommonFunctionStrategy;
import com.jxdinfo.hussar.support.exception.HussarException;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;

public class WeekNumFunctionStrategyImpl
implements FunctionStrategy,
DateCommonFunctionStrategy,
NumberCommonFunctionStrategy {
    private static final Map<Integer, Consumer<Calendar>> INDEX_FUNCTION = new HashMap<Integer, Consumer<Calendar>>();
    int DEFAULT_INDEX = 1;

    @Override
    public Object evaluatePlus(Map<String, Object> context, List<Object> arguments) {
        Consumer<Calendar> calendarConsumer;
        HussarException.throwByNull(arguments, (String)"Weeknum\u51fd\u6570\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        HussarException.throwBy((arguments.size() != 2 ? 1 : 0) != 0, (String)"Weeknum\u51fd\u6570\u53c2\u6570\u4e2a\u6570\u5f02\u5e38");
        Date date = this.getDateByObject(arguments.get(0));
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        int index = this.DEFAULT_INDEX;
        if (arguments.size() > 1) {
            index = this.getNumberByObject(arguments.get(1)).intValue();
        }
        if ((calendarConsumer = INDEX_FUNCTION.get(index)) != null) {
            calendarConsumer.accept(calendar);
        }
        return calendar.get(3);
    }

    public static void main(String[] args) {
        ExpressionParser.test("WEEKNUM(DATE(2025, 1,8),1) ");
        ExpressionParser.test("WEEKNUM(DATE(2025, 1,8),2) ");
        ExpressionParser.test("WEEKNUM(DATE(2025, 1,8),11) ");
        ExpressionParser.test("WEEKNUM(DATE(2025, 1,8),12) ");
        ExpressionParser.test("WEEKNUM(DATE(2025, 1,8),13) ");
        ExpressionParser.test("WEEKNUM(DATE(2025, 1,8),14) ");
        ExpressionParser.test("WEEKNUM(DATE(2025, 1,8),15) ");
        ExpressionParser.test("WEEKNUM(DATE(2025, 1,8),16) ");
        ExpressionParser.test("WEEKNUM(DATE(2025, 1,8),17) ");
        ExpressionParser.test("WEEKNUM(DATE(2025, 1,8),21) ");
    }

    static {
        INDEX_FUNCTION.put(1, action -> action.setFirstDayOfWeek(1));
        INDEX_FUNCTION.put(11, action -> action.setFirstDayOfWeek(2));
        INDEX_FUNCTION.put(12, action -> action.setFirstDayOfWeek(3));
        INDEX_FUNCTION.put(13, action -> action.setFirstDayOfWeek(4));
        INDEX_FUNCTION.put(14, action -> action.setFirstDayOfWeek(5));
        INDEX_FUNCTION.put(15, action -> action.setFirstDayOfWeek(6));
        INDEX_FUNCTION.put(16, action -> action.setFirstDayOfWeek(7));
        INDEX_FUNCTION.put(17, action -> action.setFirstDayOfWeek(1));
        INDEX_FUNCTION.put(2, action -> {
            action.setFirstDayOfWeek(2);
            action.setMinimalDaysInFirstWeek(4);
        });
        INDEX_FUNCTION.put(21, action -> {
            action.setFirstDayOfWeek(1);
            action.setMinimalDaysInFirstWeek(4);
        });
    }
}

