/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.ds.process.formula.strategy.impl;

import com.jxdinfo.hussar.ds.process.formula.model.ExprNode;
import com.jxdinfo.hussar.ds.process.formula.model.ExpressionParser;
import com.jxdinfo.hussar.ds.process.formula.strategy.FunctionStrategy;
import com.jxdinfo.hussar.support.exception.HussarException;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;

public class TextFunctionStrategyImpl
implements FunctionStrategy {
    private static final Map<String, Function<Calendar, Object>> MARK_FUNCTION = new LinkedHashMap<String, Function<Calendar, Object>>();
    private static final List<String> MONTH_LIST = Arrays.asList("\u4e00\u6708", "\u4e8c\u6708", "\u4e09\u6708", "\u56db\u6708", "\u4e94\u6708", "\u516d\u6708", "\u4e03\u6708", "\u516b\u6708", "\u4e5d\u6708", "\u5341\u6708", "\u5341\u4e00\u6708", "\u5341\u4e8c\u6708");
    private static final List<String> WEEK_LIST = Arrays.asList("\u65e5", "\u4e00", "\u4e8c", "\u4e09", "\u56db", "\u4e94", "\u516d");
    private static final String WEEK_PRE = "\u661f\u671f";

    @Override
    public Object evaluate(Map<String, Object> context, List<ExprNode> arguments) {
        HussarException.throwByNull(arguments, (String)"TEXT\u51fd\u6570\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        HussarException.throwBy((arguments.size() != 2 ? 1 : 0) != 0, (String)"TEXT\u51fd\u6570\u53c2\u6570\u53ea\u80fd\u4e3a2\u4e2a");
        Object info = arguments.get(0).evaluate(context);
        String format = String.valueOf(arguments.get(1).evaluate(context));
        if (info instanceof Date) {
            Date date = (Date)info;
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(date);
            for (String key : MARK_FUNCTION.keySet()) {
                format = format.replace(key, String.valueOf(MARK_FUNCTION.get(key).apply(calendar)));
            }
            return format;
        }
        if (info instanceof Number) {
            throw new HussarException("Text\u51fd\u6570\u672a\u5b9e\u73b0\u8bf7\u8054\u7cfb\u540e\u53f0\u5f00\u53d1\u4eba\u5458");
        }
        throw new HussarException("TEXT\u51fd\u6570\u7b2c\u4e00\u4e2a\u53c2\u6570\u5fc5\u987b\u4e3a\u65e5\u671f\u6216\u6570\u5b57");
    }

    public static void main(String[] args) {
        ExpressionParser.test("TEXT(NOW(), \"yyyy-MM-dd HH:mm:ss S SS SSS a A E EE EEE W WW\")");
    }

    private static String geta(Calendar calendar) {
        if (calendar.get(9) == 0) {
            return "AM";
        }
        if (calendar.get(9) == 1) {
            return "PM";
        }
        return "-";
    }

    private static String getA(Calendar calendar) {
        if (calendar.get(9) == 0) {
            return "\u4e0a\u5348";
        }
        if (calendar.get(9) == 1) {
            return "\u4e0b\u5348";
        }
        return "-";
    }

    private static String getMMM(Calendar calendar) {
        return MONTH_LIST.get(calendar.get(2));
    }

    private static Object getEEE(Calendar calendar) {
        return WEEK_PRE.concat(WEEK_LIST.get(calendar.get(7)));
    }

    private static Object getEE(Calendar calendar) {
        return WEEK_LIST.get(calendar.get(7));
    }

    static {
        MARK_FUNCTION.put("yyyy", action -> action.get(1));
        MARK_FUNCTION.put("yy", action -> action.get(1) % 100);
        MARK_FUNCTION.put("MMM", TextFunctionStrategyImpl::getMMM);
        MARK_FUNCTION.put("MM", action -> String.format("%02d", action.get(2) + 1));
        MARK_FUNCTION.put("M", action -> action.get(2) + 1);
        MARK_FUNCTION.put("dd", action -> String.format("%02d", action.get(5)));
        MARK_FUNCTION.put("d", action -> action.get(5));
        MARK_FUNCTION.put("HH", action -> String.format("%02d", action.get(11)));
        MARK_FUNCTION.put("H", action -> action.get(11));
        MARK_FUNCTION.put("mm", action -> String.format("%02d", action.get(12)));
        MARK_FUNCTION.put("m", action -> action.get(12));
        MARK_FUNCTION.put("ss", action -> String.format("%02d", action.get(13)));
        MARK_FUNCTION.put("s", action -> action.get(13));
        MARK_FUNCTION.put("SSS", action -> String.format("%03d", action.get(14)));
        MARK_FUNCTION.put("SS", action -> String.format("%02d", action.get(14)));
        MARK_FUNCTION.put("S", action -> action.get(14));
        MARK_FUNCTION.put("a", TextFunctionStrategyImpl::geta);
        MARK_FUNCTION.put("A", TextFunctionStrategyImpl::getA);
        MARK_FUNCTION.put("EEE", TextFunctionStrategyImpl::getEEE);
        MARK_FUNCTION.put("EE", TextFunctionStrategyImpl::getEE);
        MARK_FUNCTION.put("E", action -> action.get(7));
        MARK_FUNCTION.put("WW", action -> String.format("%02d", action.get(3)));
        MARK_FUNCTION.put("W", action -> action.get(3));
    }
}

