/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.ds.process.formula.strategy.impl;

import com.jxdinfo.hussar.ds.process.formula.model.ExpressionParser;
import com.jxdinfo.hussar.ds.process.formula.strategy.NumberCommonFunctionStrategy;
import com.jxdinfo.hussar.support.exception.HussarException;
import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;
import java.util.List;
import java.util.Map;

public class PowerFunctionStrategyImpl
implements NumberCommonFunctionStrategy {
    @Override
    public Object evaluatePlus(Map<String, Object> context, List<Object> arguments) {
        HussarException.throwByNull(arguments, (String)"Power\u51fd\u6570\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        HussarException.throwBy((arguments.size() != 2 ? 1 : 0) != 0, (String)"Power\u51fd\u6570\u53c2\u6570\u4e2a\u6570\u5f02\u5e38");
        BigDecimal number = this.getNumberByObject(arguments.get(0));
        BigDecimal power = this.getNumberByObject(arguments.get(1));
        MathContext mc = new MathContext(10, RoundingMode.HALF_UP);
        return PowerFunctionStrategyImpl.powerDecimal(number, power, mc);
    }

    public static BigDecimal powerDecimal(BigDecimal base, BigDecimal exponent, MathContext mc) {
        if (base.compareTo(BigDecimal.ZERO) <= 0) {
            throw new IllegalArgumentException("\u5e95\u6570\u5fc5\u987b\u5927\u4e8e\u96f6");
        }
        try {
            double baseDouble = base.doubleValue();
            double exponentDouble = exponent.doubleValue();
            double result = Math.pow(baseDouble, exponentDouble);
            return new BigDecimal(result, mc);
        }
        catch (NumberFormatException e) {
            throw new ArithmeticException("\u6570\u503c\u8d85\u51fa\u8303\u56f4");
        }
    }

    public static void main(String[] args) {
        ExpressionParser.test("POWER(5,2)      ");
        ExpressionParser.test("POWER(98.6,3.2) ");
        ExpressionParser.test("POWER(4,5/4)    ");
    }
}

