/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.ds.process.formula.strategy.impl;

import com.jxdinfo.hussar.ds.process.formula.model.ExpressionParser;
import com.jxdinfo.hussar.ds.process.formula.strategy.DateCommonFunctionStrategy;
import com.jxdinfo.hussar.ds.process.formula.strategy.FunctionStrategy;
import com.jxdinfo.hussar.support.exception.HussarException;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class NetWorkdaysFunctionStrategyImpl
implements FunctionStrategy,
DateCommonFunctionStrategy {
    @Override
    public Object evaluatePlus(Map<String, Object> context, List<Object> arguments) {
        HussarException.throwByNull(arguments, (String)"Networkdays\u51fd\u6570\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        HussarException.throwBy((arguments.size() < 2 ? 1 : 0) != 0, (String)"Networkdays\u51fd\u6570\u53c2\u6570\u4e2a\u6570\u5f02\u5e38");
        Date startTime = this.getDateByObject(arguments.get(0));
        Date endTime = this.getDateByObject(arguments.get(1));
        long endTimeInMillis = endTime.getTime();
        HashSet<Integer> holidays = new HashSet<Integer>();
        if (arguments.size() > 2) {
            this.getHolidays(holidays, arguments.get(2));
        }
        int count = 0;
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(startTime);
        while (endTimeInMillis >= calendar.getTimeInMillis()) {
            int date;
            int dayOfWeek = calendar.get(7);
            if (dayOfWeek != 1 && dayOfWeek != 7 && !holidays.contains(date = calendar.get(1) * 10000 + (calendar.get(2) + 1) * 100 + calendar.get(5))) {
                ++count;
            }
            calendar.add(5, 1);
        }
        return count;
    }

    private void getHolidays(Set<Integer> set, Object param) {
        if (param instanceof Iterable) {
            ((Iterable)param).forEach(action -> this.getHolidays(set, action));
        }
        Date date = this.getDateByObject(param);
        set.add(this.getIntDate(date));
    }

    public static void main(String[] args) {
        ExpressionParser.test("NETWORKDAYS('2013-12-04', '2013-12-04')");
        ExpressionParser.test("NETWORKDAYS('2013-12-04', '2013-12-06')    ");
        ExpressionParser.test("NETWORKDAYS('2013-12-04', '2013-12-08')    ");
        ExpressionParser.test("NETWORKDAYS('2013-12-04', '2013-12-09')    ");
        ExpressionParser.test("NETWORKDAYS('2013-12-07', '2013-12-08')    ");
        ExpressionParser.test("NETWORKDAYS('2013-12-04', '2014 -01-04', '2014-01-01')        ");
        ExpressionParser.test("NETWORKDAYS('12/4/2013', '1/4/2014', '1/1/2014') ");
    }
}

