/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.ds.process.formula.strategy.impl;

import com.jxdinfo.hussar.ds.process.formula.enums.FunctionErrorEnum;
import com.jxdinfo.hussar.ds.process.formula.model.ExpressionParser;
import com.jxdinfo.hussar.ds.process.formula.strategy.NumberCommonFunctionStrategy;
import com.jxdinfo.hussar.support.exception.HussarException;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;

public class ModFunctionStrategyImpl
implements NumberCommonFunctionStrategy {
    @Override
    public Object evaluatePlus(Map<String, Object> context, List<Object> arguments) {
        HussarException.throwByNull(arguments, (String)"Mod\u51fd\u6570\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        HussarException.throwBy((arguments.size() != 2 ? 1 : 0) != 0, (String)"Mod\u51fd\u6570\u53c2\u6570\u4e2a\u6570\u5f02\u5e38");
        BigDecimal number = this.getNumberByObject(arguments.get(0));
        BigDecimal divisor = this.getNumberByObject(arguments.get(1));
        if (divisor.compareTo(BigDecimal.ZERO) == 0) {
            return FunctionErrorEnum.DIVIDE_BY_ZERO;
        }
        BigDecimal remainder = number.remainder(divisor);
        if (remainder.compareTo(BigDecimal.ZERO) != 0 && remainder.signum() != divisor.signum()) {
            remainder = remainder.add(divisor);
        }
        return remainder;
    }

    public static void main(String[] args) {
        ExpressionParser.test(" MOD(3,2)   ");
        ExpressionParser.test(" MOD(-3,2)  ");
        ExpressionParser.test(" MOD(3,-2)  ");
        ExpressionParser.test(" MOD(-3, -2)");
        ExpressionParser.test(" MOD(-3, -0)");
    }
}

