/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.ds.process.formula.strategy.impl;

import com.jxdinfo.hussar.ds.process.formula.model.ExpressionParser;
import com.jxdinfo.hussar.ds.process.formula.strategy.NumberCommonFunctionStrategy;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.exception.HussarException;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MinFunctionStrategyImpl
implements NumberCommonFunctionStrategy {
    Logger log = LoggerFactory.getLogger(MinFunctionStrategyImpl.class);

    @Override
    public Object evaluatePlus(Map<String, Object> context, List<Object> arguments) {
        HussarException.throwByNull(arguments, (String)"Min\u51fd\u6570\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        HussarException.throwBy((arguments.size() < 1 ? 1 : 0) != 0, (String)"Min\u51fd\u6570\u53c2\u6570\u4e2a\u6570\u5f02\u5e38");
        try {
            return this.getMin(arguments);
        }
        catch (Exception e) {
            this.log.info("\u89e3\u6790\u5f02\u5e38\u6309\u71670\u8fd4\u56de");
            return BigDecimal.ZERO;
        }
    }

    public BigDecimal getMin(Object param) {
        if (HussarUtils.isEmpty((Object)param)) {
            throw new HussarException("\u6570\u636e\u5f02\u5e38");
        }
        if (param instanceof Iterable) {
            BigDecimal min = BigDecimal.valueOf(Long.MAX_VALUE);
            for (Object action : (Iterable)param) {
                BigDecimal current = this.getMin(action);
                if (min.compareTo(current) <= 0) continue;
                min = current;
            }
            return min;
        }
        if (param instanceof Number) {
            return this.getNumberByObject(param);
        }
        throw new HussarException("\u6570\u636e\u5f02\u5e38");
    }

    public static void main(String[] args) {
        ExpressionParser.test("MIN(1,2,3) ");
        ExpressionParser.test("MIN(true) ");
        ExpressionParser.test("MIN(false) ");
        ExpressionParser.test("MIN(false,true) ");
        ExpressionParser.test("MIN(false,true,0,2) ");
    }
}

