/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.ds.process.formula.strategy.impl;

import com.jxdinfo.hussar.ds.process.formula.dto.FormulaConfigDTO;
import com.jxdinfo.hussar.ds.process.formula.model.ExprNode;
import com.jxdinfo.hussar.ds.process.formula.model.ExpressionParser;
import com.jxdinfo.hussar.ds.process.formula.strategy.DateCommonFunctionStrategy;
import com.jxdinfo.hussar.support.exception.HussarException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class DaysFunctionStrategyImpl
implements DateCommonFunctionStrategy {
    @Override
    public Object evaluate(Map<String, Object> context, List<ExprNode> arguments) {
        HussarException.throwByNull(arguments, (String)"Days\u51fd\u6570\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        HussarException.throwBy((arguments.size() != 2 ? 1 : 0) != 0, (String)"Days\u51fd\u6570\u53c2\u6570\u53ea\u80fd\u4e3a2\u4e2a");
        try {
            Date start = this.getDateByObject(arguments.get(0).evaluate(context));
            Date end = this.getDateByObject(arguments.get(1).evaluate(context));
            return new BigDecimal(Math.abs(start.getTime() - end.getTime())).divide(new BigDecimal(TimeUnit.DAYS.toMillis(1L)), 4, RoundingMode.DOWN).intValue();
        }
        catch (Exception e) {
            return "#VALUE! \u9519\u8bef\u503c";
        }
    }

    public static void main(String[] args) {
        for (String expression : Arrays.asList("DAYS(\"2023-09-11\", \"2023-08-31\")", "DAYS(\"2023-09-11\", \"2023-09-01\")")) {
            System.out.println(ExpressionParser.BuildByConfig(new FormulaConfigDTO(expression)).evaluate(null));
        }
    }
}

