/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.ds.process.formula.strategy.impl;

import com.jxdinfo.hussar.ds.process.formula.dto.FormulaConfigDTO;
import com.jxdinfo.hussar.ds.process.formula.model.ExprNode;
import com.jxdinfo.hussar.ds.process.formula.model.ExpressionParser;
import com.jxdinfo.hussar.ds.process.formula.strategy.DateCommonFunctionStrategy;
import com.jxdinfo.hussar.support.exception.HussarException;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Days360FunctionStrategyImpl
implements DateCommonFunctionStrategy {
    @Override
    public Object evaluate(Map<String, Object> context, List<ExprNode> arguments) {
        HussarException.throwByNull(arguments, (String)"Days360\u51fd\u6570\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        HussarException.throwBy((arguments.size() != 3 ? 1 : 0) != 0, (String)"Days360\u51fd\u6570\u53c2\u6570\u53ea\u80fd\u4e3a3\u4e2a");
        try {
            Date start = this.getDateByObject(arguments.get(0).evaluate(context));
            Date end = this.getDateByObject(arguments.get(1).evaluate(context));
            Object method = arguments.get(2).evaluate(context);
            int days = ((this.getYear(end) - this.getYear(start)) * 12 + this.getMonth(end) - this.getMonth(start)) * 30;
            int startDay = this.getDay(start);
            int endDay = this.getDay(end);
            if (Boolean.TRUE.equals(method)) {
                startDay = Math.min(startDay, 30);
                endDay = Math.min(endDay, 30);
            } else {
                if (this.getMonthLastDay(start) == startDay) {
                    startDay = 30;
                }
                if (this.getMonthLastDay(end) == endDay) {
                    endDay = startDay < 30 ? 31 : 30;
                }
            }
            return days + endDay - startDay;
        }
        catch (Exception e) {
            return "#VALUE! \u9519\u8bef\u503c";
        }
    }

    public static void main(String[] args) {
        for (String expression : Arrays.asList("DAYS360('2025-09-23', '2025-11-01', false)")) {
            System.out.println(ExpressionParser.BuildByConfig(new FormulaConfigDTO(expression)).evaluate(new HashMap<String, Object>()));
        }
    }
}

