/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.ds.process.formula.strategy.impl;

import com.jxdinfo.hussar.ds.process.formula.model.ExprNode;
import com.jxdinfo.hussar.ds.process.formula.strategy.DateCommonFunctionStrategy;
import com.jxdinfo.hussar.support.exception.HussarException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import java.util.function.BiFunction;

public class DateDifFunctionStrategyImpl
implements DateCommonFunctionStrategy {
    private static final Map<String, BiFunction<Calendar, Calendar, Integer>> UNIT_FUNCTION = new TreeMap<String, BiFunction<Calendar, Calendar, Integer>>(String.CASE_INSENSITIVE_ORDER);

    @Override
    public Object evaluate(Map<String, Object> context, List<ExprNode> arguments) {
        HussarException.throwByNull(arguments, (String)"DateDif\u7ec4\u4ef6\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        HussarException.throwBy((arguments.size() != 3 ? 1 : 0) != 0, (String)"DateDif\u7ec4\u4ef6\u53c2\u6570\u5fc5\u987b\u4e3a3\u4e2a");
        Date startDate = this.getDateByObject(arguments.get(0).evaluate(context));
        Date endDate = this.getDateByObject(arguments.get(1).evaluate(context));
        String unit = arguments.get(2).evaluate(context).toString().toUpperCase();
        Calendar start = Calendar.getInstance();
        start.setTime(startDate);
        Calendar end = Calendar.getInstance();
        end.setTime(endDate);
        Integer apply = UNIT_FUNCTION.get(unit).apply(start, end);
        if (apply >= BigDecimal.ZERO.intValue()) {
            return apply;
        }
        return "#NUM! \u9519\u8bef";
    }

    static {
        UNIT_FUNCTION.put("Y", (start, end) -> end.get(1) - start.get(1));
        UNIT_FUNCTION.put("YM", (start, end) -> end.get(2) - start.get(2));
        UNIT_FUNCTION.put("MD", (start, end) -> end.get(5) - start.get(5));
        UNIT_FUNCTION.put("D", (start, end) -> new BigDecimal(end.getTimeInMillis() - start.getTimeInMillis()).divide(new BigDecimal(TimeUnit.DAYS.toMillis(1L)), 4, RoundingMode.DOWN).intValue());
        UNIT_FUNCTION.put("M", (start, end) -> UNIT_FUNCTION.get("Y").apply((Calendar)start, (Calendar)end) * 12 + UNIT_FUNCTION.get("YM").apply((Calendar)start, (Calendar)end));
        UNIT_FUNCTION.put("YD", (start, end) -> {
            start.set(1, end.get(1));
            return UNIT_FUNCTION.get("D").apply((Calendar)start, (Calendar)end);
        });
    }
}

