/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.ds.process.formula.model;

import com.jxdinfo.hussar.ds.process.formula.model.ExprNode;
import java.util.Map;

public class OperatorNode
implements ExprNode {
    String operator;
    ExprNode left;
    ExprNode right;

    public OperatorNode(String operator, ExprNode left, ExprNode right) {
        this.operator = operator;
        this.left = left;
        this.right = right;
    }

    @Override
    public Object evaluate(Map<String, Object> context) {
        Object leftVal = this.left.evaluate(context);
        Object rightVal = this.right.evaluate(context);
        switch (this.operator) {
            case "==": {
                return this.equals(leftVal, rightVal);
            }
            case "!=": {
                return !this.equals(leftVal, rightVal);
            }
            case ">": {
                return this.compare(leftVal, rightVal) > 0;
            }
            case "<": {
                return this.compare(leftVal, rightVal) < 0;
            }
            case ">=": {
                return this.compare(leftVal, rightVal) >= 0;
            }
            case "<=": {
                return this.compare(leftVal, rightVal) <= 0;
            }
            case "+": {
                return this.add(leftVal, rightVal);
            }
            case "-": {
                return this.subtract(leftVal, rightVal);
            }
            case "*": {
                return this.multiply(leftVal, rightVal);
            }
            case "/": {
                return this.divide(leftVal, rightVal);
            }
        }
        throw new RuntimeException("\u672a\u77e5\u64cd\u4f5c\u7b26: " + this.operator);
    }

    private boolean equals(Object a, Object b) {
        if (a == null) {
            return b == null;
        }
        return a.equals(b);
    }

    private int compare(Object a, Object b) {
        if (a instanceof Number && b instanceof Number) {
            return Double.compare(((Number)a).doubleValue(), ((Number)b).doubleValue());
        }
        throw new RuntimeException("\u6bd4\u8f83\u64cd\u4f5c\u9700\u8981\u6570\u503c\u7c7b\u578b");
    }

    private Object add(Object a, Object b) {
        if (a instanceof Number && b instanceof Number) {
            return ((Number)a).doubleValue() + ((Number)b).doubleValue();
        }
        return String.valueOf(a) + String.valueOf(b);
    }

    private Object subtract(Object a, Object b) {
        return ((Number)a).doubleValue() - ((Number)b).doubleValue();
    }

    private Object multiply(Object a, Object b) {
        return ((Number)a).doubleValue() * ((Number)b).doubleValue();
    }

    private Object divide(Object a, Object b) {
        double divisor = ((Number)b).doubleValue();
        if (divisor == 0.0) {
            throw new RuntimeException("\u9664\u6570\u4e0d\u80fd\u4e3a\u96f6");
        }
        return ((Number)a).doubleValue() / divisor;
    }

    @Override
    public String toString() {
        return "(" + this.left + " " + this.operator + " " + this.right + ")";
    }
}

