/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.ds.process.formula.model;

import com.jxdinfo.hussar.ds.process.formula.enums.FunctionEnum;
import com.jxdinfo.hussar.ds.process.formula.model.ExprNode;
import java.util.List;
import java.util.Map;

public class FunctionNode
implements ExprNode {
    FunctionEnum functionName;
    List<ExprNode> arguments;

    public FunctionNode(FunctionEnum functionName, List<ExprNode> arguments) {
        this.functionName = functionName;
        this.arguments = arguments;
    }

    @Override
    public Object evaluate(Map<String, Object> context) {
        return this.functionName.evaluate(context, this.arguments);
    }

    private Object evaluateIfs(Map<String, Object> context) {
        Object condition = this.arguments.get(0).evaluate(context);
        if (condition instanceof Boolean) {
            return (Boolean)condition != false ? this.arguments.get(1).evaluate(context) : this.arguments.get(2).evaluate(context);
        }
        throw new RuntimeException("IF\u51fd\u6570\u7684\u7b2c\u4e00\u4e2a\u53c2\u6570\u5fc5\u987b\u662f\u5e03\u5c14\u503c");
    }

    private Object evaluateIf(Map<String, Object> context) {
        if (this.arguments.size() != 3) {
            throw new RuntimeException("IF\u51fd\u6570\u9700\u89813\u4e2a\u53c2\u6570");
        }
        Object condition = this.arguments.get(0).evaluate(context);
        if (condition instanceof Boolean) {
            return (Boolean)condition != false ? this.arguments.get(1).evaluate(context) : this.arguments.get(2).evaluate(context);
        }
        throw new RuntimeException("IF\u51fd\u6570\u7684\u7b2c\u4e00\u4e2a\u53c2\u6570\u5fc5\u987b\u662f\u5e03\u5c14\u503c");
    }

    private Object evaluateSum(Map<String, Object> context) {
        double sum = 0.0;
        for (ExprNode arg : this.arguments) {
            Object value = arg.evaluate(context);
            if (!(value instanceof Number)) continue;
            sum += ((Number)value).doubleValue();
        }
        return sum;
    }

    private Object evaluateAvg(Map<String, Object> context) {
        if (this.arguments.isEmpty()) {
            return 0.0;
        }
        double sum = ((Number)this.evaluateSum(context)).doubleValue();
        return sum / (double)this.arguments.size();
    }

    private Object evaluateMax(Map<String, Object> context) {
        if (this.arguments.isEmpty()) {
            return 0.0;
        }
        double max = Double.NEGATIVE_INFINITY;
        for (ExprNode arg : this.arguments) {
            Object value = arg.evaluate(context);
            if (!(value instanceof Number)) continue;
            max = Math.max(max, ((Number)value).doubleValue());
        }
        return max;
    }

    private Object evaluateMin(Map<String, Object> context) {
        if (this.arguments.isEmpty()) {
            return 0.0;
        }
        double min = Double.POSITIVE_INFINITY;
        for (ExprNode arg : this.arguments) {
            Object value = arg.evaluate(context);
            if (!(value instanceof Number)) continue;
            min = Math.min(min, ((Number)value).doubleValue());
        }
        return min;
    }

    @Override
    public String toString() {
        return (Object)((Object)this.functionName) + "(" + this.arguments + ")";
    }
}

