/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.ds.process.formula.model;

import com.jxdinfo.hussar.ds.process.formula.dto.FormulaConfigDTO;
import com.jxdinfo.hussar.ds.process.formula.dto.FormulaMarkDTO;
import com.jxdinfo.hussar.ds.process.formula.enums.FunctionEnum;
import com.jxdinfo.hussar.ds.process.formula.model.ConstantNode;
import com.jxdinfo.hussar.ds.process.formula.model.ExprNode;
import com.jxdinfo.hussar.ds.process.formula.model.FunctionNode;
import com.jxdinfo.hussar.ds.process.formula.model.OperatorNode;
import com.jxdinfo.hussar.ds.process.formula.model.VariableNode;
import com.jxdinfo.hussar.platform.core.utils.JsonUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ExpressionParser {
    private String expression;
    private int index;
    private List<FormulaMarkDTO> formulaMark;

    public static void main(String[] args) {
        FormulaConfigDTO formulaConfigDTO = (FormulaConfigDTO)JsonUtil.parse((String)"{\"formulaId\":\"a9c1f5fe-e18a-4d92-856c-a1b85a7b8cf7\",\"formulaMark\":[{\"from\":{\"line\":0,\"ch\":4},\"to\":{\"line\":0,\"ch\":8},\"index\":0},{\"from\":{\"line\":0,\"ch\":19},\"to\":{\"line\":0,\"ch\":23},\"index\":1},{\"from\":{\"line\":0,\"ch\":31},\"to\":{\"line\":0,\"ch\":35},\"index\":2},{\"from\":{\"line\":0,\"ch\":36},\"to\":{\"line\":0,\"ch\":40},\"index\":3},{\"from\":{\"line\":0,\"ch\":44},\"to\":{\"line\":0,\"ch\":48},\"index\":4},{\"from\":{\"line\":0,\"ch\":59},\"to\":{\"line\":0,\"ch\":63},\"index\":5},{\"from\":{\"line\":0,\"ch\":74},\"to\":{\"line\":0,\"ch\":78},\"index\":6}],\"formulaParam\":[{\"configData\":\"inputmy64lhzftlv\",\"dataType\":\"string\",\"replacedStr\":\"\u5355\u884c\u6587\u672c\",\"type\":\"field\"},{\"configData\":\"inputmy64lhzftlv\",\"dataType\":\"string\",\"replacedStr\":\"\u5355\u884c\u6587\u672c\",\"type\":\"field\"},{\"configData\":\"inputmy64lhzftlv\",\"dataType\":\"string\",\"replacedStr\":\"\u5355\u884c\u6587\u672c\",\"type\":\"field\"},{\"configData\":\"inputns94xmr13al\",\"dataType\":\"string\",\"replacedStr\":\"\u5355\u884c\u6587\u672c\",\"type\":\"field\"},{\"configData\":\"inputmy64lhzftlv\",\"dataType\":\"string\",\"replacedStr\":\"\u5355\u884c\u6587\u672c\",\"type\":\"field\"},{\"configData\":\"inputmy64lhzftlv\",\"dataType\":\"string\",\"replacedStr\":\"\u5355\u884c\u6587\u672c\",\"type\":\"field\"},{\"configData\":\"inputns94xmr13al\",\"dataType\":\"string\",\"replacedStr\":\"\u5355\u884c\u6587\u672c\",\"type\":\"field\"}],\"formulaStr\":\"IFS(\u5355\u884c\u6587\u672c<50,\\\"\u5c0f\u4e8e50\\\",\u5355\u884c\u6587\u672c<60,SUM(\u5355\u884c\u6587\u672c,\u5355\u884c\u6587\u672c)*2,\u5355\u884c\u6587\u672c<70,\\\"\u5c0f\u4e8e70\\\",\u5355\u884c\u6587\u672c>=70,\\\"\u5176\u4ed6\\\")+\u5355\u884c\u6587\u672c\",\"referMethods\":[{\"path\":\"hussar-base\",\"mobilePath\":\"@hussar/plugin-formulajs\",\"mobileUniPath\":\"@hussar/plugin-formulajs\",\"methods\":\"IFS,SUM\"}]}", FormulaConfigDTO.class);
        HashMap<String, Object> param = new HashMap<String, Object>(){
            {
                this.put("inputmy64lhzftlv", 10);
                this.put("inputns94xmr13al", 20);
            }
        };
        Object evaluate = ExpressionParser.BuildByConfig(formulaConfigDTO).evaluate((Map<String, Object>)param);
        System.out.println(evaluate);
    }

    private ExpressionParser() {
    }

    public static ExprNode BuildByConfig(FormulaConfigDTO formulaConfigDTO) {
        formulaConfigDTO.initConfig();
        ExpressionParser expressionParser = new ExpressionParser();
        expressionParser.expression = formulaConfigDTO.getFormulaStr();
        expressionParser.formulaMark = formulaConfigDTO.getFormulaMark();
        expressionParser.index = 0;
        ExprNode result = expressionParser.parseExpression();
        if (expressionParser.index < expressionParser.expression.length()) {
            throw new RuntimeException("\u8868\u8fbe\u5f0f\u672a\u5b8c\u5168\u89e3\u6790\uff0c\u5269\u4f59: " + expressionParser.expression.substring(expressionParser.index));
        }
        return result;
    }

    public static void test(String expression, Object result) {
        Object evaluate = ExpressionParser.test(expression);
        if (!result.equals(evaluate)) {
            throw new RuntimeException(String.format("\u8ba1\u7b97\u7ed3\u679c\u5b58\u5728\u5f02\u5e38\uff0c\u671f\u671b\uff1a%s,\u5b9e\u9645\uff1a%s", result, evaluate));
        }
    }

    public static Object test(String expression) {
        Object evaluate = ExpressionParser.BuildByConfig(new FormulaConfigDTO(expression)).evaluate(null);
        System.out.println(evaluate);
        return evaluate;
    }

    private ExprNode parseExpression() {
        return this.parseLogical();
    }

    private ExprNode parseLogical() {
        ExprNode left = this.parseComparison();
        while (this.index < this.expression.length()) {
            ExprNode right;
            if (this.match("&&")) {
                right = this.parseComparison();
                left = new OperatorNode("&&", left, right);
                continue;
            }
            if (!this.match("||")) break;
            right = this.parseComparison();
            left = new OperatorNode("||", left, right);
        }
        return left;
    }

    private ExprNode parseComparison() {
        ExprNode left = this.parseAdditive();
        while (this.index < this.expression.length()) {
            ExprNode right;
            if (this.match("==")) {
                right = this.parseAdditive();
                left = new OperatorNode("==", left, right);
                continue;
            }
            if (this.match("!=")) {
                right = this.parseAdditive();
                left = new OperatorNode("!=", left, right);
                continue;
            }
            if (this.match(">=")) {
                right = this.parseAdditive();
                left = new OperatorNode(">=", left, right);
                continue;
            }
            if (this.match("<=")) {
                right = this.parseAdditive();
                left = new OperatorNode("<=", left, right);
                continue;
            }
            if (this.match(">")) {
                right = this.parseAdditive();
                left = new OperatorNode(">", left, right);
                continue;
            }
            if (!this.match("<")) break;
            right = this.parseAdditive();
            left = new OperatorNode("<", left, right);
        }
        return left;
    }

    private ExprNode parseAdditive() {
        ExprNode left = this.parseMultiplicative();
        while (this.index < this.expression.length()) {
            ExprNode right;
            if (this.match("+")) {
                right = this.parseMultiplicative();
                left = new OperatorNode("+", left, right);
                continue;
            }
            if (!this.match("-")) break;
            right = this.parseMultiplicative();
            left = new OperatorNode("-", left, right);
        }
        return left;
    }

    private ExprNode parseMultiplicative() {
        ExprNode left;
        while ((left = this.parsePrimary()) == null) {
        }
        while (this.index < this.expression.length()) {
            ExprNode right;
            if (this.match("*")) {
                while ((right = this.parsePrimary()) == null) {
                }
                left = new OperatorNode("*", left, right);
                continue;
            }
            if (!this.match("/")) break;
            while ((right = this.parsePrimary()) == null) {
            }
            left = new OperatorNode("/", left, right);
        }
        return left;
    }

    private ExprNode parsePrimary() {
        if (this.index >= this.expression.length()) {
            throw new RuntimeException("\u610f\u5916\u7684\u8868\u8fbe\u5f0f\u7ed3\u675f");
        }
        char ch = this.expression.charAt(this.index);
        if (ch == '(') {
            ++this.index;
            ExprNode expr = this.parseExpression();
            this.expect(')');
            return expr;
        }
        if (Character.isLetter(ch) || ch == "$".charAt(0)) {
            return this.parseFunctionOrVariable();
        }
        if (Character.isDigit(ch) || ch == '.' || ch == '-') {
            return this.parseNumber();
        }
        if (ch == '\"' || ch == '\'') {
            return this.parseString();
        }
        if (ch == " ".charAt(0)) {
            ++this.index;
            return null;
        }
        throw new RuntimeException("\u65e0\u6cd5\u89e3\u6790\u7684\u5b57\u7b26: " + ch);
    }

    private ExprNode parseFunctionOrVariable() {
        StringBuilder name = new StringBuilder();
        while (this.index < this.expression.length() && (Character.isLetterOrDigit(this.expression.charAt(this.index)) || this.expression.charAt(this.index) == '_')) {
            name.append(this.expression.charAt(this.index));
            ++this.index;
        }
        if (this.index < this.expression.length() && this.expression.charAt(this.index) == '(') {
            return this.parseFunctionCall(name.toString());
        }
        return new VariableNode(name.toString());
    }

    private ExprNode parseFunctionCall(String functionName) {
        this.expect('(');
        List<ExprNode> arguments = this.parseArgumentList();
        this.expect(')');
        return new FunctionNode(FunctionEnum.valueOf(functionName), arguments);
    }

    private List<ExprNode> parseArgumentList() {
        ArrayList<ExprNode> arguments = new ArrayList<ExprNode>();
        if (this.index < this.expression.length() && this.expression.charAt(this.index) == ')') {
            return arguments;
        }
        while (true) {
            arguments.add(this.parseExpression());
            if (this.index >= this.expression.length() || this.expression.charAt(this.index) != ',') break;
            ++this.index;
        }
        return arguments;
    }

    private ExprNode parseNumber() {
        int start = this.index;
        if (this.expression.charAt(this.index) == '-') {
            ++this.index;
        }
        boolean hasDecimal = false;
        while (this.index < this.expression.length()) {
            char ch = this.expression.charAt(this.index);
            if (Character.isDigit(ch)) {
                ++this.index;
                continue;
            }
            if (ch != '.' || hasDecimal) break;
            hasDecimal = true;
            ++this.index;
        }
        String numberStr = this.expression.substring(start, this.index);
        try {
            if (hasDecimal) {
                return new ConstantNode(Double.parseDouble(numberStr));
            }
            return new ConstantNode(Integer.parseInt(numberStr));
        }
        catch (NumberFormatException e) {
            throw new RuntimeException("\u65e0\u6548\u7684\u6570\u5b57\u683c\u5f0f: " + numberStr);
        }
    }

    private ExprNode parseString() {
        char quote = this.expression.charAt(this.index);
        ++this.index;
        StringBuilder sb = new StringBuilder();
        while (this.index < this.expression.length() && this.expression.charAt(this.index) != quote) {
            sb.append(this.expression.charAt(this.index));
            ++this.index;
        }
        this.expect(quote);
        return new ConstantNode(sb.toString());
    }

    private boolean match(String expected) {
        if (this.index + expected.length() <= this.expression.length() && this.expression.substring(this.index, this.index + expected.length()).equals(expected)) {
            this.index += expected.length();
            return true;
        }
        return false;
    }

    private void expect(char expected) {
        if (this.index >= this.expression.length() || this.expression.charAt(this.index) != expected) {
            throw new RuntimeException("\u671f\u671b\u5b57\u7b26 '" + expected + "'\uff0c\u4f46\u627e\u5230 '" + (this.index < this.expression.length() ? this.expression.charAt(this.index) : (char)' ') + "'");
        }
        ++this.index;
    }

    public List<FormulaMarkDTO> getFormulaMark() {
        return this.formulaMark;
    }
}

