/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.ds.process.formula.dto;

import com.google.common.collect.Lists;
import com.jxdinfo.hussar.ds.process.formula.dto.FormulaMarkDTO;
import com.jxdinfo.hussar.ds.process.formula.dto.FormulaParamDTO;
import com.jxdinfo.hussar.ds.process.formula.dto.FormulaReferMethodDTO;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.exception.HussarException;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class FormulaConfigDTO {
    private List<FormulaMarkDTO> formulaMark;
    private List<FormulaParamDTO> formulaParam;
    private String formulaStr;
    private List<FormulaReferMethodDTO> referMethods;

    public FormulaConfigDTO() {
    }

    public FormulaConfigDTO(String formulaStr) {
        this.formulaStr = formulaStr;
    }

    public List<FormulaMarkDTO> getFormulaMark() {
        return this.formulaMark;
    }

    public void setFormulaMark(List<FormulaMarkDTO> formulaMark) {
        this.formulaMark = formulaMark;
    }

    public List<FormulaParamDTO> getFormulaParam() {
        return this.formulaParam;
    }

    public void setFormulaParam(List<FormulaParamDTO> formulaParam) {
        this.formulaParam = formulaParam;
    }

    public String getFormulaStr() {
        return this.formulaStr;
    }

    public void setFormulaStr(String formulaStr) {
        this.formulaStr = formulaStr;
    }

    public List<FormulaReferMethodDTO> getReferMethods() {
        return this.referMethods;
    }

    public void setReferMethods(List<FormulaReferMethodDTO> referMethods) {
        this.referMethods = referMethods;
    }

    public void initConfig() {
        this.checkParam();
        String formulaStr = this.getFormulaStr();
        List<FormulaMarkDTO> formulaMark = this.getFormulaMark();
        if (HussarUtils.isNotEmpty(formulaMark)) {
            Map<Integer, List<FormulaMarkDTO>> line2MarkDTO = formulaMark.stream().collect(Collectors.groupingBy(action -> action.getFrom().getLine()));
            StringBuilder expression = new StringBuilder();
            int level = 0;
            for (String formulaInfo : formulaStr.split("\n")) {
                List<FormulaMarkDTO> formulaMarkDTOList = line2MarkDTO.getOrDefault(level, Lists.newArrayListWithCapacity((int)0));
                formulaMarkDTOList.sort(Comparator.comparing(k -> k.getFrom().getCh()));
                int lastIndex = 0;
                for (FormulaMarkDTO formulaMarkDTO : formulaMarkDTOList) {
                    int from = formulaMarkDTO.getFrom().getCh();
                    int index = formulaMarkDTO.getIndex();
                    int to = formulaMarkDTO.getTo().getCh();
                    if (from > lastIndex) {
                        expression.append(formulaInfo, lastIndex, from);
                    }
                    expression.append(this.getFormulaParam().get(index).getFieldId());
                    lastIndex = to;
                }
                if (formulaStr.length() > lastIndex) {
                    expression.append(formulaInfo.substring(lastIndex));
                }
                ++level;
            }
            this.setFormulaStr(expression.toString().replaceAll("\\s+", ""));
        }
    }

    private void checkParam() {
        List<FormulaParamDTO> formulaParam = this.getFormulaParam();
        List<FormulaMarkDTO> formulaMark = this.getFormulaMark();
        if (HussarUtils.isNotEmpty(formulaMark)) {
            boolean flag = formulaMark.stream().anyMatch(FormulaMarkDTO::checkIsNull);
            HussarException.throwBy((boolean)flag, (String)"mark\u4e2d\u5fc5\u4f20\u53c2\u6570\u4e3a\u7a7a");
            int maxIndex = formulaMark.stream().mapToInt(FormulaMarkDTO::getIndex).max().orElse(0);
            HussarException.throwByNull(formulaParam, (String)"\u53c2\u6570\u5b9a\u4e49\u4e0d\u80fd\u4e3a\u7a7a");
            HussarException.throwBy((maxIndex > formulaParam.size() - 1 ? 1 : 0) != 0, (String)"mark\u6807\u8bb0index\u4e0d\u5b58\u5728");
        }
    }
}

