/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.ds.process.enums;

import com.jxdinfo.hussar.mail.core.util.ObjectUtil;
import com.jxdinfo.hussar.platform.core.utils.JsonUtil;
import java.sql.Date;
import java.sql.JDBCType;
import java.sql.Time;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.util.function.Predicate;

public enum FieldTypeEnum {
    ARRAY("array", JDBCType.VARCHAR.name(), String.class, v -> {
        try {
            JsonUtil.parseArray((String)v, Object.class);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }),
    OBJECT("object", JDBCType.VARCHAR.name(), String.class, v -> {
        try {
            JsonUtil.parse((String)v, Object.class);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }),
    STRING("string", JDBCType.VARCHAR.name(), String.class, v -> true),
    INTEGER("int", JDBCType.INTEGER.name(), Integer.class, v -> {
        try {
            Integer.parseInt(v);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }),
    LONG("long", JDBCType.BIGINT.name(), Long.class, v -> {
        try {
            Long.parseLong(v);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }),
    DOUBLE("double", JDBCType.DOUBLE.name(), Double.class, v -> {
        try {
            Double.parseDouble(v);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }),
    BOOLEAN("boolean", JDBCType.BOOLEAN.name(), Boolean.class, v -> "true".equalsIgnoreCase((String)v) || "false".equalsIgnoreCase((String)v) || "1".equals(v) || "0".equals(v)),
    DATE("date", JDBCType.DATE.name(), Date.class, v -> {
        try {
            new SimpleDateFormat("yyyy-MM-dd").parse((String)v);
            return true;
        }
        catch (ParseException e) {
            return false;
        }
    }),
    TIMESTAMP("timestamp", JDBCType.TIMESTAMP.name(), LocalDateTime.class, v -> {
        try {
            new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse((String)v);
            return true;
        }
        catch (ParseException e) {
            return false;
        }
    }),
    TIME("time", JDBCType.TIME.name(), Time.class, v -> {
        try {
            new SimpleDateFormat("HH:mm:ss").parse((String)v);
            return true;
        }
        catch (ParseException e) {
            return false;
        }
    }),
    WORD("word", JDBCType.VARCHAR.name(), String.class, v -> true),
    EXCEL("excel", JDBCType.VARCHAR.name(), String.class, v -> true),
    VIDEO("video", JDBCType.VARCHAR.name(), String.class, v -> true),
    TXT("txt", JDBCType.VARCHAR.name(), String.class, v -> true),
    RAR("rar", JDBCType.VARCHAR.name(), String.class, v -> true),
    PPT("ppt", JDBCType.VARCHAR.name(), String.class, v -> true),
    PDF("pdf", JDBCType.VARCHAR.name(), String.class, v -> true),
    MUSIC("music", JDBCType.VARCHAR.name(), String.class, v -> true),
    IMAGE("image", JDBCType.VARCHAR.name(), String.class, v -> true),
    OTHER("other", JDBCType.VARCHAR.name(), String.class, v -> true);

    private String value;
    private String jdbcType;
    private Class<?> javaType;
    private final Predicate<String> validator;

    private FieldTypeEnum(String value, String jdbcType, Class<?> javaType, Predicate<String> validator) {
        this.value = value;
        this.jdbcType = jdbcType;
        this.javaType = javaType;
        this.validator = validator;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public String getJdbcType() {
        return this.jdbcType;
    }

    public void setJdbcType(String jdbcType) {
        this.jdbcType = jdbcType;
    }

    public Class<?> getJavaType() {
        return this.javaType;
    }

    public boolean validateValue(String value) {
        return this.validator.test(value);
    }

    public static FieldTypeEnum fromValue(String value) {
        for (FieldTypeEnum paramType : FieldTypeEnum.values()) {
            if (!paramType.getValue().equalsIgnoreCase(value)) continue;
            return paramType;
        }
        throw new IllegalArgumentException("\u4e0d\u652f\u6301\u7684\u7c7b\u578b\uff1a" + value);
    }

    public boolean match(String dataType) {
        return ObjectUtil.isNotEmpty((Object)dataType) && dataType.equals(this.getValue());
    }
}

