/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.ds.process.component.model;

import com.google.common.collect.Lists;
import com.jxdinfo.hussar.ds.process.component.dto.DataSetFieldDto;
import com.jxdinfo.hussar.ds.process.component.dto.JoinFieldDto;
import com.jxdinfo.hussar.ds.process.component.model.DataSetInputConfigModel;
import com.jxdinfo.hussar.ds.process.util.DataTypeUtil;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.ObjectUtils;

public class JoinFieldConfigModel {
    private List<DataSetInputConfigModel> dataSetList;
    private List<JoinFieldDto> joinFieldList;

    public List<DataSetInputConfigModel> getDataSetList() {
        return this.dataSetList;
    }

    public void setDataSetList(List<DataSetInputConfigModel> dataSetList) {
        this.dataSetList = dataSetList;
    }

    public List<JoinFieldDto> getJoinFieldList() {
        return this.joinFieldList;
    }

    public void setJoinFieldList(List<JoinFieldDto> joinFieldList) {
        this.joinFieldList = joinFieldList;
    }

    public DataSetInputConfigModel getDataSetByDataSetId(String dataSetId) {
        if (ObjectUtils.isNotEmpty(this.getDataSetList())) {
            for (DataSetInputConfigModel dataSetInputConfigModel : this.getDataSetList()) {
                if (!dataSetInputConfigModel.getDataSetId().equals(dataSetId)) continue;
                return dataSetInputConfigModel;
            }
        }
        return null;
    }

    public List<DataSetFieldDto> getFieldListByDataSetId(String dataSetId) {
        if (ObjectUtils.isNotEmpty(this.getDataSetList())) {
            for (DataSetInputConfigModel dataSetInputConfigModel : this.getDataSetList()) {
                if (!dataSetInputConfigModel.getDataSetId().equals(dataSetId) || !ObjectUtils.isNotEmpty(dataSetInputConfigModel.getFieldList())) continue;
                return dataSetInputConfigModel.getFieldList();
            }
        }
        return Lists.newArrayListWithCapacity((int)0);
    }

    public List<String> getAllFiledNameList(String dataSetId) {
        ArrayList<String> filedNameList = new ArrayList<String>();
        DataSetInputConfigModel dataSetInputConfigModel = this.getDataSetByDataSetId(dataSetId);
        if (ObjectUtils.isNotEmpty((Object)dataSetInputConfigModel) && ObjectUtils.isNotEmpty(dataSetInputConfigModel.getFieldList())) {
            for (DataSetFieldDto dataSetFieldDto : dataSetInputConfigModel.getFieldList()) {
                if (filedNameList.contains(dataSetFieldDto.getFieldId())) continue;
                filedNameList.add(dataSetFieldDto.getFieldId());
            }
        }
        return filedNameList;
    }

    public List<String> getAllFiledDefNameList(String dataSetId, String ... append) {
        String pre = append.length > 0 ? append[0] : "";
        String post = append.length > 1 ? append[1] : "";
        ArrayList<String> filedNameList = new ArrayList<String>();
        if (ObjectUtils.isNotEmpty(this.getDataSetList())) {
            for (DataSetInputConfigModel dataSetInputConfigModel : this.getDataSetList()) {
                if (!dataSetInputConfigModel.getDataSetId().equals(dataSetId) || !ObjectUtils.isNotEmpty(dataSetInputConfigModel.getFieldList())) continue;
                for (DataSetFieldDto dataSetFieldDto : dataSetInputConfigModel.getFieldList()) {
                    String key = String.format(" %s %s %s %s ", pre, dataSetFieldDto.getFieldId(), DataTypeUtil.getDuckDbType(dataSetFieldDto.getDataType()), post);
                    if (filedNameList.contains(key)) continue;
                    filedNameList.add(key);
                }
            }
        }
        return filedNameList;
    }
}

