/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.ds.process.component.dto;

import com.jxdinfo.hussar.platform.core.utils.map.MapUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class FormulaParser {
    private boolean isUndefinedMethod = false;
    private List<String> undefinedMethods = new ArrayList<String>();
    private boolean isUndefinedExternal = false;
    private List<String> undefinedExternals = new ArrayList<String>();
    private boolean isUndefinedVariable = false;
    private List<String> undefinedVariables = new ArrayList<String>();
    private boolean isStrictMode = true;
    private String error = "";
    private Formula formula;
    private Map<String, Object> externals = new HashMap<String, Object>();
    private Map<String, Function<Object[], Object>> functions = new HashMap<String, Function<Object[], Object>>();
    private Map<String, Function<Object[], Object>> formulaFunctions = new HashMap<String, Function<Object[], Object>>();
    private String formulaExpression = "";
    private Pattern formulaFunctionRegex = Pattern.compile("^(\\w+)(\\.*)(\\w*)");
    private Pattern formulaFunctionReplaceRegex = Pattern.compile("(^(\\w+)(\\.*)(\\w*))(?=\\()");
    private Function<Map<String, Object>, Object> formulaFunction;

    public FormulaParser(Map<String, Object> config) {
        Formula formula = (Formula)config.get("formula");
        Map externals = (Map)config.get("externals");
        Boolean isStrictMode = (Boolean)config.get("isStrictMode");
        this.formula = formula != null ? formula : new Formula(new ArrayList<FormulaMark>(), new ArrayList<FormulaParam>(), new ArrayList<ReferMethods>(), "");
        this.externals = externals != null ? externals : new HashMap();
        this.isStrictMode = isStrictMode != null ? isStrictMode : true;
        this.parse();
    }

    private static List<List<FormulaMark>> groupFormulaMark(List<FormulaMark> formulaMark) {
        ArrayList<List<FormulaMark>> groups = new ArrayList<List<FormulaMark>>();
        for (FormulaMark mark : formulaMark) {
            int line = mark.from.line;
            while (groups.size() <= line) {
                groups.add(null);
            }
            if (groups.get(line) == null) {
                groups.set(line, new ArrayList());
            }
            ((List)groups.get(line)).add(mark);
        }
        for (int i = 0; i < groups.size(); ++i) {
            List arr = (List)groups.get(i);
            if (arr == null) continue;
            arr.sort((mark1, mark2) -> Integer.compare(mark1.from.ch, mark2.from.ch));
        }
        return groups;
    }

    private static List<String> splitFormulaStr(Formula formula) {
        String formulaStr;
        ArrayList<FormulaMark> formulaMark = formula.formulaMark != null ? formula.formulaMark : new ArrayList<FormulaMark>();
        String string = formulaStr = formula.formulaStr != null ? formula.formulaStr : "";
        if (formulaMark.isEmpty()) {
            return Arrays.asList(formulaStr);
        }
        List<List<FormulaMark>> groups = FormulaParser.groupFormulaMark(formulaMark);
        String[] formulaStrSplited = formulaStr.split("\n");
        ArrayList<String> result = new ArrayList<String>();
        for (int i = 0; i < groups.size(); ++i) {
            List<FormulaMark> formulaMarkItem = groups.get(i);
            if (formulaMarkItem != null && i < formulaStrSplited.length) {
                String formulaSplitStr = formulaStrSplited[i];
                int currentIndex = 0;
                ArrayList<String> fragments = new ArrayList<String>();
                for (FormulaMark mark : formulaMarkItem) {
                    int start = mark.from.ch;
                    int end = mark.to.ch;
                    if (start > currentIndex) {
                        fragments.add(formulaSplitStr.substring(currentIndex, start));
                    }
                    fragments.add(formulaSplitStr.substring(start, end));
                    currentIndex = end;
                }
                if (currentIndex < formulaSplitStr.length()) {
                    fragments.add(formulaSplitStr.substring(currentIndex));
                }
                result.addAll(fragments);
                continue;
            }
            if (i >= formulaStrSplited.length) continue;
            result.add(formulaStrSplited[i]);
        }
        return result;
    }

    private void warn(String type, String arg1, Object arg2) {
        System.out.printf("\u3010FoumulaParser\u3011%s \u300c%s\u300d= %s%n", type, arg1, arg2);
    }

    public void setStrictMode(boolean isStrictMode) {
        this.isStrictMode = isStrictMode;
    }

    public boolean getStrictMode() {
        return this.isStrictMode;
    }

    public void setExternals(Map<String, Object> externals) {
        this.externals = externals != null ? externals : new HashMap();
    }

    public Map<String, Object> getExternals() {
        return this.externals;
    }

    public Object test(String formulaStr, Map<String, Object> variables) {
        Map<String, Function<Object[], Object>> allFunctions = this.getAllFunctions();
        StringBuilder funcs = new StringBuilder();
        for (String funcname : allFunctions.keySet()) {
            funcs.append("Object ").append(funcname).append(" = allFunctions.get(\"").append(funcname).append("\").apply(args);");
        }
        StringBuilder vars = new StringBuilder();
        for (String varname : variables.keySet()) {
            vars.append("Object ").append(varname).append(" = variables.get(\"").append(varname).append("\");");
        }
        return null;
    }

    public Map<String, Object> testFormula() {
        Map<String, Object> result1 = this.testFunctions();
        if (result1.containsKey("error") && !((String)result1.get("error")).isEmpty()) {
            return result1;
        }
        return this.testExternals();
    }

    private Map<String, Object> testExternals() {
        this.isUndefinedExternal = false;
        this.undefinedExternals.clear();
        List<Object> formulaParam = this.formula.formulaParam != null ? this.formula.formulaParam : new ArrayList();
        ArrayList<FormulaParam> externalParam = new ArrayList<FormulaParam>();
        for (FormulaParam formulaParam2 : formulaParam) {
            if ("field".equals(formulaParam2.type)) continue;
            externalParam.add(formulaParam2);
        }
        for (FormulaParam formulaParam3 : externalParam) {
            Object externalData = this.externals.get(formulaParam3.configData);
            if (externalData != null) continue;
            this.isUndefinedExternal = true;
            this.undefinedExternals.add(formulaParam3.configData);
        }
        if (this.isUndefinedExternal) {
            return MapUtil.of((Object)"error", (Object)("[EXIST_UNDEFINED_EXTERNAL]: " + String.join((CharSequence)",", this.undefinedExternals)));
        }
        return MapUtil.of((Object)"error", (Object)"");
    }

    private Map<String, Object> testVariable(Map<String, Object> variables) {
        this.isUndefinedVariable = false;
        this.undefinedVariables.clear();
        List<Object> formulaParam = this.formula.formulaParam != null ? this.formula.formulaParam : new ArrayList();
        ArrayList<FormulaParam> variableParam = new ArrayList<FormulaParam>();
        for (FormulaParam formulaParam2 : formulaParam) {
            if (!"field".equals(formulaParam2.type)) continue;
            variableParam.add(formulaParam2);
        }
        for (FormulaParam formulaParam3 : variableParam) {
            Object varData = variables.get(formulaParam3.configData);
            if (varData != null) continue;
            this.isUndefinedVariable = true;
            this.undefinedVariables.add(formulaParam3.configData);
        }
        if (this.isUndefinedVariable) {
            return MapUtil.of((Object)"error", (Object)("[EXIST_UNDEFINED_VERIABLE]: " + String.join((CharSequence)",", this.undefinedVariables)));
        }
        return MapUtil.of((Object)"error", (Object)"");
    }

    private Map<String, Object> testFunctions() {
        this.isUndefinedMethod = false;
        this.undefinedMethods.clear();
        List<Object> referMethods = this.formula.referMethods != null ? this.formula.referMethods : new ArrayList();
        Map<String, Function<Object[], Object>> allFunctions = this.getAllFunctions();
        for (ReferMethods referMethods2 : referMethods) {
            String[] methods;
            for (String method : methods = referMethods2.methods.split(",")) {
                if (allFunctions.containsKey(method)) continue;
                this.isUndefinedMethod = true;
                this.undefinedMethods.add(method);
            }
        }
        if (this.isUndefinedMethod) {
            return null;
        }
        return null;
    }

    private String formulaReplace() {
        List<String> fragments = FormulaParser.splitFormulaStr(this.formula);
        String tempStr = this.formula.formulaStr;
        ArrayList<String> replaceField = new ArrayList<String>();
        ArrayList<String> replaceFieldAlias = new ArrayList<String>();
        List<Object> params = this.formula.formulaParam != null ? this.formula.formulaParam : new ArrayList();
        for (int i = 0; i < fragments.size(); ++i) {
            String fragment = fragments.get(i);
            String fragmentAlias = fragments.get(i);
            for (int j = 0; j < params.size(); ++j) {
                FormulaParam param = (FormulaParam)params.get(j);
                if (!param.replacedStr.equals(fragment) || replaceFieldAlias.contains("valiables.get(\"" + param.configData + "_" + j + "\")")) continue;
                fragment = "valiables.get(\"" + param.configData + "\")";
                fragmentAlias = "valiables.get(\"" + param.configData + "_" + j + "\")";
                break;
            }
            replaceField.add(fragment);
            replaceFieldAlias.add(fragmentAlias);
        }
        tempStr = String.join((CharSequence)"", replaceField);
        Matcher matcher = this.formulaFunctionReplaceRegex.matcher(tempStr);
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            String functionName = matcher.group(1);
            matcher.appendReplacement(sb, "this.callFunction(\"" + functionName + "\")");
        }
        matcher.appendTail(sb);
        return sb.toString();
    }

    public void setFunction(String name, Function<Object[], Object> fn) {
        if (this.formulaFunctionRegex.matcher(name).matches()) {
            if (this.formulaFunctions.containsKey(name)) {
                this.warn("EXIST_FUNCTION", name, "");
            }
            this.functions.put(name, fn);
        }
    }

    public Function<Object[], Object> getFunction(String name) {
        if (this.formulaFunctionRegex.matcher(name).matches()) {
            Function<Object[], Object> fn = this.functions.get(name);
            if (fn != null) {
                return fn;
            }
            return this.formulaFunctions.get(name);
        }
        return null;
    }

    public Object callFunction(String name) {
        Function<Object[], Object> fn = this.getFunction(name);
        if (fn == null) {
            throw new RuntimeException("\u3010FormulaParser\u3011\u8c03\u7528\u65b9\u6cd5\u4e0d\u5b58\u5728: " + name);
        }
        return fn;
    }

    public Map<String, Function<Object[], Object>> getAllFunctions() {
        HashMap<String, Function<Object[], Object>> allFunctions = new HashMap<String, Function<Object[], Object>>();
        allFunctions.putAll(this.formulaFunctions);
        allFunctions.putAll(this.functions);
        return allFunctions;
    }

    public Map<String, Object> parse() {
        Map<String, Object> result = this.testFormula();
        if (result.containsKey("error") && !((String)result.get("error")).isEmpty()) {
            this.error = (String)result.get("error");
            return null;
        }
        try {
            String formulaExpression;
            this.formulaExpression = formulaExpression = this.formulaReplace();
            this.formulaFunction = variables -> null;
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }

    public Map<String, Object> execSync(Map<String, Object> valiables) {
        HashMap varResult;
        if (this.error != null && !this.error.isEmpty()) {
            this.warn("test", this.formula.formulaStr, this.error);
            return null;
        }
        HashMap hashMap = varResult = this.isStrictMode ? this.testVariable(valiables) : MapUtil.of((Object)"error", (Object)"");
        if (varResult.containsKey("error") && !((String)varResult.get("error")).isEmpty()) {
            this.warn("test", this.formula.formulaStr, varResult.get("error"));
            return null;
        }
        try {
            Object result = this.formulaFunction.apply(valiables);
            if (result instanceof Exception) {
                String message = ((Exception)result).getMessage();
                this.warn("exec", this.formula.formulaStr, message);
                return null;
            }
            return null;
        }
        catch (Exception err) {
            String message = err.getMessage();
            this.warn("syntax", this.formula.formulaStr, message);
            return null;
        }
    }

    public CompletableFuture<Object> exec(Map<String, Object> valiables) {
        return CompletableFuture.supplyAsync(() -> {
            Map<String, Object> result = this.execSync(valiables);
            if (result.containsKey("error") && !((String)result.get("error")).isEmpty()) {
                throw new RuntimeException((String)result.get("error"));
            }
            return result.get("value");
        });
    }

    public String toString() {
        if (this.error != null && !this.error.isEmpty()) {
            return this.error;
        }
        return this.formulaExpression;
    }

    private static boolean isError(Object obj) {
        return obj instanceof Exception;
    }

    public static class Formula {
        public List<FormulaMark> formulaMark;
        public List<FormulaParam> formulaParam;
        public List<ReferMethods> referMethods;
        public String formulaStr;

        public Formula(List<FormulaMark> formulaMark, List<FormulaParam> formulaParam, List<ReferMethods> referMethods, String formulaStr) {
            this.formulaMark = formulaMark;
            this.formulaParam = formulaParam;
            this.referMethods = referMethods;
            this.formulaStr = formulaStr;
        }
    }

    public static class ReferMethods {
        public String methods;

        public ReferMethods(String methods) {
            this.methods = methods;
        }
    }

    public static class FormulaParam {
        public String type;
        public String configData;
        public String replacedStr;

        public FormulaParam(String type, String configData, String replacedStr) {
            this.type = type;
            this.configData = configData;
            this.replacedStr = replacedStr;
        }
    }

    public static class FormulaMark {
        public Position from;
        public Position to;

        public FormulaMark(Position from, Position to) {
            this.from = from;
            this.to = to;
        }
    }

    public static class Position {
        public int line;
        public int ch;

        public Position(int line, int ch) {
            this.line = line;
            this.ch = ch;
        }
    }

    public static class KeyFormulaError {
        public static final String EXIST_UNDEFINED_FUNCTION = "EXIST_UNDEFINED_FUNCTION";
        public static final String EXIST_UNDEFINED_VERIABLES = "EXIST_UNDEFINED_VERIABLE";
        public static final String EXIST_UNDEFINED_EXTERNAL = "EXIST_UNDEFINED_EXTERNAL";
    }
}

