/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.datasource.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.datasource.config.DataSourceConfig;
import com.jxdinfo.hussar.datasource.config.querysql.QuerySqlModel;
import com.jxdinfo.hussar.datasource.model.DsTableField;
import com.jxdinfo.hussar.datasource.model.DsTableIndex;
import com.jxdinfo.hussar.datasource.model.DsTableInfo;
import com.jxdinfo.hussar.datasource.service.DataBaseJsonService;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.Environment;

public class SqlPublicMethodUtil {
    private static final Logger logger = LoggerFactory.getLogger(SqlPublicMethodUtil.class);
    private static DataBaseJsonService dataBaseJsonService = (DataBaseJsonService)SpringContextHolder.getBean(DataBaseJsonService.class);

    public static QuerySqlModel getQuerySqlObject(DataSourceConfig dataSourceConfig) {
        String url = dataSourceConfig.getUrl();
        if (HussarUtils.isEmpty((Object)url)) {
            return null;
        }
        String dbType = dataSourceConfig.getDbTypeCustom();
        String kingBaseMode = ((Environment)SpringContextHolder.getBean(Environment.class)).getProperty("spring.datasource.dynamic.datasource.master.db-mode");
        if ("KINGBASE".equals(dbType)) {
            if (HussarUtils.isNotEmpty((Object)dataSourceConfig.getDbMode())) {
                if ("kingbase_mysql".equals(dataSourceConfig.getDbMode())) {
                    dbType = dbType + "mysql";
                }
            } else if (HussarUtils.isNotEmpty((Object)kingBaseMode) && "kingbase_mysql".equals(kingBaseMode)) {
                dbType = dbType + "mysql";
            }
        }
        String result = dataBaseJsonService.getTableQuery(dbType);
        QuerySqlModel querySqlModel = (QuerySqlModel)JSON.parseObject((String)result, (TypeReference)new TypeReference<QuerySqlModel>(){}, (Feature[])new Feature[0]);
        return querySqlModel;
    }

    public static void dealFieldResultMap(List<DsTableField> fieldInfo, ResultSet fieldResultSet) throws SQLException {
        if (null != fieldResultSet) {
            while (fieldResultSet.next()) {
                DsTableField dsTableField = new DsTableField();
                if (fieldResultSet.getString(2).startsWith("........sys.dropped.")) continue;
                dsTableField.setTableName(fieldResultSet.getString(1));
                dsTableField.setName(fieldResultSet.getString(2));
                dsTableField.setComment(fieldResultSet.getString(3));
                dsTableField.setType(fieldResultSet.getString(4));
                dsTableField.setPrimarys(fieldResultSet.getString(5));
                fieldInfo.add(dsTableField);
            }
        }
    }

    public static void dealFieldResultMap(List<DsTableField> fieldInfo, List<Map<String, Object>> fieldList) {
        fieldList.stream().forEach(stringObjectMap -> {
            DsTableField dsTableField = new DsTableField();
            String columnName = (String)stringObjectMap.get("columnName");
            if (!columnName.startsWith("........sys.dropped.")) {
                dsTableField.setTableName((String)stringObjectMap.get("tableName"));
                dsTableField.setName(columnName);
                dsTableField.setComment((String)stringObjectMap.get("comments"));
                dsTableField.setType((String)stringObjectMap.get("ttype"));
                dsTableField.setPrimarys((String)stringObjectMap.get("primarys"));
                fieldInfo.add(dsTableField);
            }
        });
    }

    public static void dealTableResultMap(List<DsTableInfo> dsTableInfoList, ResultSet tableResultSet) throws SQLException {
        if (null != tableResultSet) {
            while (tableResultSet.next()) {
                DsTableInfo dsTableInfo = new DsTableInfo();
                dsTableInfo.setName(tableResultSet.getString(1));
                dsTableInfo.setComment(tableResultSet.getString(2));
                String type = tableResultSet.getString(3);
                dsTableInfo.setType(type);
                dsTableInfo.setView(!"BASE_TABLE".equalsIgnoreCase(type));
                dsTableInfoList.add(dsTableInfo);
            }
        }
    }

    public static List<DsTableInfo> combinedBatch(List<DsTableInfo> tableList, List<DsTableField> columnList, List<DsTableIndex> indexList) {
        for (DsTableInfo table : tableList) {
            SqlPublicMethodUtil.combined(table, columnList, indexList);
        }
        return tableList;
    }

    public static DsTableInfo combined(DsTableInfo table, List<DsTableField> columnList) {
        for (DsTableField column : columnList) {
            String columnTableName = column.getTableName();
            if (!HussarUtils.equals((Object)columnTableName, (Object)table.getName())) continue;
            String columnName = column.getName();
            column.setName(columnName);
            column.setRealName(columnName);
            if (HussarUtils.isNotEmpty(table.getFields())) {
                table.getFields().add(column);
                continue;
            }
            ArrayList<DsTableField> fieldList = new ArrayList<DsTableField>();
            fieldList.add(column);
            table.setFields(fieldList);
        }
        return table;
    }

    public static DsTableInfo combined(DsTableInfo table, List<DsTableField> columnList, List<DsTableIndex> indexList) {
        SqlPublicMethodUtil.combined(table, columnList);
        if (indexList != null) {
            indexList.forEach(index -> {
                String indexTableName = index.getTableName();
                if (HussarUtils.equals((Object)indexTableName, (Object)table.getName())) {
                    if (HussarUtils.isNotEmpty(table.getIndexs())) {
                        table.getIndexs().add((DsTableIndex)index);
                    } else {
                        ArrayList<DsTableIndex> indexes = new ArrayList<DsTableIndex>();
                        indexes.add((DsTableIndex)index);
                        table.setIndexs(indexes);
                    }
                }
            });
        }
        return table;
    }
}

