/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.datasource.util;

import com.jxdinfo.hussar.datasource.config.DatasourceConfigDTO;
import com.jxdinfo.hussar.datasource.config.rules.DbType;
import com.jxdinfo.hussar.datasource.dto.SysDataSourceDto;
import com.jxdinfo.hussar.datasource.enm.DataSourceExceptionEnum;
import com.jxdinfo.hussar.datasource.exception.DataSourceException;
import com.jxdinfo.hussar.support.security.integration.authentication.support.utils.HussarSecurityUtils;

public class DataSourceConvertUtil {
    private DataSourceConvertUtil() {
    }

    public static SysDataSourceDto ofBase(DatasourceConfigDTO configDTO) {
        SysDataSourceDto datasourceTable = new SysDataSourceDto();
        datasourceTable.setId(configDTO.getId());
        datasourceTable.setDbName(configDTO.getDbName());
        datasourceTable.setConnName(configDTO.getName());
        datasourceTable.setRemark(configDTO.getDesc());
        datasourceTable.setUserName(configDTO.getUsername());
        datasourceTable.setPassword(configDTO.getPassword());
        datasourceTable.setDatasourceType("2");
        datasourceTable.setDataBaseName(configDTO.getDbName());
        datasourceTable.setExample(configDTO.getDbName());
        try {
            datasourceTable.setJdbcUrl(DataSourceConvertUtil.getJdbcUrl(configDTO));
        }
        catch (DataSourceException e) {
            e.printStackTrace();
        }
        datasourceTable.setCreator(HussarSecurityUtils.getLoginUserDetails().getUserId());
        return datasourceTable;
    }

    private static String getJdbcUrl(DatasourceConfigDTO config) throws DataSourceException {
        StringBuilder jdbcUrl = new StringBuilder(16);
        if (config.getRealDbType().equalsIgnoreCase(DbType.MYSQL.name())) {
            jdbcUrl.append("jdbc:mysql://").append(config.getHost()).append(":").append(config.getPort()).append("/").append(config.getDbName()).append("?autoReconnect=true&useUnicode=true&characterEncoding=utf8&zeroDateTimeBehavior=convertToNull&useSSL=false&serverTimezone=UTC");
        } else if (config.getRealDbType().equalsIgnoreCase(DbType.ORACLE.name())) {
            jdbcUrl.append("jdbc:oracle:thin:@").append(config.getHost()).append(":").append(config.getPort()).append(":").append(config.getDbName());
        } else if (config.getRealDbType().equalsIgnoreCase(DbType.DM.name())) {
            jdbcUrl.append("jdbc:dm://").append(config.getHost()).append(":").append(config.getPort());
        } else if (config.getRealDbType().equalsIgnoreCase(DbType.POSTGRE_SQL.name())) {
            jdbcUrl.append("jdbc:postgresql://").append(config.getHost()).append(":").append(config.getPort()).append("/").append(config.getDbName()).append("?currentSchema=public");
        } else if (config.getRealDbType().equalsIgnoreCase(DbType.SQL_SERVER.name())) {
            jdbcUrl.append("jdbc:sqlserver://").append(config.getHost()).append(":").append(config.getPort()).append(";SelectMethod=cursor;databaseName=").append(config.getDbName());
        } else if (config.getRealDbType().equalsIgnoreCase(DbType.OSCAR.name())) {
            jdbcUrl.append("jdbc:oscar://").append(config.getHost()).append(":").append(config.getPort()).append("/").append(config.getDbName());
        } else {
            throw new DataSourceException(DataSourceExceptionEnum.NOT_SUPPORT_DATA_BASE, DataSourceExceptionEnum.NOT_SUPPORT_DATA_BASE.getMsg());
        }
        return jdbcUrl.toString();
    }

    private static String getDriverClassByType(String dbType) {
        for (DbType typeEnum : DbType.values()) {
            if (!typeEnum.getValue().equalsIgnoreCase(dbType)) continue;
            return typeEnum.getDriverClass();
        }
        return "";
    }
}

