/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.datasource.config.converts;

import com.jxdinfo.hussar.datasource.config.rules.DbColumnType;
import com.jxdinfo.hussar.datasource.config.rules.PropertyType;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;

public class DataModelFieldTypeConvert {
    public static final String STRING = "string";
    public static final String INT = "int";
    public static final String LONG = "long";
    public static final String DOUBLE = "double";
    public static final String DATE = "date";
    public static final String BOOLEAN = "boolean";
    public static final String OBJECT = "object";
    public static final String ARRAY = "array";
    public static final String DECIMAL = "decimal";
    public static final String ARRAY_PRIMARY = "arrayprimary";

    public static PropertyType getDbColumnType(String type) {
        String lowerCaseType;
        PropertyType propertyType = new PropertyType(DbColumnType.STRING.getType(), DbColumnType.STRING.getPkg());
        if (HussarUtils.isEmpty((Object)type)) {
            return propertyType;
        }
        switch (lowerCaseType = type.toLowerCase()) {
            case "int": {
                propertyType.setType(DbColumnType.INTEGER.getType());
                propertyType.setImportT(DbColumnType.INTEGER.getPkg());
                propertyType.setlType(DbColumnType.INTEGER.getlType());
                break;
            }
            case "long": {
                propertyType.setType(DbColumnType.LONG.getType());
                propertyType.setImportT(DbColumnType.LONG.getPkg());
                propertyType.setlType(DbColumnType.LONG.getlType());
                break;
            }
            case "double": {
                propertyType.setType(DbColumnType.DOUBLE.getType());
                propertyType.setImportT(DbColumnType.DOUBLE.getPkg());
                propertyType.setlType(DbColumnType.DOUBLE.getlType());
                break;
            }
            case "date": {
                propertyType.setType(DbColumnType.LOCAL_DATE_TIME.getType());
                propertyType.setImportT(DbColumnType.LOCAL_DATE_TIME.getPkg());
                propertyType.setlType(DbColumnType.LOCAL_DATE_TIME.getlType());
                break;
            }
            case "boolean": {
                propertyType.setType(DbColumnType.BOOLEAN.getType());
                propertyType.setImportT(DbColumnType.BOOLEAN.getPkg());
                propertyType.setlType(DbColumnType.BOOLEAN.getlType());
                break;
            }
            case "object": {
                propertyType.setType(DbColumnType.OBJECT.getType());
                propertyType.setImportT(DbColumnType.OBJECT.getPkg());
                propertyType.setlType(DbColumnType.OBJECT.getlType());
                break;
            }
            case "array": 
            case "arrayprimary": {
                propertyType.setType(DbColumnType.ARRAY.getType());
                propertyType.setImportT(DbColumnType.ARRAY.getPkg());
                propertyType.setlType(DbColumnType.ARRAY.getlType());
                break;
            }
            case "decimal": {
                propertyType.setType(DbColumnType.BIG_DECIMAL.getType());
                propertyType.setImportT(DbColumnType.BIG_DECIMAL.getPkg());
                break;
            }
            default: {
                propertyType.setType(DbColumnType.STRING.getType());
                propertyType.setImportT(DbColumnType.STRING.getPkg());
                propertyType.setlType(DbColumnType.STRING.getlType());
            }
        }
        return propertyType;
    }

    public static boolean isBaseData(String dataType) {
        boolean isBaseData = true;
        if (HussarUtils.isNotEmpty((Object)dataType) && (dataType.equals(OBJECT) || dataType.equals(ARRAY))) {
            isBaseData = false;
        }
        return isBaseData;
    }
}

