/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.datasource.config;

import com.jxdinfo.hussar.datasource.config.ITypeConvert;
import com.jxdinfo.hussar.datasource.config.rules.DbType;
import com.jxdinfo.hussar.datasource.enm.DataSourceExceptionEnum;
import com.jxdinfo.hussar.datasource.exception.DataSourceException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.List;

public class DataSourceConfig {
    private Long id;
    private List<String> dbType;
    private String dbTypeCustom;
    private String schemaname;
    private ITypeConvert typeConvert;
    private String url;
    private String driverName;
    private String username;
    private String password;
    private String dbName;
    private String desc;
    private String name;
    private String version;
    private String dbMode;

    public List<String> getDbType() throws DataSourceException {
        if (null == this.dbType) {
            if (this.driverName.toLowerCase().contains("mysql")) {
                this.dbType = Arrays.asList("DATABASE", DbType.MYSQL.getValue());
            } else if (this.driverName.toLowerCase().contains("oracle")) {
                this.dbType = Arrays.asList("DATABASE", DbType.ORACLE.getValue());
            } else if (this.driverName.toLowerCase().contains("postgresql")) {
                this.dbType = Arrays.asList("DATABASE", DbType.POSTGRE_SQL.getValue());
            } else if (this.driverName.toLowerCase().contains("dm")) {
                this.dbType = Arrays.asList("DATABASE", DbType.DM.getValue());
            } else if (this.driverName.toLowerCase().contains("oscar")) {
                this.dbType = Arrays.asList("DATABASE", DbType.OSCAR.getValue());
            } else if (this.driverName.toLowerCase().contains("highgo")) {
                this.dbType = Arrays.asList("DATABASE", DbType.HIGHGO.getValue());
            } else {
                throw new DataSourceException(DataSourceExceptionEnum.NOT_FOUND_DATA_BASE, this.driverName);
            }
        }
        return this.dbType;
    }

    public void setDbType(List<String> dbType) {
        this.dbType = dbType;
    }

    public String getSchemaname() {
        return this.schemaname;
    }

    public void setSchemaname(String schemaname) {
        this.schemaname = schemaname;
    }

    public void setTypeConvert(ITypeConvert typeConvert) {
        this.typeConvert = typeConvert;
    }

    public Connection initConn() throws ClassNotFoundException, SQLException {
        Class.forName(this.driverName);
        return DriverManager.getConnection(this.url, this.username, this.password);
    }

    public String getDbTypeCustom() {
        return this.dbTypeCustom;
    }

    public void setDbTypeCustom(String dbTypeCustom) {
        this.dbTypeCustom = dbTypeCustom;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getDriverName() {
        return this.driverName;
    }

    public void setDriverName(String driverName) {
        this.driverName = driverName;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getDbName() {
        return this.dbName;
    }

    public void setDbName(String dbName) {
        this.dbName = dbName;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getDesc() {
        return this.desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getDbMode() {
        return this.dbMode;
    }

    public void setDbMode(String dbMode) {
        this.dbMode = dbMode;
    }
}

