/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.datasource.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.jxdinfo.hussar.datasource.config.DataSourceConfig;
import com.jxdinfo.hussar.datasource.config.DatasourceConfigDTO;
import com.jxdinfo.hussar.datasource.config.rules.DbType;
import com.jxdinfo.hussar.datasource.enm.DataSourceExceptionEnum;
import com.jxdinfo.hussar.datasource.exception.DataSourceException;
import com.jxdinfo.hussar.datasource.model.DsDBConnParam;
import com.jxdinfo.hussar.datasource.model.DsDatasource;
import com.jxdinfo.hussar.datasource.model.DsMethodType;
import com.jxdinfo.hussar.datasource.model.DsTableField;
import com.jxdinfo.hussar.datasource.model.DsTableInfo;
import com.jxdinfo.hussar.datasource.model.SysDataSource;
import com.jxdinfo.hussar.datasource.service.DataSourceService;
import com.jxdinfo.hussar.datasource.service.DatasourceDataService;
import com.jxdinfo.hussar.datasource.service.SysDataSourceService;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="com.jxdinfo.hussar.datasource.service.impl.DatasourceDataServiceImpl")
public class DatasourceDataServiceImpl
implements DatasourceDataService {
    private static final Logger logger = LoggerFactory.getLogger(DatasourceDataServiceImpl.class);
    private final DataSourceService dataSourceService;
    private final SysDataSourceService sysDataSourceService;

    @Autowired
    public DatasourceDataServiceImpl(DataSourceService dataSourceService, SysDataSourceService sysDataSourceService) {
        this.dataSourceService = dataSourceService;
        this.sysDataSourceService = sysDataSourceService;
    }

    @Override
    public DatasourceConfigDTO getById(String id) throws IOException {
        List<DatasourceConfigDTO> datasourceConfigDTOList = this.getList();
        if (null != datasourceConfigDTOList) {
            for (DatasourceConfigDTO configDTO : datasourceConfigDTOList) {
                if (!HussarUtils.equals((Object)configDTO.getId(), (Object)id)) continue;
                return configDTO;
            }
        }
        return null;
    }

    private DatasourceConfigDTO getDatasourceNameById(Long id) throws IOException {
        List<DatasourceConfigDTO> datasourceConfigDTOList = this.getList();
        if (null != datasourceConfigDTOList) {
            for (DatasourceConfigDTO configDTO : datasourceConfigDTOList) {
                if (!HussarUtils.equals((Object)configDTO.getId(), (Object)id)) continue;
                return configDTO;
            }
        }
        return null;
    }

    private DatasourceConfigDTO getDatasourceConfigById(Long id) throws DataSourceException {
        SysDataSource sysDataSource = (SysDataSource)this.sysDataSourceService.getById((Serializable)id);
        if (HussarUtils.isNotEmpty((Object)sysDataSource)) {
            return this.dataSourceService.getDatasourceConfig(sysDataSource);
        }
        throw new DataSourceException(DataSourceExceptionEnum.NOT_FOUND_DATA_BASE, "\u672a\u627e\u5230\u6570\u636e\u6e90");
    }

    @Override
    public List<DatasourceConfigDTO> getList() throws IOException {
        List<DatasourceConfigDTO> datasourceConfigDTOList = this.dataSourceService.getDataSourceList();
        return datasourceConfigDTOList;
    }

    @Override
    public List<DsTableInfo> getTableInfoById(Long id, String type) throws DataSourceException, IOException {
        List<DsTableInfo> dsTableInfoList = null;
        DatasourceConfigDTO configDTO = this.getDatasourceNameById(id);
        if (null != configDTO) {
            DataSourceConfig dataSourceConfig = this.getDataSourceConfig(configDTO);
            dsTableInfoList = this.dataSourceService.getDataSourceInfo(configDTO.getName(), dataSourceConfig, type);
        }
        return dsTableInfoList;
    }

    @Override
    public List<DsTableInfo> getTableInfoWithFieldInfoById(Long id, String type) throws DataSourceException, IOException {
        List<DsTableInfo> dsTableInfoList = null;
        DatasourceConfigDTO configDTO = this.getDatasourceNameById(id);
        if (null != configDTO) {
            DataSourceConfig dataSourceConfig = this.getDataSourceConfig(configDTO);
            dsTableInfoList = this.dataSourceService.getDataSourceInfoWithFieldInfo(configDTO.getName(), dataSourceConfig, type);
        }
        return dsTableInfoList;
    }

    @Override
    public List<DsTableInfo> getTableInfoWithFieldInfo(SysDataSource sysDataSource, String type) throws DataSourceException, IOException {
        List<DsTableInfo> dsTableInfoList = null;
        DatasourceConfigDTO configDTO = this.dataSourceService.getDatasourceConfig(sysDataSource);
        if (null != configDTO) {
            DataSourceConfig dataSourceConfig = this.getDataSourceConfig(configDTO);
            dsTableInfoList = this.dataSourceService.getDataSourceInfoWithFieldInfo(configDTO.getName(), dataSourceConfig, type);
        }
        return dsTableInfoList;
    }

    @Override
    public Optional<DsTableInfo> filterTable(Long id, String type, String tableName) throws DataSourceException, IOException {
        DatasourceConfigDTO configDTO = this.getDatasourceNameById(id);
        if (null != configDTO) {
            DataSourceConfig dataSourceConfig = this.getDataSourceConfig(configDTO);
            return this.dataSourceService.filterTable(configDTO.getName(), dataSourceConfig, type, tableName);
        }
        return Optional.empty();
    }

    @Override
    public Optional<DsTableInfo> filterTable(DatasourceConfigDTO configDTO, String type, String tableName) throws DataSourceException, IOException {
        if (null != configDTO) {
            DataSourceConfig dataSourceConfig = this.getDataSourceConfig(configDTO);
            return this.dataSourceService.filterTable(configDTO.getName(), dataSourceConfig, type, tableName);
        }
        return Optional.empty();
    }

    @Override
    public List<DsTableInfo> getTableById(Long id, String type) throws DataSourceException, IOException {
        List<DsTableInfo> dsTableInfoList = null;
        DatasourceConfigDTO configDTO = this.getDatasourceNameById(id);
        if (null != configDTO) {
            DataSourceConfig dataSourceConfig = this.getDataSourceConfig(configDTO);
            dsTableInfoList = this.dataSourceService.getDataSourceTableInfo(configDTO.getName(), dataSourceConfig, type);
        }
        return dsTableInfoList;
    }

    @Override
    public List<DsTableInfo> filterTables(Long id, String type, List<String> tableNames) throws DataSourceException, IOException {
        DatasourceConfigDTO configDTO = this.getDatasourceNameById(id);
        if (null != configDTO) {
            DataSourceConfig dataSourceConfig = this.getDataSourceConfig(configDTO);
            return this.dataSourceService.filterTables(configDTO.getName(), dataSourceConfig, type, tableNames);
        }
        return new ArrayList<DsTableInfo>();
    }

    private DataSourceConfig getDataSourceConfig(DatasourceConfigDTO dataSourceConfigDTO) throws IOException {
        DataSourceConfig dataSourceConfig = new DataSourceConfig();
        this.configConnParam(dataSourceConfigDTO, dataSourceConfig);
        dataSourceConfig.setUsername(dataSourceConfigDTO.getUsername());
        dataSourceConfig.setPassword(dataSourceConfigDTO.getPassword());
        dataSourceConfig.setDbType(Collections.singletonList(DbType.MYSQL.getValue()));
        dataSourceConfig.setDbName(dataSourceConfigDTO.getDbName());
        dataSourceConfig.setSchemaname(dataSourceConfigDTO.getSchemaname());
        dataSourceConfig.setDbMode(dataSourceConfigDTO.getDbMode());
        if (dataSourceConfigDTO.getDbType().size() > 1) {
            dataSourceConfig.setDbTypeCustom((String)dataSourceConfigDTO.getDbType().get(1));
        }
        return dataSourceConfig;
    }

    private void configConnParam(DatasourceConfigDTO dataSourceConfigDTO, DataSourceConfig dataSourceConfig) throws IOException {
        String host = dataSourceConfigDTO.getHost();
        String port = dataSourceConfigDTO.getPort();
        String dbType = "";
        if (dataSourceConfigDTO.getDbType().size() > 1) {
            dbType = (String)dataSourceConfigDTO.getDbType().get(1);
        }
        Map dbConnParamMap = this.getConnTypeConfigMap().get("DATABASE").getType();
        DsDBConnParam dsDbConnParam = (DsDBConnParam)dbConnParamMap.get(dbType);
        String urlTemplate = dsDbConnParam.getUrlTemplate();
        String driverName = dsDbConnParam.getDriverClassName();
        String url = urlTemplate.replace("${host}", host).replace("${port}", port).replace("${dbName}", dataSourceConfigDTO.getDbName());
        dataSourceConfig.setUrl(url);
        dataSourceConfig.setDriverName(driverName);
    }

    @Override
    public Map<String, DsDatasource> getConnTypeConfigMap() throws IOException {
        return this.getConnTypeConfigMapLocal();
    }

    private Map<String, DsDatasource> getConnTypeConfigMapLocal() throws IOException {
        return (Map)JSON.parseObject((String)this.dataSourceService.defaultDBTypeConfig(), (TypeReference)new TypeReference<HashMap<String, DsDatasource>>(){}, (Feature[])new Feature[0]);
    }

    private Map<String, DsDatasource> getConnTypeConfigMapRemote() {
        return (Map)JSON.parseObject((String)this.dataSourceService.defaultDBTypeConfig(), (TypeReference)new TypeReference<HashMap<String, DsDatasource>>(){}, (Feature[])new Feature[]{Feature.OrderedField});
    }

    @Override
    public List<DsMethodType> getMethodTypes() throws IOException {
        Map<String, DsDatasource> datasourceMap = this.getConnTypeConfigMap();
        ArrayList<DsMethodType> database = new ArrayList<DsMethodType>();
        datasourceMap.forEach((key, dsDatasource) -> {
            DsMethodType type = new DsMethodType();
            type.setLabel(key);
            type.setValue(key);
            if (HussarUtils.equals((Object)key, (Object)"DATABASE")) {
                ArrayList databaseTypeS = new ArrayList();
                dsDatasource.getType().forEach((typeKey, dsDbConnParam) -> {
                    DsMethodType databaseType = new DsMethodType();
                    databaseType.setValue(typeKey);
                    databaseType.setLabel(typeKey);
                    databaseType.setSupportDataType(dsDbConnParam.getSupportDataType());
                    databaseTypeS.add(databaseType);
                });
                type.setChildren(databaseTypeS);
            }
            database.add(type);
        });
        return database;
    }

    @Override
    public DatasourceConfigDTO getDefaultSource() throws IOException {
        return null;
    }

    @Override
    public List<DsTableInfo> getTableInfoWithoutFiled(Long id, String type) throws DataSourceException, IOException {
        List<DsTableInfo> dsTableInfoList = null;
        DatasourceConfigDTO configDTO = this.getDatasourceNameById(id);
        if (null != configDTO) {
            DataSourceConfig dataSourceConfig = this.getDataSourceConfig(configDTO);
            dsTableInfoList = this.dataSourceService.getTableInfoWithoutFiled(configDTO.getName(), dataSourceConfig, type);
        }
        return dsTableInfoList;
    }

    @Override
    public List<DsTableInfo> getTableInfoWithoutFiled(SysDataSource sysDataSource, String type) throws DataSourceException, IOException {
        List<DsTableInfo> dsTableInfoList = null;
        DatasourceConfigDTO configDTO = this.dataSourceService.getDatasourceConfig(sysDataSource);
        if (null != configDTO) {
            DataSourceConfig dataSourceConfig = this.getDataSourceConfig(configDTO);
            dsTableInfoList = this.dataSourceService.getTableInfoWithoutFiled(configDTO.getName(), dataSourceConfig, type);
        }
        return dsTableInfoList;
    }

    @Override
    public List<DsTableField> getTableFieldByTableName(Long id, String tableName) throws DataSourceException, IOException {
        List<DsTableField> dsTableFields = null;
        DatasourceConfigDTO configDTO = this.getDatasourceConfigById(id);
        if (null != configDTO) {
            DataSourceConfig dataSourceConfig = this.getDataSourceConfig(configDTO);
            dsTableFields = this.dataSourceService.getTableFieldByTableName(configDTO.getName(), dataSourceConfig, tableName);
        }
        return dsTableFields;
    }
}

