/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.document.word.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.document.common.model.DocDataBindInfo;
import com.jxdinfo.hussar.document.common.service.DocumentDataBindService;
import com.jxdinfo.hussar.document.common.service.impl.WordTypeInfoServiceImpl;
import com.jxdinfo.hussar.document.word.dao.WordEditorDetailsMapper;
import com.jxdinfo.hussar.document.word.dao.WordModelInfoMapper;
import com.jxdinfo.hussar.document.word.dto.WordEditorDetailChildListModel;
import com.jxdinfo.hussar.document.word.dto.WordEditorDetailListDto;
import com.jxdinfo.hussar.document.word.dto.WordEditorDetailsDto;
import com.jxdinfo.hussar.document.word.model.WordEditorDetails;
import com.jxdinfo.hussar.document.word.model.WordModelInfo;
import com.jxdinfo.hussar.document.word.service.IDocumentNotifierService;
import com.jxdinfo.hussar.document.word.service.WordDesignerExtend;
import com.jxdinfo.hussar.document.word.service.WordDetailOperationService;
import com.jxdinfo.hussar.document.word.service.impl.WordEditorDetailsServiceImpl;
import com.jxdinfo.hussar.document.word.service.impl.WordModelInfoServiceImpl;
import com.jxdinfo.hussar.document.word.vo.WordEditorDetailResponseVo;
import com.jxdinfo.hussar.document.word.vo.WordEditorDetailsVo;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.base.entity.BaseEntity;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.IdUtil;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="com.jxdinfo.hussar.document.word.service.impl.WordDetailOperationServiceImpl")
public class WordDetailOperationServiceImpl
implements WordDetailOperationService {
    private final String defaultGroupId = "2";
    @Resource
    private WordEditorDetailsServiceImpl wordEditorDetailsService;
    @Resource
    private WordModelInfoServiceImpl wordModelInfoService;
    @Autowired(required=false)
    private IDocumentNotifierService documentNotifierService;
    @Resource
    private WordTypeInfoServiceImpl wordTypeInfoService;
    @Resource
    private DocumentDataBindService documentDataBindService;
    @Autowired(required=false)
    private WordDesignerExtend wordDesignerExtend;

    @HussarTransactional
    public ApiResponse<WordEditorDetailsVo> getWordEditorDetail(WordEditorDetailsDto wordEditorDetailsDto) {
        Long businessId;
        ApiResponse<WordEditorDetails> wordEditorDetailsById;
        WordEditorDetailsVo wordEditorDetailsVo = new WordEditorDetailsVo();
        if (HussarUtils.isNotEmpty((Object)wordEditorDetailsDto) && HussarUtils.isNotEmpty((Object)wordEditorDetailsDto.getDetailsId()) && HussarUtils.isNotEmpty(wordEditorDetailsById = this.wordEditorDetailsService.getWordEditorDetailsById(businessId = wordEditorDetailsDto.getDetailsId())) && wordEditorDetailsById.isSuccess()) {
            wordEditorDetailsVo.setWordEditorDetail((WordEditorDetails)wordEditorDetailsById.getData());
            wordEditorDetailsVo.setDetailsId(wordEditorDetailsDto.getDetailsId());
            return ApiResponse.success((Object)this.customQueryProcessing(wordEditorDetailsDto, wordEditorDetailsVo));
        }
        return ApiResponse.success((Object)wordEditorDetailsVo);
    }

    @HussarTransactional
    public ApiResponse<WordEditorDetailsVo> saveWordEditorDetail(WordEditorDetailsDto wordEditorDetailsDto) {
        WordEditorDetailsVo wordEditorDetailsVo = new WordEditorDetailsVo();
        if (HussarUtils.isNotEmpty((Object)wordEditorDetailsDto) && HussarUtils.isNotEmpty((Object)wordEditorDetailsDto.getWordEditorDetails())) {
            ApiResponse<Long> longApiResponse;
            if (HussarUtils.isNotEmpty((Object)wordEditorDetailsDto.getDetailsId()) && HussarUtils.isEmpty((Object)wordEditorDetailsDto.getWordEditorDetails().getId())) {
                wordEditorDetailsDto.getWordEditorDetails().setId(wordEditorDetailsDto.getDetailsId());
            }
            if ((longApiResponse = this.wordEditorDetailsService.insertOrUpdate(wordEditorDetailsDto.getWordEditorDetails())).isSuccess()) {
                wordEditorDetailsVo.setDetailsId((Long)longApiResponse.getData());
            }
            WordEditorDetails wordEditorDetails = wordEditorDetailsDto.getWordEditorDetails();
            wordEditorDetailsVo.setWordEditorDetail(wordEditorDetails);
            WordEditorDetailsVo vo = this.customSaveProcessing(wordEditorDetailsDto, wordEditorDetailsVo);
            if (HussarUtils.isNotEmpty((Object)this.wordDesignerExtend)) {
                vo = this.wordDesignerExtend.customSaveProcessing(wordEditorDetailsDto, vo);
            }
            return ApiResponse.success((Object)vo);
        }
        return ApiResponse.success((Object)wordEditorDetailsVo);
    }

    public ApiResponse<List<WordEditorDetailResponseVo>> saveWordEditorDetails(WordEditorDetailListDto wordEditorDetailListDto) {
        ArrayList<WordEditorDetailResponseVo> responseVoList = new ArrayList<WordEditorDetailResponseVo>();
        if (HussarUtils.isNotEmpty((Object)wordEditorDetailListDto) && HussarUtils.isNotEmpty((Object)wordEditorDetailListDto.getWordEditorDetails())) {
            for (WordEditorDetailChildListModel wordEditorDetail : wordEditorDetailListDto.getWordEditorDetails()) {
                WordEditorDetailsDto tempWordEditorDetail = WordDetailOperationServiceImpl.getWordEditorDetailsDto(wordEditorDetailListDto, wordEditorDetail);
                ApiResponse<WordEditorDetailsVo> apiResponse = this.saveWordEditorDetail(tempWordEditorDetail);
                WordEditorDetailResponseVo responseVo = new WordEditorDetailResponseVo();
                responseVo.setSuccess(apiResponse.isSuccess());
                responseVo.setMsg(apiResponse.getMsg());
                if (apiResponse.isSuccess() && HussarUtils.isNotEmpty((Object)apiResponse.getData())) {
                    WordEditorDetailsVo responseData = (WordEditorDetailsVo)apiResponse.getData();
                    responseVo.setDetailId(String.valueOf(responseData.getDetailsId()));
                    responseVo.setDocId(String.valueOf(responseData.getExtendResult().get("docId")));
                    responseVo.setModelName(String.valueOf(responseData.getExtendResult().get("modelName")));
                }
                responseVoList.add(responseVo);
            }
            return ApiResponse.success(responseVoList);
        }
        return ApiResponse.fail((int)-1, responseVoList, (String)"\u4fdd\u5b58\u5931\u8d25");
    }

    @NotNull
    private static WordEditorDetailsDto getWordEditorDetailsDto(WordEditorDetailListDto wordEditorDetailListDto, WordEditorDetailChildListModel wordEditorDetail) {
        WordEditorDetailsDto tempWordEditorDetail = new WordEditorDetailsDto();
        tempWordEditorDetail.setDetailsId(wordEditorDetailListDto.getDetailsId());
        tempWordEditorDetail.setDatabindDetails(wordEditorDetailListDto.getDatabindDetails());
        tempWordEditorDetail.setWordDataSet(wordEditorDetailListDto.getWordDataSet());
        Map params = wordEditorDetailListDto.getParams();
        params.put("modelName", wordEditorDetail.getModelName());
        tempWordEditorDetail.setParams(params);
        WordEditorDetails wordEditorDetails = new WordEditorDetails();
        wordEditorDetails.setDetailOptions(wordEditorDetailListDto.getDetailOptions());
        wordEditorDetails.setDetailContent(wordEditorDetail.getDetailContent());
        tempWordEditorDetail.setWordEditorDetails(wordEditorDetails);
        tempWordEditorDetail.setInterFaceName(wordEditorDetailListDto.getInterFaceName());
        return tempWordEditorDetail;
    }

    public WordEditorDetailsVo customSaveProcessing(WordEditorDetailsDto wordEditorDetailsDto, WordEditorDetailsVo wordEditorDetailsVo) {
        Map params = wordEditorDetailsDto.getParams();
        if (HussarUtils.isNotEmpty((Object)params)) {
            WordModelInfo wordModelInfo = new WordModelInfo();
            if (HussarUtils.isNotEmpty(params.get("docId"))) {
                wordModelInfo.setId(Long.valueOf(params.get("docId").toString()));
            } else {
                wordModelInfo.setId(Long.valueOf(IdUtil.getSnowflakeNextId()));
            }
            wordModelInfo.setModelName(params.get("modelName").toString());
            if (HussarUtils.isNotEmpty(params.get("groupId"))) {
                wordModelInfo.setGroupId(Long.valueOf(params.get("groupId").toString()));
            } else {
                wordModelInfo.setGroupId(Long.valueOf("2"));
            }
            if (ToolUtil.isNotEmpty(params.get("parentModelId"))) {
                wordModelInfo.setParentModelId(Long.valueOf(params.get("parentModelId").toString()));
            }
            wordModelInfo.setDetailsId(wordEditorDetailsVo.getDetailsId().toString());
            this.wordModelInfoService.saveOrUpdate((BaseEntity)wordModelInfo);
            if (this.documentNotifierService != null) {
                this.documentNotifierService.notifyTitleChanged(wordModelInfo.getId(), wordModelInfo.getModelName());
            }
            String modelName = params.get("modelName").toString();
            this.wordTypeInfoService.addOrUpdateWordDocTypeInfo(wordModelInfo.getId(), modelName, -1);
            DocDataBindInfo dataBindInfo = new DocDataBindInfo();
            dataBindInfo.setDataBindId(wordModelInfo.getId());
            dataBindInfo.setDocId(wordModelInfo.getId());
            if (HussarUtils.isNotEmpty((Object)wordEditorDetailsDto.getInterFaceName())) {
                dataBindInfo.setInterFaceName(wordEditorDetailsDto.getInterFaceName());
            }
            if (HussarUtils.isNotEmpty((Object)wordEditorDetailsDto.getWordDataSet())) {
                dataBindInfo.setWordDataSet(wordEditorDetailsDto.getWordDataSet());
            }
            if (HussarUtils.isNotEmpty((Object)wordEditorDetailsDto.getDatabindDetails())) {
                dataBindInfo.setDataBindDetails(wordEditorDetailsDto.getDatabindDetails());
            }
            this.documentDataBindService.insertOrUpdate(dataBindInfo);
            HashMap<String, Object> extendResult = new HashMap<String, Object>();
            extendResult.put("docId", wordModelInfo.getId());
            extendResult.put("groupId", wordModelInfo.getGroupId());
            extendResult.put("modelName", wordModelInfo.getModelName());
            wordEditorDetailsVo.setExtendResult(extendResult);
        }
        return wordEditorDetailsVo;
    }

    public WordEditorDetailsVo customQueryProcessing(WordEditorDetailsDto wordEditorDetailsDto, WordEditorDetailsVo wordEditorDetailsVo) {
        Map extendResult = wordEditorDetailsDto.getParams();
        if (ToolUtil.isNotEmpty((Object)wordEditorDetailsDto.getParams()) && ToolUtil.isNotEmpty(wordEditorDetailsDto.getParams().get("docId"))) {
            String docId = wordEditorDetailsDto.getParams().get("docId").toString();
            LambdaQueryWrapper wordModelInfoLambdaQueryWrapper = new LambdaQueryWrapper();
            wordModelInfoLambdaQueryWrapper.eq(WordModelInfo::getParentModelId, (Object)docId);
            List wordModelInfos = ((WordModelInfoMapper)this.wordModelInfoService.getBaseMapper()).selectList((Wrapper)wordModelInfoLambdaQueryWrapper);
            if (ToolUtil.isNotEmpty((Object)wordModelInfos)) {
                ArrayList<Long> businessIds = new ArrayList<Long>();
                for (WordModelInfo wordModelInfo : wordModelInfos) {
                    businessIds.add(Long.valueOf(wordModelInfo.getDetailsId()));
                }
                List wordEditorDetails = ((WordEditorDetailsMapper)this.wordEditorDetailsService.getBaseMapper()).selectBatchIds(businessIds);
                extendResult.put("childDetails", wordEditorDetails);
            }
        }
        wordEditorDetailsVo.setExtendResult(extendResult);
        return wordEditorDetailsVo;
    }
}

