/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.document.word.service.impl;

import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.document.editor.core.word.factory.WordJsonParseFactory;
import com.jxdinfo.hussar.document.word.dao.WordDocInfoMapper;
import com.jxdinfo.hussar.document.word.dao.WordEditorDetailsMapper;
import com.jxdinfo.hussar.document.word.dto.WordDocInfoDto;
import com.jxdinfo.hussar.document.word.model.WordDocInfo;
import com.jxdinfo.hussar.document.word.service.WordDocParseService;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service(value="com.jxdinfo.hussar.document.word.service.impl.wordDocParseServiceImpl")
public class WordDocParseServiceImpl
implements WordDocParseService {
    @Resource
    private WordDocInfoMapper mapper;
    @Resource
    private WordEditorDetailsMapper wordEditorDetailsMapper;

    public ApiResponse<Object> parse(WordDocInfoDto wordDocInfoDto, MultipartFile multipartFile) {
        Map parse = WordJsonParseFactory.get((String)"docx").parse(multipartFile);
        String originalFilename = multipartFile.getOriginalFilename();
        WordDocInfo wordDocInfo = new WordDocInfo();
        String docId = UUID.randomUUID().toString();
        wordDocInfo.setId(Long.valueOf(Long.parseLong(docId)));
        wordDocInfo.setGroupId(wordDocInfoDto.getGroupId());
        wordDocInfo.setDocName(originalFilename);
        wordDocInfo.setCreator(BaseSecurityUtil.getUser().getId());
        wordDocInfo.setLastEditor(BaseSecurityUtil.getUser().getId());
        wordDocInfo.setDelFlag("0");
        int row = this.mapper.insert(wordDocInfo);
        return ApiResponse.success((String)docId);
    }
}

