/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.document.word.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.document.common.model.DocDataBindInfo;
import com.jxdinfo.hussar.document.common.service.DocumentDataBindService;
import com.jxdinfo.hussar.document.common.service.impl.WordTypeInfoServiceImpl;
import com.jxdinfo.hussar.document.word.dao.WordModelInfoMapper;
import com.jxdinfo.hussar.document.word.dto.WordEditorDetailsDto;
import com.jxdinfo.hussar.document.word.extend.WordDesignerExtendFactory;
import com.jxdinfo.hussar.document.word.model.WordModelInfo;
import com.jxdinfo.hussar.document.word.service.IDocumentNotifierService;
import com.jxdinfo.hussar.document.word.service.WordDesignerExtend;
import com.jxdinfo.hussar.document.word.service.WordEditorDetailsService;
import com.jxdinfo.hussar.document.word.service.impl.WordModelInfoServiceImpl;
import com.jxdinfo.hussar.document.word.vo.WordEditorDetailsVo;
import com.jxdinfo.hussar.platform.core.base.entity.BaseEntity;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.IdUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="com.jxdinfo.hussar.document.word.service.impl.WordDesignerDefaultRule")
public class WordDesignerDefaultRule
implements WordDesignerExtend,
InitializingBean {
    private final String extendType = "defaultRule";
    private final String defaultGroupId = "2";
    @Resource
    private WordModelInfoServiceImpl wordModelInfoService;
    @Resource
    private WordEditorDetailsService wordEditorDetailsService;
    @Autowired(required=false)
    private IDocumentNotifierService documentNotifierService;
    @Resource
    private WordTypeInfoServiceImpl wordTypeInfoService;
    @Resource
    private DocumentDataBindService documentDataBindService;

    public WordEditorDetailsVo customSaveProcessing(WordEditorDetailsDto wordEditorDetailsDto, WordEditorDetailsVo wordEditorDetailsVo) {
        Map params = wordEditorDetailsDto.getParams();
        if (HussarUtils.isNotEmpty((Object)params)) {
            WordModelInfo wordModelInfo = new WordModelInfo();
            if (HussarUtils.isNotEmpty(params.get("docId"))) {
                wordModelInfo.setId(Long.valueOf(params.get("docId").toString()));
            } else {
                wordModelInfo.setId(Long.valueOf(IdUtil.getSnowflakeNextId()));
            }
            wordModelInfo.setModelName(params.get("modelName").toString());
            if (HussarUtils.isNotEmpty(params.get("groupId"))) {
                wordModelInfo.setGroupId(Long.valueOf(params.get("groupId").toString()));
            } else {
                wordModelInfo.setGroupId(Long.valueOf("2"));
            }
            if (ToolUtil.isNotEmpty(params.get("parentModelId"))) {
                wordModelInfo.setParentModelId(Long.valueOf(params.get("parentModelId").toString()));
            }
            wordModelInfo.setDetailsId(wordEditorDetailsVo.getDetailsId().toString());
            this.wordModelInfoService.saveOrUpdate((BaseEntity)wordModelInfo);
            if (this.documentNotifierService != null) {
                this.documentNotifierService.notifyTitleChanged(wordModelInfo.getId(), wordModelInfo.getModelName());
            }
            String modelName = params.get("modelName").toString();
            this.wordTypeInfoService.addOrUpdateWordDocTypeInfo(wordModelInfo.getId(), modelName, -1);
            DocDataBindInfo dataBindInfo = new DocDataBindInfo();
            dataBindInfo.setDataBindId(wordModelInfo.getId());
            dataBindInfo.setDocId(wordModelInfo.getId());
            if (HussarUtils.isNotEmpty((Object)wordEditorDetailsDto.getInterFaceName())) {
                dataBindInfo.setInterFaceName(wordEditorDetailsDto.getInterFaceName());
            }
            if (HussarUtils.isNotEmpty((Object)wordEditorDetailsDto.getWordDataSet())) {
                dataBindInfo.setWordDataSet(wordEditorDetailsDto.getWordDataSet());
            }
            if (HussarUtils.isNotEmpty((Object)wordEditorDetailsDto.getDatabindDetails())) {
                dataBindInfo.setDataBindDetails(wordEditorDetailsDto.getDatabindDetails());
            }
            this.documentDataBindService.insertOrUpdate(dataBindInfo);
            HashMap<String, Object> extendResult = new HashMap<String, Object>();
            extendResult.put("docId", wordModelInfo.getId());
            extendResult.put("groupId", wordModelInfo.getGroupId());
            extendResult.put("modelName", wordModelInfo.getModelName());
            wordEditorDetailsVo.setExtendResult(extendResult);
        }
        return wordEditorDetailsVo;
    }

    public WordEditorDetailsVo customQueryProcessing(WordEditorDetailsDto wordEditorDetailsDto, WordEditorDetailsVo wordEditorDetailsVo) {
        Map extendResult = wordEditorDetailsDto.getParams();
        if (ToolUtil.isNotEmpty((Object)wordEditorDetailsDto.getParams()) && ToolUtil.isNotEmpty(wordEditorDetailsDto.getParams().get("docId"))) {
            String docId = wordEditorDetailsDto.getParams().get("docId").toString();
            LambdaQueryWrapper wordModelInfoLambdaQueryWrapper = new LambdaQueryWrapper();
            wordModelInfoLambdaQueryWrapper.eq(WordModelInfo::getParentModelId, (Object)docId);
            List wordModelInfos = ((WordModelInfoMapper)this.wordModelInfoService.getBaseMapper()).selectList((Wrapper)wordModelInfoLambdaQueryWrapper);
            if (ToolUtil.isNotEmpty((Object)wordModelInfos)) {
                ArrayList<Long> businessIds = new ArrayList<Long>();
                for (WordModelInfo wordModelInfo : wordModelInfos) {
                    businessIds.add(Long.valueOf(wordModelInfo.getDetailsId()));
                }
                List wordEditorDetails = this.wordEditorDetailsService.getBaseMapper().selectBatchIds(businessIds);
                extendResult.put("childDetails", wordEditorDetails);
            }
        }
        wordEditorDetailsVo.setExtendResult(extendResult);
        return wordEditorDetailsVo;
    }

    public Map<String, Object> customExportProcessing(String detailsId) {
        WordModelInfo wordModelInfo;
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        if (HussarUtils.isNotEmpty((Object)detailsId) && HussarUtils.isNotEmpty((Object)(wordModelInfo = this.wordModelInfoService.getByWordDetailId(detailsId))) && HussarUtils.isNotEmpty((Object)wordModelInfo.getModelName())) {
            resultMap.put("docName", wordModelInfo.getModelName());
        }
        return resultMap;
    }

    public void afterPropertiesSet() throws Exception {
        WordDesignerExtendFactory.add((String)"defaultRule", (WordDesignerExtend)this);
    }
}

