/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.document.common.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.common.base.HussarDelflagEntity;
import com.jxdinfo.hussar.document.common.DocumentType;
import com.jxdinfo.hussar.document.common.dao.WordDocTypeInfoMapper;
import com.jxdinfo.hussar.document.common.model.WordDocTypeInfo;
import com.jxdinfo.hussar.document.common.service.IWordTypeInfoService;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.base.entity.BaseEntity;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.IdUtil;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import java.util.List;
import org.springframework.stereotype.Service;

@Service(value="com.jxdinfo.hussar.document.common.service.impl.WordTypeInfoServiceImpl")
public class WordTypeInfoServiceImpl
extends HussarServiceImpl<WordDocTypeInfoMapper, WordDocTypeInfo>
implements IWordTypeInfoService {
    public static final String WORD_EMPTY_MODEL_NAME_DEFAULT = "\u65e0\u6807\u9898\u6587\u6863";

    @Override
    public List<WordDocTypeInfo> queryList(Long docId) {
        LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)lambdaQueryWrapper.eq(WordDocTypeInfo::getReportId, (Object)docId)).eq(HussarDelflagEntity::getDelFlag, (Object)"0");
        List infoList = ((WordDocTypeInfoMapper)this.baseMapper).selectList((Wrapper)lambdaQueryWrapper);
        return infoList;
    }

    @Override
    public int insert(WordDocTypeInfo wordDocTypeInfo) {
        return ((WordDocTypeInfoMapper)this.baseMapper).insert((Object)wordDocTypeInfo);
    }

    @Override
    public ApiResponse<Long> addWordTypeInfo(Long reportId, String reportName, int reportType) {
        WordDocTypeInfo wordDocTypeInfo = new WordDocTypeInfo();
        Long wordDocTypeInfoId = IdUtil.getSnowflakeNextId();
        wordDocTypeInfo.setId(wordDocTypeInfoId);
        wordDocTypeInfo.setReportId(reportId);
        wordDocTypeInfo.setReportName(reportName);
        wordDocTypeInfo.setReportType(reportType);
        ((WordDocTypeInfoMapper)this.baseMapper).insert((Object)wordDocTypeInfo);
        return ApiResponse.success((Object)wordDocTypeInfoId);
    }

    @Override
    public ApiResponse<Long> addOrUpdateWordDocTypeInfo(Long reportId, String reportName, int typeCode) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        WordDocTypeInfo wordDocTypeInfo = new WordDocTypeInfo();
        ((LambdaQueryWrapper)queryWrapper.eq(WordDocTypeInfo::getReportId, (Object)reportId)).eq(HussarDelflagEntity::getDelFlag, (Object)"0");
        List typeInfoList = ((WordDocTypeInfoMapper)this.baseMapper).selectList((Wrapper)queryWrapper);
        if (HussarUtils.isNotEmpty((Object)typeInfoList)) {
            wordDocTypeInfo.setId(((WordDocTypeInfo)((Object)typeInfoList.get(0))).getId());
            if (typeCode < 0) {
                typeCode = ((WordDocTypeInfo)((Object)typeInfoList.get(0))).getReportType();
            }
        } else {
            long nextId = IdUtil.getSnowflakeNextId();
            wordDocTypeInfo.setId(nextId);
            if (typeCode < 0) {
                typeCode = DocumentType.WORD_MODEL.getTypeCode();
            }
        }
        wordDocTypeInfo.setReportId(reportId);
        wordDocTypeInfo.setReportName(reportName);
        wordDocTypeInfo.setReportType(typeCode);
        this.saveOrUpdate((BaseEntity)wordDocTypeInfo);
        return ApiResponse.success((Object)wordDocTypeInfo.getId());
    }

    public Long copyWordTypeInfo(Long oldDocId, Long newDocId, int defaultTypeCode) {
        List<WordDocTypeInfo> docTypeInfoList = this.queryList(oldDocId);
        String modelName = WORD_EMPTY_MODEL_NAME_DEFAULT;
        int typeCode = defaultTypeCode;
        if (HussarUtils.isNotEmpty(docTypeInfoList)) {
            modelName = docTypeInfoList.get(0).getReportName();
            typeCode = docTypeInfoList.get(0).getReportType();
        }
        return (Long)this.addOrUpdateWordDocTypeInfo(newDocId, modelName, typeCode).getData();
    }
}

