/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.document.common.service.impl;

import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.core.exception.HussarException;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.document.common.dto.AttachmentInfoDto;
import com.jxdinfo.hussar.document.common.service.IFileService;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.FileUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.oss.api.service.OssService;
import com.jxdinfo.hussar.support.oss.core.support.entity.AttachmentManagerModel;
import java.io.IOException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service(value="com.jxdinfo.hussar.document.common.service.impl.OssFileServiceImpl")
@ConditionalOnClass(name={"com.jxdinfo.hussar.support.oss.api.service.OssService"})
@ConditionalOnBean(value={IFileService.class})
@Qualifier(value="oss")
public class OssFileServiceImpl
implements IFileService {
    @Autowired(required=false)
    private OssService ossService;

    @Override
    public ApiResponse<AttachmentInfoDto> upload(MultipartFile multipartFile) {
        AttachmentInfoDto attachmentInfoDto = new AttachmentInfoDto();
        ApiResponse upload = this.ossService.backgroundUpload(multipartFile);
        if (upload.isSuccess()) {
            attachmentInfoDto = this.getModelById((Long)upload.getData());
        }
        return ApiResponse.success((Object)attachmentInfoDto);
    }

    @Override
    public void download(HttpServletResponse response, Long fileId) {
        ApiResponse<byte[]> apiResponse = this.backgroundDownload(fileId);
        byte[] data = (byte[])apiResponse.getData();
        response.setContentType("multipart/form-data");
        try (ServletOutputStream outputStream = response.getOutputStream();){
            outputStream.write(data);
            outputStream.flush();
        }
        catch (IOException e) {
            throw new HussarException("\u56fe\u7247\u4e0b\u8f7d\u5931\u8d25", (Throwable)e);
        }
    }

    @Override
    public void showImage(Long id, HttpServletResponse response) {
        if (ToolUtil.isEmpty((Object)id)) {
            throw new BaseException("\u56fe\u7247id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        response.setContentType("text/html; charset=UTF-8");
        AttachmentInfoDto attachment = this.getModelById(id);
        if (attachment == null) {
            throw new BaseException("\u56fe\u7247\u4e0d\u5b58\u5728");
        }
        String extension = FileUtil.getFileExtension((String)attachment.getAttachmentName()).toLowerCase();
        String contentType = "";
        switch (extension) {
            case "png": {
                contentType = "image/png";
                break;
            }
            case "jpg": 
            case "jpeg": {
                contentType = "image/jpeg";
                break;
            }
            case "wmf": {
                contentType = "image/wmf";
                break;
            }
            default: {
                contentType = "application/octet-stream";
            }
        }
        response.setContentType(contentType);
        byte[] image = (byte[])this.backgroundDownload(id).getData();
        try (ServletOutputStream outputStream = response.getOutputStream();){
            outputStream.write(image);
            outputStream.flush();
        }
        catch (IOException e) {
            throw new HussarException("\u56fe\u7247\u5c55\u793a\u5931\u8d25", (Throwable)e);
        }
    }

    @Override
    public ApiResponse<byte[]> backgroundDownload(Long fileId) {
        ApiResponse apiResponse = this.ossService.backgroundDownload(fileId);
        return apiResponse;
    }

    @Override
    public AttachmentInfoDto getModelById(Long fileId) {
        AttachmentManagerModel model = this.ossService.getModelById(fileId);
        AttachmentInfoDto attachmentInfoDto = new AttachmentInfoDto();
        if (HussarUtils.isNotEmpty((Object)model)) {
            attachmentInfoDto.setFileId(model.getId());
            attachmentInfoDto.setPath(model.getAttachmentDir());
            attachmentInfoDto.setBusinessId(model.getBusinessId());
            attachmentInfoDto.setAttachmentName(model.getAttachmentName());
            attachmentInfoDto.setAttachmentType(model.getAttachmentType());
        }
        return attachmentInfoDto;
    }
}

