/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.dispatcher.model;

import com.jxdinfo.hussar.dispatcher.util.QueryStringUtil;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import javax.servlet.ReadListener;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import org.apache.catalina.util.RequestUtil;

public class CustomRequest
extends HttpServletRequestWrapper {
    private List<String> ignoreHeader = new ArrayList<String>();
    private byte[] body;
    private String contentType;
    private final String method;
    private final String requestURI;
    private Map<String, String[]> paramsMap;

    public CustomRequest(HttpServletRequest request, String method, String requestURI, Map<String, String[]> paramsMap) {
        super(request);
        this.method = method;
        this.requestURI = requestURI;
        this.paramsMap = paramsMap;
    }

    public CustomRequest(HttpServletRequest request, String method, String requestURI) {
        this(request, method, requestURI, request.getParameterMap());
    }

    public Map<String, String[]> getParameterMap() {
        return this.paramsMap;
    }

    public String getParameter(String name) {
        String[] values = this.getParameterValues(name);
        if (values != null && values.length > 0) {
            return values[0];
        }
        return null;
    }

    public Enumeration<String> getParameterNames() {
        return Collections.enumeration(this.paramsMap.keySet());
    }

    public String[] getParameterValues(String name) {
        return this.paramsMap.getOrDefault(name, new String[0]);
    }

    public String getMethod() {
        return this.method;
    }

    public String getRequestURI() {
        return this.requestURI;
    }

    public String getServletPath() {
        return this.requestURI;
    }

    public BufferedReader getReader() throws IOException {
        if (this.body == null) {
            return super.getReader();
        }
        return new BufferedReader(new InputStreamReader((InputStream)this.getInputStream()));
    }

    public ServletInputStream getInputStream() throws IOException {
        if (this.body == null) {
            return super.getInputStream();
        }
        final ByteArrayInputStream inputStream = new ByteArrayInputStream(this.body);
        return new ServletInputStream(){

            public int read() {
                return inputStream.read();
            }

            public boolean isFinished() {
                return false;
            }

            public boolean isReady() {
                return false;
            }

            public void setReadListener(ReadListener readListener) {
            }
        };
    }

    public void addIgnoreHeader(String header) {
        this.ignoreHeader.add(header);
    }

    public String getContentType() {
        return this.contentType;
    }

    public Enumeration<String> getHeaderNames() {
        Enumeration headerNames = super.getHeaderNames();
        if (this.ignoreHeader.isEmpty()) {
            return headerNames;
        }
        ArrayList<String> headerNameList = new ArrayList<String>();
        Enumeration names = headerNames;
        while (names.hasMoreElements()) {
            String headerName = (String)names.nextElement();
            if (this.ignoreHeader.contains(headerName)) continue;
            headerNameList.add(headerName);
        }
        return Collections.enumeration(headerNameList);
    }

    public Enumeration<String> getHeaders(String name) {
        if ("Content-Type".equalsIgnoreCase(name)) {
            return Collections.enumeration(Collections.singleton(this.contentType));
        }
        return super.getHeaders(name);
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public void setBody(String bodyStr) {
        this.body = bodyStr.getBytes(Charset.defaultCharset());
    }

    public void setParamsMap(Map<String, String[]> paramsMap) {
        this.paramsMap = paramsMap;
    }

    public String getQueryString() {
        if (this.paramsMap.isEmpty()) {
            return "";
        }
        return QueryStringUtil.getQueryString(this.paramsMap);
    }

    public StringBuffer getRequestURL() {
        return RequestUtil.getRequestURL((HttpServletRequest)this);
    }
}

