/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.datasource.service.impl;

import com.baomidou.mybatisplus.annotation.DbType;
import com.google.common.collect.Lists;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.datasource.dto.SysDataSourceDto;
import com.jxdinfo.hussar.datasource.factory.DatabaseFactory;
import com.jxdinfo.hussar.datasource.service.IHussarBaseDatabaseOperateService;
import com.jxdinfo.hussar.datasource.service.impl.AbstractDatabaseOperateService;
import com.jxdinfo.hussar.datasource.util.HussarTenantScriptUtils;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.io.Resource;
import org.springframework.jdbc.datasource.init.ScriptException;
import org.springframework.stereotype.Service;

@Service(value="com.jxdinfo.hussar.datasource.service.impl.oscarDatabaseOperateServiceImpl")
public class OscarDatabaseOperateServiceImpl
extends AbstractDatabaseOperateService
implements InitializingBean {
    private static Pattern dropTablePattern = Pattern.compile("\\bDROP\\s+TABLE\\b", 32);

    public SysDataSourceDto createSchema(SysDataSourceDto sysDataSourceDto) throws BaseException, IOException, SQLException {
        ArrayList sqls = Lists.newArrayList((Object[])new String[]{"CREATE USER " + sysDataSourceDto.getDbName() + " WITH PASSWORD '" + sysDataSourceDto.getPassword() + "'", "GRANT ALL PRIVILEGES ON SCHEMA " + sysDataSourceDto.getDbName() + " TO " + sysDataSourceDto.getDbName()});
        this.executeMoreSql(sqls);
        return sysDataSourceDto;
    }

    public Resource[] getInitExecuteSQLScripts() throws IOException {
        Resource[] resources = SpringContextHolder.getApplicationContext().getResources("classpath*:tenantsql/init/oscar/*.sql");
        return resources;
    }

    public Resource[] getUpgradeExecuteSQLScripts() throws IOException {
        Resource[] resources = SpringContextHolder.getApplicationContext().getResources("classpath*:tenantsql/upgrade/oscar/*.sql");
        return resources;
    }

    public void setParametersByMaster(SysDataSourceDto sysDataSourceDto) {
        String url = sysDataSourceDto.getJdbcUrl();
        if (url.contains("?")) {
            url = url.substring(0, url.indexOf("?"));
        }
        String newUrl = url + "?schema=\"" + sysDataSourceDto.getDbName() + "\"";
        sysDataSourceDto.setJdbcUrl(newUrl);
        sysDataSourceDto.setDataBaseName(sysDataSourceDto.getDbName());
        sysDataSourceDto.setUserName(sysDataSourceDto.getDbName());
    }

    public void afterPropertiesSet() throws Exception {
        DatabaseFactory.add((String)DbType.OSCAR.getDb(), (IHussarBaseDatabaseOperateService)this);
    }

    public List<String> preTreatment(Connection connection, Resource resource, boolean drop) throws IOException, ScriptException {
        InputStream inputStream = resource.getInputStream();
        List statements = HussarTenantScriptUtils.getSplitSqlScript((InputStream)inputStream);
        if (drop) {
            return statements;
        }
        ArrayList<String> result = new ArrayList<String>();
        for (String statement : statements) {
            String temp;
            if (!StringUtils.isNotBlank((CharSequence)statement) || dropTablePattern.matcher(temp = statement.trim().toUpperCase()).find()) continue;
            result.add(statement);
        }
        return result;
    }
}

