/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.datasource.service.impl;

import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.datasource.dto.SysDataSourceDto;
import com.jxdinfo.hussar.datasource.factory.DatabaseFactory;
import com.jxdinfo.hussar.datasource.service.IHussarBaseDatabaseOperateService;
import com.jxdinfo.hussar.datasource.service.impl.AbstractDatabaseOperateService;
import com.jxdinfo.hussar.datasource.util.HussarTenantScriptUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarDs;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.io.Resource;
import org.springframework.jdbc.datasource.init.ScriptException;
import org.springframework.stereotype.Service;

@Service(value="com.jxdinfo.hussar.datasource.service.impl.KingBaseOracleDatabaseOperateServiceImpl")
public class KingBaseOracleDatabaseOperateServiceImpl
extends AbstractDatabaseOperateService
implements InitializingBean {
    private static Pattern dropTablePattern = Pattern.compile("\\bDROP\\s+TABLE\\b", 32);
    public static final Pattern declareTablePattern = Pattern.compile("\\bDECLARE\\s+", 8);
    public static final Pattern beginSelectTablePattern = Pattern.compile("\\bBEGIN\\s+SELECT(.*)FROM\\b", 32);
    public static final Pattern ifThenTablePattern = Pattern.compile("\\bIF(.*)THEN\\b", 32);
    public static final Pattern declareEndIfPattern = Pattern.compile("\\bEND\\s+IF\\b", 8);

    @HussarDs(value="master")
    public SysDataSourceDto createSchema(SysDataSourceDto sysDataSourceDto) throws BaseException, IOException, SQLException {
        String sql = "CREATE DATABASE \"" + sysDataSourceDto.getDbName() + "\" WITH OWNER = \"" + sysDataSourceDto.getUserName() + "\" ENCODING UTF8";
        this.execute(sql);
        return sysDataSourceDto;
    }

    public Resource[] getInitExecuteSQLScripts() throws IOException {
        Resource[] resources = SpringContextHolder.getApplicationContext().getResources("classpath*:tenantsql/init/kingbase/*.sql");
        return resources;
    }

    public Resource[] getUpgradeExecuteSQLScripts() throws IOException {
        Resource[] resources = SpringContextHolder.getApplicationContext().getResources("classpath*:tenantsql/upgrade/kingbase/*.sql");
        return resources;
    }

    public void setParametersByMaster(SysDataSourceDto sysDataSourceDto) {
        String url = sysDataSourceDto.getJdbcUrl();
        if (url.contains("?")) {
            url = url.substring(0, url.indexOf("?"));
        }
        String newUrl = url.substring(0, url.lastIndexOf("/") + 1) + sysDataSourceDto.getDbName();
        sysDataSourceDto.setJdbcUrl(newUrl);
    }

    public void afterPropertiesSet() throws Exception {
        DatabaseFactory.add((String)"kingbase", (IHussarBaseDatabaseOperateService)this);
    }

    public List<String> preTreatment(Connection connection, Resource resource, boolean drop) throws IOException, ScriptException {
        InputStream inputStream = resource.getInputStream();
        List statements = HussarTenantScriptUtils.getSplitSqlScript((InputStream)inputStream);
        ArrayList<String> result = new ArrayList<String>();
        for (String statement : statements) {
            if (!StringUtils.isNotBlank((CharSequence)statement)) continue;
            this.matchRemoveSql(drop, result, statement);
        }
        return result;
    }

    private void matchRemoveSql(boolean drop, List<String> result, String statement) {
        String temp = statement.trim().toUpperCase();
        if (declareTablePattern.matcher(temp).find()) {
            return;
        }
        if (beginSelectTablePattern.matcher(temp).find()) {
            return;
        }
        if (ifThenTablePattern.matcher(temp).find()) {
            return;
        }
        if (declareEndIfPattern.matcher(temp).find()) {
            return;
        }
        if (temp.equals("END")) {
            return;
        }
        if (dropTablePattern.matcher(temp).find()) {
            if (drop) {
                result.add(statement);
            }
        } else {
            result.add(statement);
        }
    }
}

