/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.datasource.controller;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.github.xiaoymin.knife4j.annotations.ApiOperationSupport;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.utils.AssertUtil;
import com.jxdinfo.hussar.datasource.dto.SysDataSourceDto;
import com.jxdinfo.hussar.datasource.dto.TenantPermissonDto;
import com.jxdinfo.hussar.datasource.manager.api.service.DatasourceService;
import com.jxdinfo.hussar.datasource.model.SysDataSource;
import com.jxdinfo.hussar.datasource.service.SysDataSourceService;
import com.jxdinfo.hussar.datasource.util.DbUtil;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.audit.core.annotations.AuditLog;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventGrade;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventType;
import com.jxdinfo.hussar.support.mp.base.controller.HussarBaseController;
import com.jxdinfo.hussar.support.mp.base.query.generator.SingleTableQueryGenerator;
import com.jxdinfo.hussar.support.security.core.annotation.CheckPermission;
import com.jxdinfo.hussar.tenant.common.model.HussarTenantDefinition;
import com.jxdinfo.hussar.tenant.common.util.HussarContextHolder;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/datasource"})
@Api(tags={"\u6570\u636e\u6e90\u7ba1\u7406"})
public class SysDataSourceController
extends HussarBaseController<SysDataSource, SysDataSourceService> {
    @Resource
    private SysDataSourceService sysDataSourceService;
    @Autowired
    private DatasourceService datasourceService;

    @CheckPermission(value={"datasource:detail"})
    @GetMapping(value={"/detail"})
    @ApiOperation(value="\u6839\u636edbId\u83b7\u53d6\u6570\u636e\u6e90\u4fe1\u606f", notes="\u6839\u636edbId\u83b7\u53d6\u6570\u636e\u6e90\u4fe1\u606f")
    @AuditLog(moduleName="\u6570\u636e\u6e90\u7ba1\u7406", eventDesc="\u6839\u636edbId\u83b7\u53d6\u6570\u636e\u6e90\u4fe1\u606f", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<SysDataSource> detail(@ApiParam(value="\u6570\u636e\u6e90id") @RequestParam(value="dbId") String dbId) {
        return this.sysDataSourceService.getDatasourceById(dbId);
    }

    @ApiOperation(value="\u67e5\u8be2\u6570\u636e\u6e90\u5206\u9875\u5217\u8868", notes="\u67e5\u8be2\u6570\u636e\u6e90\u5206\u9875\u5217\u8868")
    @CheckPermission(value={"datasource:getList"})
    @GetMapping(value={"/getList"})
    @AuditLog(moduleName="\u6570\u636e\u6e90\u7ba1\u7406", eventDesc="\u67e5\u8be2\u6570\u636e\u6e90\u5206\u9875\u5217\u8868", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    @ApiOperationSupport(ignoreParameters={"records", "orders", "total", "optimizeCountSql", "searchCount", "optimizeJoinOfCountSql", "countId", "maxLimit", "pages"})
    public ApiResponse<IPage<SysDataSource>> querylist(@ApiParam(value="\u5206\u9875\u4fe1\u606f") Page<SysDataSource> page, @ApiParam(value="\u6570\u636e\u6e90\u5b9e\u4f53") SysDataSource sysDataSource) {
        return ApiResponse.success((Object)this.sysDataSourceService.listDataSource(page, sysDataSource));
    }

    @ApiOperation(value="\u65b0\u589e\u6570\u636e\u6e90(\u5224\u65ad\u6570\u636e\u5e93\u662f\u5426\u5b58\u5728\uff09", notes="\u65b0\u589e\u6570\u636e\u6e90(\u5224\u65ad\u6570\u636e\u5e93\u662f\u5426\u5b58\u5728\uff09")
    @CheckPermission(value={"datasource:checkDataSource"})
    @GetMapping(value={"/checkDataSource"})
    @AuditLog(moduleName="\u6570\u636e\u6e90\u7ba1\u7406", eventDesc="\u65b0\u589e\u6570\u636e\u6e90(\u5224\u65ad\u6570\u636e\u5e93\u662f\u5426\u5b58\u5728\uff09", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.INSERT)
    public ApiResponse<SysDataSource> checkDataSource(@ApiParam(value="\u6570\u636e\u6e90\u4fdd\u5b58\u4fee\u6539dto") SysDataSourceDto sysDataSource) {
        return this.sysDataSourceService.saveDataSourceWithCheck(sysDataSource, false);
    }

    @ApiOperation(value="\u4fee\u6539\u6570\u636e\u6e90\u4fe1\u606f", notes="\u4fee\u6539\u6570\u636e\u6e90\u4fe1\u606f")
    @CheckPermission(value={"datasource:edit"})
    @PostMapping(value={"/edit"})
    @AuditLog(moduleName="\u6570\u636e\u6e90\u7ba1\u7406", eventDesc="\u4fee\u6539\u6570\u636e\u6e90\u4fe1\u606f", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.UPDATE)
    public ApiResponse<SysDataSource> edit(@ApiParam(value="\u6570\u636e\u6e90\u5b9e\u4f53") @RequestBody SysDataSource sysDatasource) {
        return this.sysDataSourceService.updateDatasource(sysDatasource);
    }

    @ApiOperation(value="\u83b7\u53d6\u5f53\u524d\u79df\u6237\u6743\u9650", notes="\u83b7\u53d6\u5f53\u524d\u79df\u6237\u6743\u9650")
    @GetMapping(value={"/getTenantPermission"})
    @AuditLog(moduleName="\u6570\u636e\u6e90\u7ba1\u7406", eventDesc="\u83b7\u53d6\u5f53\u524d\u79df\u6237\u6743\u9650", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<TenantPermissonDto> getTenantPermission() {
        return this.sysDataSourceService.getTenantPermission();
    }

    @ApiOperation(value="\u68c0\u67e5\u6570\u636e\u6e90", notes="\u68c0\u67e5\u6570\u636e\u6e90")
    @CheckPermission(value={"datasource:checkDataSource"})
    @GetMapping(value={"/checkSource"})
    @AuditLog(moduleName="\u6570\u636e\u6e90\u7ba1\u7406", eventDesc="\u68c0\u67e5\u6570\u636e\u6e90", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<SysDataSource> checkSource(@ApiParam(value="\u6570\u636e\u6e90\u4fdd\u5b58\u4fee\u6539dto") SysDataSourceDto sysDataSource) {
        return this.sysDataSourceService.saveDataSourceWithCheck(sysDataSource, true);
    }

    @ApiOperation(value="\u67e5\u8be2\u5916\u90e8\u6570\u636e\u6e90\u540d\u79f0\u5217\u8868", notes="\u67e5\u8be2\u5916\u90e8\u6570\u636e\u6e90\u540d\u79f0\u5217\u8868")
    @GetMapping(value={"/queryDBNameListUncorrelated"})
    @AuditLog(moduleName="\u67e5\u8be2\u5916\u90e8\u6570\u636e\u6e90\u540d\u79f0\u5217\u8868", eventDesc="\u67e5\u8be2\u5916\u90e8\u6570\u636e\u6e90\u540d\u79f0\u5217\u8868", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    @ApiOperationSupport(ignoreParameters={"records", "orders", "total", "optimizeCountSql", "searchCount", "optimizeJoinOfCountSql", "countId", "maxLimit", "pages"})
    public ApiResponse<Object> queryDBNameListUncorrelated() {
        Page page = new Page();
        page.setSize(200L);
        SysDataSource sysDataSource = new SysDataSource();
        sysDataSource.setDatasourceType("2");
        HussarTenantDefinition hussarTenant = HussarContextHolder.getHussarTenant();
        if (HussarUtils.isEmpty((Object)hussarTenant)) {
            throw new BaseException("\u83b7\u53d6\u79df\u6237\u4fe1\u606f\u5931\u8d25\uff01");
        }
        sysDataSource.setTenantCode(hussarTenant.getTenantCode());
        List dataSourceList = this.datasourceService.listDataSource(page, sysDataSource).getRecords();
        if (HussarUtils.isNotEmpty((Object)dataSourceList)) {
            List list = dataSourceList.stream().map(e -> {
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("key", e.getConnName());
                map.put("value", e.getDbName());
                return map;
            }).collect(Collectors.toList());
            return ApiResponse.success(list);
        }
        return ApiResponse.success();
    }

    @ApiOperation(value="\u5206\u9875\u67e5\u8be2", notes="\u5206\u9875\u67e5\u8be2")
    @GetMapping(value={"/listPage"})
    public ApiResponse<IPage<SysDataSource>> listPage(SysDataSource sysDataSource, Page<SysDataSource> page, HttpServletRequest req) {
        SingleTableQueryGenerator singleTableQueryGenerator = new SingleTableQueryGenerator();
        QueryWrapper queryWrapper = singleTableQueryGenerator.initQueryWrapper((Object)sysDataSource, req.getParameterMap());
        Page pageList = this.sysDataSourceService.getList(page, queryWrapper);
        return ApiResponse.success((Object)pageList);
    }

    @GetMapping(value={"/getMasterDbType"})
    @ApiOperation(value="\u83b7\u53d6\u4e3b\u6570\u636e\u5e93\u7c7b\u578b", notes="\u83b7\u53d6\u4e3b\u6570\u636e\u5e93\u7c7b\u578b")
    @AuditLog(moduleName="\u5916\u90e8\u6570\u636e\u6e90", eventDesc="\u83b7\u53d6\u4e3b\u6570\u636e\u5e93\u7c7b\u578b", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<String> getMasterDbType() {
        SysDataSource masterDataSource = this.sysDataSourceService.getMasterDataSource();
        AssertUtil.isNotNull((Object)masterDataSource, (String)"\u67e5\u8be2\u4e0d\u5230\u4e3b\u6570\u636e\u6e90\u4fe1\u606f");
        String dbType = DbUtil.getDbType((String)masterDataSource.getJdbcUrl());
        return ApiResponse.success((String)dbType);
    }
}

