/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.datasource.service.impl;

import com.baomidou.mybatisplus.annotation.DbType;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.datasource.dto.SysDataSourceDto;
import com.jxdinfo.hussar.datasource.factory.DatabaseFactory;
import com.jxdinfo.hussar.datasource.service.IHussarBaseDatabaseOperateService;
import com.jxdinfo.hussar.datasource.service.impl.AbstractDatabaseOperateService;
import com.jxdinfo.hussar.datasource.util.HussarTenantScriptUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarDs;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.io.Resource;
import org.springframework.jdbc.datasource.init.ScriptException;
import org.springframework.stereotype.Service;

@Service(value="com.jxdinfo.hussar.datasource.service.impl.oracleDatabaseOperateServiceImpl")
public class OracleDatabaseOperateServiceImpl
extends AbstractDatabaseOperateService
implements InitializingBean {
    public static final Pattern DECLARE_TABLE_PATTERN = Pattern.compile("\\bDECLARE\\s+", 8);
    public static final Pattern BEGIN_SELECT_TABLE_PATTERN = Pattern.compile("\\bBEGIN\\s+SELECT(.*)FROM\\b", 32);
    public static final Pattern IF_THEN_TABLE_PATTERN = Pattern.compile("\\bIF(.*)THEN\\b", 32);
    public static final Pattern DECLARE_END_IF_PATTERN = Pattern.compile("\\bEND\\s+IF\\b", 8);
    private static Pattern DROP_TABLE_PATTERN = Pattern.compile("\\bDROP\\s+TABLE\\b", 32);

    @HussarDs(value="master")
    public SysDataSourceDto createSchema(SysDataSourceDto sysDataSourceDto) throws BaseException, IOException, SQLException {
        String sql = "BEGIN EXECUTE IMMEDIATE 'CREATE USER " + sysDataSourceDto.getDbName() + " IDENTIFIED BY \"" + sysDataSourceDto.getPassword() + "\"';EXECUTE IMMEDIATE 'GRANT CREATE VIEW,CONNECT,RESOURCE TO " + sysDataSourceDto.getDbName() + "'; EXECUTE IMMEDIATE 'ALTER USER " + sysDataSourceDto.getDbName() + " QUOTA UNLIMITED ON USERS';END;";
        this.execute(sql);
        return sysDataSourceDto;
    }

    public Resource[] getInitExecuteSQLScripts() throws IOException {
        Resource[] resources = SpringContextHolder.getApplicationContext().getResources("classpath*:tenantsql/init/oracle/*.sql");
        return resources;
    }

    public Resource[] getUpgradeExecuteSQLScripts() throws IOException {
        Resource[] resources = SpringContextHolder.getApplicationContext().getResources("classpath*:tenantsql/upgrade/oracle/*.sql");
        return resources;
    }

    public void setParametersByMaster(SysDataSourceDto sysDataSourceDto) {
        sysDataSourceDto.setUserName(sysDataSourceDto.getDbName());
    }

    public void afterPropertiesSet() throws Exception {
        DatabaseFactory.add((String)DbType.ORACLE.getDb(), (IHussarBaseDatabaseOperateService)this);
    }

    public List<String> preTreatment(Connection connection, Resource resource, boolean drop) throws IOException, ScriptException {
        InputStream inputStream = resource.getInputStream();
        List statements = HussarTenantScriptUtils.getSplitSqlScript((InputStream)inputStream);
        ArrayList<String> result = new ArrayList<String>();
        for (String statement : statements) {
            if (!StringUtils.isNotBlank((CharSequence)statement)) continue;
            this.matchRemoveSql(drop, result, statement);
        }
        return result;
    }

    private void matchRemoveSql(boolean drop, List<String> result, String statement) {
        String temp = statement.trim().toUpperCase();
        if (DECLARE_TABLE_PATTERN.matcher(temp).find()) {
            return;
        }
        if (BEGIN_SELECT_TABLE_PATTERN.matcher(temp).find()) {
            return;
        }
        if (IF_THEN_TABLE_PATTERN.matcher(temp).find()) {
            return;
        }
        if (DECLARE_END_IF_PATTERN.matcher(temp).find()) {
            return;
        }
        if ("END".equals(temp)) {
            return;
        }
        if (temp.startsWith("/")) {
            result.add(statement.substring(statement.indexOf("/") + 1));
        } else if (DROP_TABLE_PATTERN.matcher(temp).find()) {
            if (drop) {
                result.add(statement);
            }
        } else {
            result.add(statement);
        }
    }
}

