/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.datasource.runner;

import com.baomidou.dynamic.datasource.ds.ItemDataSource;
import com.baomidou.dynamic.datasource.hussar.extend.AbstractHussarDataSource;
import com.jxdinfo.hussar.common.datasource.service.impl.DynamicDataSourceServiceImpl;
import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.datasource.model.SysDataSource;
import com.jxdinfo.hussar.datasource.service.SysDataSourceService;
import javax.annotation.Resource;
import javax.sql.DataSource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.boot.ApplicationArguments;
import org.springframework.boot.ApplicationRunner;
import org.springframework.core.annotation.Order;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Component;

@Component
@Order(value=1)
public class DataSourceRunner
implements ApplicationRunner {
    @Resource
    private SysDataSourceService sysDataSourceService;
    @Resource
    private DynamicDataSourceServiceImpl dynamicDataSourceService;
    private static final Long MASTER_DS = 1450384273189240833L;
    private static final String MASTER_DS_NAME = "master";
    private static final String DATASOURCE_TYPE_TENANT = "1";
    private static final String MASTER_DS_REMARK = "\u9ed8\u8ba4\u6570\u636e\u8fde\u63a5";

    public void run(ApplicationArguments args) {
        this.saveOrUpdateMasterDs();
    }

    private void saveOrUpdateMasterDs() {
        SysDataSource dataSource = new SysDataSource();
        dataSource.setId(MASTER_DS);
        dataSource.setDbName(MASTER_DS_NAME);
        dataSource.setConnName(MASTER_DS_NAME);
        DataSource ds = this.dynamicDataSourceService.getDataSource(MASTER_DS_NAME);
        if (ds instanceof AbstractHussarDataSource) {
            AbstractHussarDataSource itemDataSource = (AbstractHussarDataSource)ds;
            dataSource.setJdbcUrl(itemDataSource.getUrl());
            String dbMode = ((Environment)SpringContextHolder.getBean(Environment.class)).getProperty("spring.datasource.dynamic.datasource.master.db-mode");
            if (dataSource.getJdbcUrl().contains("kingbase") && StringUtils.isBlank((CharSequence)dbMode)) {
                dbMode = "kingbase_oracle";
            }
            dataSource.setDbMode(dbMode);
            dataSource.setUserName(itemDataSource.getUsername());
            dataSource.setPassword(itemDataSource.getPassword());
            dataSource.setDriverClass(itemDataSource.getDriverClassName());
            dataSource.setCurrentSchema(((ItemDataSource)itemDataSource).getSchemaName());
        }
        dataSource.setDatasourceType(DATASOURCE_TYPE_TENANT);
        dataSource.setTenantCode("0");
        dataSource.setInstantName(this.getMasterInstantName(dataSource));
        dataSource.setRemark(MASTER_DS_REMARK);
        this.sysDataSourceService.saveOrUpdate((Object)dataSource);
    }

    private String getMasterInstantName(SysDataSource dataSource) {
        String instantName = null;
        String jdbcUrl = dataSource.getJdbcUrl();
        if (jdbcUrl.startsWith("jdbc:mysql")) {
            instantName = this.getMysqlInstantName(jdbcUrl);
        }
        return instantName;
    }

    private String getMysqlInstantName(String jdbcUrl) {
        String str = jdbcUrl.substring(jdbcUrl.indexOf("/") + 2, jdbcUrl.indexOf("?"));
        return str.substring(str.indexOf("/") + 1);
    }
}

