/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.datasource.service.feign.impl;

import com.baomidou.dynamic.datasource.DynamicRoutingDataSource;
import com.baomidou.dynamic.datasource.hussar.extend.AbstractHussarDataSource;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.datasource.dto.SysDataSourceDto;
import com.jxdinfo.hussar.datasource.dto.SysDataSourceFeignDto;
import com.jxdinfo.hussar.datasource.dto.TenantPermissonDto;
import com.jxdinfo.hussar.datasource.feign.RemoteSysDataSourceService;
import com.jxdinfo.hussar.datasource.model.SysDataSource;
import com.jxdinfo.hussar.datasource.service.SysDataSourceService;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.support.datasource.annotations.HussarDs;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.sql.DataSource;
import org.springframework.stereotype.Service;

@HussarDs(value="master")
@Service
public class RemoteDataSourceServiceImpl
implements SysDataSourceService {
    @Resource
    RemoteSysDataSourceService sysDataSourceService;
    @Resource
    private DataSource dataSource;
    private static final Long MASTER_DS = 1450384273189240833L;

    public List<SysDataSource> list() {
        return this.sysDataSourceService.list();
    }

    public SysDataSource getByTenantCode(String tenantCode) {
        return this.sysDataSourceService.getByTenantCode(tenantCode);
    }

    public ApiResponse<SysDataSource> getDatasourceById(String dbId) {
        return this.sysDataSourceService.getDatasourceById(dbId);
    }

    public SysDataSource getByConnName(String connName) {
        return this.sysDataSourceService.getByConnName(connName);
    }

    public ApiResponse<SysDataSource> saveDataSourceWithCheck(SysDataSourceDto sysDataSource, boolean isCheck) {
        SysDataSourceFeignDto sysDataSourceFeignDto = new SysDataSourceFeignDto();
        sysDataSourceFeignDto.setSysDataSourceDto(sysDataSource);
        sysDataSourceFeignDto.setCheck(Boolean.valueOf(isCheck));
        return this.sysDataSourceService.saveDataSourceWithCheck(sysDataSourceFeignDto);
    }

    public ApiResponse<SysDataSource> deleteDataSourceByLongIds(List<Long> ids) {
        return this.sysDataSourceService.deleteDataSource(ids);
    }

    public ApiResponse<SysDataSource> deleteDataSource(List<String> ids) {
        List<Long> cdids = ids.stream().map(s -> Long.parseLong(s.trim())).collect(Collectors.toList());
        return this.deleteDataSourceByLongIds(cdids);
    }

    public ApiResponse<SysDataSource> updateDatasource(SysDataSource sysDataSource) {
        return this.sysDataSourceService.updateDatasource(sysDataSource);
    }

    public IPage<SysDataSource> listDataSource(Page<SysDataSource> page, SysDataSource sysDataSource) {
        return null;
    }

    public IPage<SysDataSource> getListUncorrelated(Page<SysDataSource> page) {
        return null;
    }

    public ApiResponse<SysDataSource> saveDatasource(SysDataSourceDto sysDataSource) {
        return null;
    }

    public Boolean checkTableExist(SysDataSource sysDataSource) {
        return null;
    }

    public ApiResponse<SysDataSource> checkDbName(String dbName) {
        return null;
    }

    public ApiResponse<?> isMysql(String username, String password, String driverClassName, String url, String code) {
        return null;
    }

    public ApiResponse<?> isOscar(String driverClassName, String url, String code) {
        return null;
    }

    public ApiResponse<?> isOracle(String driverClassName, String url, String code) {
        return null;
    }

    public ApiResponse<?> isDm(String driverClassName, String url, String code) {
        return null;
    }

    public ApiResponse<?> isPostgresql(String username, String password, String driverClassName, String url, String code) {
        return null;
    }

    public ApiResponse execSqlFile(String dbId, String isBpmType, String tenantId) {
        return null;
    }

    public ApiResponse<Boolean> checkConnName(String connName) {
        return null;
    }

    public void addDataSourceByConnName(String connName) {
    }

    public ApiResponse<String> tryConnection(SysDataSourceDto sysDataSourceDto) {
        return null;
    }

    public String getIP() {
        return null;
    }

    public ApiResponse<TenantPermissonDto> getTenantPermission() {
        return null;
    }

    public List<SysDataSource> getAllTenantDataSource() {
        return null;
    }

    public List<SysDataSource> getAllDataSource() {
        return null;
    }

    public boolean saveIgnore(SysDataSource sysDataSource) {
        return false;
    }

    public boolean saveReplace(SysDataSource sysDataSource) {
        return false;
    }

    public boolean saveIgnoreBatch(Collection<SysDataSource> collection, int i) {
        return false;
    }

    public boolean saveReplaceBatch(Collection<SysDataSource> collection, int i) {
        return false;
    }

    public boolean saveBatchNoTransaction(Collection<SysDataSource> collection, int i) {
        return false;
    }

    public boolean saveBatch(Collection<SysDataSource> entityList, int batchSize) {
        return false;
    }

    public boolean saveOrUpdateBatch(Collection<SysDataSource> entityList, int batchSize) {
        return false;
    }

    public boolean updateBatchById(Collection<SysDataSource> entityList, int batchSize) {
        return false;
    }

    public boolean saveOrUpdate(SysDataSource entity) {
        return false;
    }

    public SysDataSource getOne(Wrapper<SysDataSource> queryWrapper, boolean throwEx) {
        return null;
    }

    public Map<String, Object> getMap(Wrapper<SysDataSource> queryWrapper) {
        return null;
    }

    public <V> V getObj(Wrapper<SysDataSource> queryWrapper, Function<? super Object, V> mapper) {
        return null;
    }

    public BaseMapper<SysDataSource> getBaseMapper() {
        return null;
    }

    public Class<SysDataSource> getEntityClass() {
        return null;
    }

    public SysDataSource getMasterDataSource() {
        DynamicRoutingDataSource ds = (DynamicRoutingDataSource)this.dataSource;
        DataSource dataSource = ds.getDataSource("master");
        SysDataSource sysDataSource = new SysDataSource();
        if (dataSource instanceof AbstractHussarDataSource) {
            AbstractHussarDataSource itemDataSource = (AbstractHussarDataSource)dataSource;
            sysDataSource.setId(MASTER_DS);
            sysDataSource.setConnName(itemDataSource.getPoolName());
            sysDataSource.setDbName(itemDataSource.getPoolName());
            sysDataSource.setJdbcUrl(itemDataSource.getUrl());
            sysDataSource.setUserName(itemDataSource.getUsername());
            sysDataSource.setPassword(itemDataSource.getPassword());
            sysDataSource.setDriverClass(itemDataSource.getDriverClassName());
            sysDataSource.setInstantName(this.getMasterInstantName(sysDataSource));
            sysDataSource.setRemark("\u9ed8\u8ba4\u6570\u636e\u8fde\u63a5");
            sysDataSource.setDelFlag("0");
        }
        return sysDataSource;
    }

    private String getMasterInstantName(SysDataSource dataSource) {
        String instantName = null;
        String jdbcUrl = dataSource.getJdbcUrl();
        if (jdbcUrl.startsWith("jdbc:mysql")) {
            instantName = this.getMysqlInstantName(jdbcUrl);
        } else if (jdbcUrl.startsWith("jdbc:oracle")) {
            instantName = dataSource.getUserName();
        }
        return instantName;
    }

    private String getMysqlInstantName(String jdbcUrl) {
        String str = jdbcUrl.substring(jdbcUrl.indexOf("/") + 2, jdbcUrl.indexOf("?"));
        return str.substring(str.indexOf("/") + 1);
    }

    public List<SysDataSource> list(Boolean onlyMaster) {
        if (onlyMaster.booleanValue()) {
            ArrayList<SysDataSource> list = new ArrayList<SysDataSource>();
            list.add(this.getMasterDataSource());
            return list;
        }
        return this.list();
    }

    public ApiResponse<SysDataSource> getDatasourceById(String dbId, Boolean onlyMaster) {
        if (onlyMaster.booleanValue()) {
            return ApiResponse.success((Object)this.getMasterDataSource());
        }
        return this.getDatasourceById(dbId);
    }

    public SysDataSource getByTenantCode(String tenantCode, Boolean onlyMaster) {
        if (onlyMaster.booleanValue()) {
            return this.getMasterDataSource();
        }
        return this.getByTenantCode(tenantCode);
    }

    public SysDataSource getByConnName(String connName, Boolean onlyMaster) {
        if (onlyMaster.booleanValue()) {
            return this.getMasterDataSource();
        }
        return this.getByConnName(connName);
    }
}

