/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.dataset.strategy.dataset;

import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.dataset.dto.DataSetConfigInfoDto;
import com.jxdinfo.hussar.dataset.dto.DataSetInfoDto;
import com.jxdinfo.hussar.dataset.dto.SqlDataSetDto;
import com.jxdinfo.hussar.dataset.model.SqlConfigSchema1;
import com.jxdinfo.hussar.dataset.model.SqlField1;
import com.jxdinfo.hussar.dataset.service.IDataSetProcessor;
import com.jxdinfo.hussar.dataset.strategy.dataset.DataSetCommonProcessor;
import com.jxdinfo.hussar.dataset.util.DataSetParamUtil;
import com.jxdinfo.hussar.dataset.vo.SqlDataSetVo;
import com.jxdinfo.hussar.datasource.model.DsTableInfo;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.engine.api.dto.ModelSaveDto;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SqlDataSetProcessor
extends DataSetCommonProcessor
implements IDataSetProcessor {
    private static final Logger log = LoggerFactory.getLogger(SqlDataSetProcessor.class);

    public Long save(DataSetInfoDto dataSetInfoDto) {
        DataSetInfoDto newDataSetInfoDto = super.copyNewDataSetInfoDto(dataSetInfoDto);
        ModelSaveDto modelSaveDto = this.getModelSaveDto(newDataSetInfoDto);
        this.insertModelToDb(modelSaveDto);
        return this.insertDbSetToDb(newDataSetInfoDto);
    }

    @Override
    public SqlDataSetVo preivewDataBySql(SqlDataSetDto sqlDataSetDto) {
        return super.preivewDataBySql(sqlDataSetDto);
    }

    @Override
    public void editModel(DataSetInfoDto dataSetInfoDto) {
        super.editModel(dataSetInfoDto);
    }

    private String processSqlProject(String oldData, String newData) {
        String data = newData;
        DataSetConfigInfoDto oldDataSetConfigInfoDto = (DataSetConfigInfoDto)JSONObject.parseObject((String)oldData, DataSetConfigInfoDto.class);
        DataSetConfigInfoDto newDataSetConfigInfoDto = (DataSetConfigInfoDto)JSONObject.parseObject((String)newData, DataSetConfigInfoDto.class);
        if (HussarUtils.isNotEmpty((Object)oldDataSetConfigInfoDto.getDataSetParam()) && HussarUtils.isNotEmpty((Object)newDataSetConfigInfoDto.getDataSetParam())) {
            SqlConfigSchema1 oldSqlSchema = oldDataSetConfigInfoDto.getDataSetParam();
            SqlConfigSchema1 newSqlSchema = newDataSetConfigInfoDto.getDataSetParam();
            if (!HussarUtils.equals((Object)oldSqlSchema.getSql(), (Object)newSqlSchema.getSql())) {
                Map<Object, Object> map = new HashMap();
                if (HussarUtils.isNotEmpty((Object)oldSqlSchema.getProjection())) {
                    map = oldSqlSchema.getProjection().stream().collect(Collectors.toMap(SqlField1::getField, obj -> obj));
                }
                SqlDataSetDto sqlDataSetDto = new SqlDataSetDto();
                sqlDataSetDto.setCustomSql(newSqlSchema.getSql());
                sqlDataSetDto.setDataSourceName(newDataSetConfigInfoDto.getDataSourceName());
                SqlDataSetVo sqlDataSetVo = this.preivewDataBySql(sqlDataSetDto);
                List newFields = sqlDataSetVo.getProjectionFields();
                if (HussarUtils.isNotEmpty((Object)newFields)) {
                    Map<Object, Object> finalMap = map;
                    ArrayList<SqlField1> fields = new ArrayList<SqlField1>();
                    for (SqlField1 field : newFields) {
                        if (finalMap.containsKey(field.getField())) {
                            SqlField1 sqlField = (SqlField1)finalMap.get(field.getField());
                            fields.add(sqlField);
                            continue;
                        }
                        fields.add(field);
                    }
                    newSqlSchema.setProjection(fields);
                    data = JSONObject.toJSONString((Object)newDataSetConfigInfoDto);
                }
            }
        }
        return data;
    }

    public void delete(DataSetInfoDto dataSetInfoDto) {
        super.deleteModel(dataSetInfoDto.getDataSetId().toString());
    }

    public SqlConfigSchema1 packageDataSetParam(DsTableInfo tableInfo, Long dataSourceId, String dataSourceName) {
        return DataSetParamUtil.packageDataSetParam(tableInfo, dataSourceId, dataSourceName);
    }
}

