/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.dataset.strategy.dataset;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.dataset.dto.DataSetConfigInfoDto;
import com.jxdinfo.hussar.dataset.dto.DataSetInfoDto;
import com.jxdinfo.hussar.dataset.dto.SqlDataSetDto;
import com.jxdinfo.hussar.dataset.enums.DataSetErrorCodeEnum;
import com.jxdinfo.hussar.dataset.factory.DbDataTypeStrategyFactory;
import com.jxdinfo.hussar.dataset.model.SqlConfigSchema1;
import com.jxdinfo.hussar.dataset.model.SqlField1;
import com.jxdinfo.hussar.dataset.model.SqlParameter1;
import com.jxdinfo.hussar.dataset.service.IDataSetService;
import com.jxdinfo.hussar.dataset.service.IDataTypeStrategy;
import com.jxdinfo.hussar.dataset.vo.SqlDataSetVo;
import com.jxdinfo.hussar.datasource.manager.api.entity.MetadataColumn;
import com.jxdinfo.hussar.datasource.manager.api.model.CustomSqlDto;
import com.jxdinfo.hussar.datasource.manager.api.service.HussarDdlService;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.SpringContextUtil;
import com.jxdinfo.hussar.support.engine.api.dto.ModelFieldDto;
import com.jxdinfo.hussar.support.engine.api.dto.ModelInfoDto;
import com.jxdinfo.hussar.support.engine.api.dto.ModelSaveDto;
import com.jxdinfo.hussar.support.engine.api.model.SQLModel;
import com.jxdinfo.hussar.support.engine.api.service.ModelSaveService;
import com.jxdinfo.hussar.support.engine.core.util.EngineUtil;
import com.jxdinfo.hussar.support.engine.plugin.model.service.SQLModelService;
import com.jxdinfo.hussar.support.exception.HussarException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.sf.jsqlparser.JSQLParserException;
import org.mybatis.spring.MyBatisSystemException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.BadSqlGrammarException;

public abstract class DataSetCommonProcessor {
    public static final String SQL_MODEL_TYPE = "sql";
    private static final Logger log = LoggerFactory.getLogger(DataSetCommonProcessor.class);

    protected DataSetInfoDto copyNewDataSetInfoDto(DataSetInfoDto wordDataSetInfoDto) {
        DataSetInfoDto newWordDataSetInfoDto = (DataSetInfoDto)HussarUtils.copyProperties((Object)wordDataSetInfoDto, DataSetInfoDto.class);
        if (HussarUtils.isEmpty((Object)newWordDataSetInfoDto.getDataSetId())) {
            newWordDataSetInfoDto.setDataSetId(EngineUtil.getId());
        }
        return newWordDataSetInfoDto;
    }

    protected DataSetConfigInfoDto getDataSetConfigInfoDto(DataSetInfoDto wordDataSetInfoDto) {
        DataSetConfigInfoDto dataSetConfigInfoDto = (DataSetConfigInfoDto)JSONObject.parseObject((String)wordDataSetInfoDto.getData(), DataSetConfigInfoDto.class);
        dataSetConfigInfoDto.setDataSetId(wordDataSetInfoDto.getDataSetId().toString());
        dataSetConfigInfoDto.setName(wordDataSetInfoDto.getDataSetCode());
        dataSetConfigInfoDto.setComment(wordDataSetInfoDto.getDataSetName());
        dataSetConfigInfoDto.setTableDesc(wordDataSetInfoDto.getDataSetDesc());
        return dataSetConfigInfoDto;
    }

    protected SqlDataSetVo preivewDataBySql(SqlDataSetDto sqlDataSetDto) {
        Object object = this.processSql(sqlDataSetDto);
        return this.processSqlData(object, sqlDataSetDto.isPagination(), sqlDataSetDto.getDataSourceName());
    }

    protected void editModel(DataSetInfoDto wordDataSetInfoDto) {
        String modelId = wordDataSetInfoDto.getDataSetId().toString();
        this.deleteModel(modelId);
        ModelSaveDto modelSaveDto = this.getModelSaveDto(wordDataSetInfoDto);
        this.insertModelToDb(modelSaveDto);
    }

    protected Object processSql(SqlDataSetDto sqlDataSetDto) {
        HussarDdlService hussarDdlService = (HussarDdlService)SpringContextUtil.getBean(HussarDdlService.class);
        CustomSqlDto customSqlDto = new CustomSqlDto();
        customSqlDto.setSql(sqlDataSetDto.getCustomSql());
        customSqlDto.setPollName(sqlDataSetDto.getDataSourceName());
        Page page = new Page();
        if (sqlDataSetDto.isPagination()) {
            page.setSize((long)sqlDataSetDto.getSize().intValue());
            page.setCurrent((long)sqlDataSetDto.getCurrent().intValue());
        } else {
            page.setSize(20L);
            page.setCurrent(1L);
        }
        page.setOptimizeJoinOfCountSql(false);
        customSqlDto.setPage(page);
        if (HussarUtils.isNotEmpty((Object)sqlDataSetDto.getParameterValues())) {
            Map<String, Object> params = sqlDataSetDto.getParameterValues().stream().collect(Collectors.toMap(SqlParameter1::getCode, SqlParameter1::getValue));
            customSqlDto.setParams(params);
        }
        customSqlDto.setParseSql(true);
        Object object = null;
        try {
            object = hussarDdlService.customSql(customSqlDto);
        }
        catch (BadSqlGrammarException badE) {
            throw new HussarException(Integer.valueOf(DataSetErrorCodeEnum.DATASET_SQL_GRAMMAR_ERROR.getCode()), DataSetErrorCodeEnum.DATASET_SQL_GRAMMAR_ERROR.getMessage(), (Throwable)badE);
        }
        catch (MyBatisSystemException myBatisE) {
            throw new HussarException(Integer.valueOf(DataSetErrorCodeEnum.DATASET_MYBATIS_EXCEPTION.getCode()), DataSetErrorCodeEnum.DATASET_MYBATIS_EXCEPTION.getMessage(), (Throwable)myBatisE);
        }
        catch (HussarException e) {
            if (e.getCause() != null && e.getCause() instanceof JSQLParserException) {
                throw new HussarException(Integer.valueOf(DataSetErrorCodeEnum.DATASET_SQL_PARSER_EXCEPTION.getCode()), DataSetErrorCodeEnum.DATASET_SQL_PARSER_EXCEPTION.getMessage(), (Throwable)e);
            }
            throw new HussarException(Integer.valueOf(DataSetErrorCodeEnum.DATASET_OTHER_EXCEPTION.getCode()), DataSetErrorCodeEnum.DATASET_OTHER_EXCEPTION.getMessage(), (Throwable)e);
        }
        catch (Exception e) {
            throw new HussarException(Integer.valueOf(DataSetErrorCodeEnum.DATASET_OTHER_EXCEPTION.getCode()), DataSetErrorCodeEnum.DATASET_OTHER_EXCEPTION.getMessage(), (Throwable)e);
        }
        return object;
    }

    protected SqlDataSetVo processSqlData(Object result, boolean isPagination, String datasourceName) {
        SqlDataSetVo sqlDataSetVo = new SqlDataSetVo();
        Map resultMap = (Map)result;
        JSONObject jsonObject = new JSONObject(resultMap);
        Page pageResult = (Page)jsonObject.get((Object)"data");
        sqlDataSetVo.setTotal(Long.valueOf(pageResult == null ? 0L : pageResult.getTotal()));
        sqlDataSetVo.setQueryResult(pageResult == null ? new ArrayList() : pageResult.getRecords());
        List metadataColumns = (List)jsonObject.get((Object)"columnList");
        sqlDataSetVo.setProjectionFields(this.metadataToSqlField(metadataColumns, datasourceName));
        return sqlDataSetVo;
    }

    protected List<SqlField1> metadataToSqlField(List<MetadataColumn> metadataColumns, String datasourceName) {
        ArrayList<SqlField1> projectionFields = new ArrayList<SqlField1>();
        for (MetadataColumn metadataColumn : metadataColumns) {
            SqlField1 projectionField = new SqlField1();
            projectionField.setField(HussarUtils.isNotEmpty((Object)metadataColumn.getColumnAlias()) ? metadataColumn.getColumnAlias() : metadataColumn.getColumnName());
            projectionField.setFieldAlias(metadataColumn.getColumnName());
            projectionField.setTable(metadataColumn.getTableName());
            projectionField.setComment(metadataColumn.getColumnComment());
            projectionField.setDataDot(metadataColumn.getDataDot().intValue());
            projectionField.setType(metadataColumn.getJdbcType());
            String jdbcType = metadataColumn.getJdbcType();
            IDataTypeStrategy IDataTypeStrategy2 = DbDataTypeStrategyFactory.getStrategy(datasourceName);
            projectionField.setDataType(IDataTypeStrategy2.convertJdbcToFrontType(jdbcType).toLowerCase());
            projectionField.setDataTypeConversion(IDataTypeStrategy2.convertJdbcToFrontType(jdbcType).toLowerCase());
            projectionField.setRename(metadataColumn.getColumnAlias());
            projectionFields.add(projectionField);
        }
        return projectionFields;
    }

    protected ModelSaveDto getModelSaveDto(DataSetInfoDto wordDataSetInfoDto) {
        DataSetConfigInfoDto dataSetConfigInfoDto = (DataSetConfigInfoDto)JSONObject.parseObject((String)wordDataSetInfoDto.getData(), DataSetConfigInfoDto.class);
        ModelSaveDto modelSaveDto = new ModelSaveDto();
        ArrayList<ModelInfoDto> saveModelList = new ArrayList<ModelInfoDto>();
        ModelInfoDto modelInfoDto = dataSetConfigInfoDto.dataSetConfigToSqlModel();
        modelInfoDto.setModelId(wordDataSetInfoDto.getDataSetId().toString());
        modelInfoDto.setType(SQL_MODEL_TYPE);
        SqlConfigSchema1 dataSetParamDto = dataSetConfigInfoDto.getDataSetParam();
        if (HussarUtils.isNotEmpty((Object)dataSetParamDto)) {
            modelInfoDto.setCustomSql(dataSetParamDto.getSql());
            List<ModelFieldDto> modelFieldDtos = this.getModelFieldByDataSetParamDto(dataSetParamDto, wordDataSetInfoDto.getDataSourceName());
            modelInfoDto.setFieldList(modelFieldDtos);
        }
        saveModelList.add(modelInfoDto);
        modelSaveDto.setSaveModelList(saveModelList);
        return modelSaveDto;
    }

    protected List<ModelFieldDto> getModelFieldByDataSetParamDto(SqlConfigSchema1 dataSetParamDto, String dataSourceName) {
        List dataSetColumnDtos = dataSetParamDto.getProjection();
        HussarException.throwBy((boolean)HussarUtils.isEmpty((Object)dataSetColumnDtos), (Integer)DataSetErrorCodeEnum.DATASET_FIELD_NOT_EXISTS.getCode(), (String)"\u6570\u636e\u96c6\u5b57\u6bb5\u4fe1\u606f\u4e0d\u5b58\u5728\uff01");
        try {
            return dataSetColumnDtos.stream().map(dataSetColumnDto -> {
                ModelFieldDto modelFieldDto = new ModelFieldDto();
                modelFieldDto.setFieldName(dataSetColumnDto.getField());
                modelFieldDto.setFieldId(dataSetColumnDto.getField());
                modelFieldDto.setDataType(dataSetColumnDto.getDataType());
                modelFieldDto.setFieldComment(dataSetColumnDto.getComment());
                modelFieldDto.setFieldAlias(HussarUtils.isEmpty((Object)dataSetColumnDto.getFieldAlias()) ? dataSetColumnDto.getField() : dataSetColumnDto.getFieldAlias());
                IDataTypeStrategy IDataTypeStrategy2 = DbDataTypeStrategyFactory.getStrategy(dataSourceName);
                String dataType = dataSetColumnDto.getDataType();
                modelFieldDto.setJdbcType(IDataTypeStrategy2.convertFrontToJdbcType(dataType));
                modelFieldDto.setJavaType(IDataTypeStrategy2.convertFrontToJavaType(dataType));
                modelFieldDto.setNeedChangeIsRequired(Boolean.FALSE.booleanValue());
                modelFieldDto.setSyncToTable(Boolean.FALSE.booleanValue());
                return modelFieldDto;
            }).collect(Collectors.toList());
        }
        catch (Exception e) {
            throw new HussarException(Integer.valueOf(DataSetErrorCodeEnum.DATASET_FIELD_TOMODEL_EXCEPTION.getCode()), DataSetErrorCodeEnum.DATASET_FIELD_TOMODEL_EXCEPTION.getMessage(), (Throwable)e);
        }
    }

    protected void insertModelToDb(ModelSaveDto modelSaveDto) {
        try {
            ModelSaveService modelSaveService = (ModelSaveService)SpringContextHolder.getBean(ModelSaveService.class);
            if (HussarUtils.isEmpty((Object)modelSaveDto.getSaveModelList()) || HussarUtils.isEmpty((Object)((ModelInfoDto)modelSaveDto.getSaveModelList().get(0)).getFieldList())) {
                return;
            }
            modelSaveService.saveModel(modelSaveDto);
        }
        catch (Exception e) {
            throw new HussarException(Integer.valueOf(DataSetErrorCodeEnum.DATASET_SQLMODEL_SAVE_EXCEPTION.getCode()), DataSetErrorCodeEnum.DATASET_SQLMODEL_SAVE_EXCEPTION.getMessage(), (Throwable)e);
        }
    }

    protected Long insertDbSetToDb(DataSetInfoDto wordDataSetInfoDto) {
        try {
            IDataSetService wordDataSetService = (IDataSetService)SpringContextHolder.getBean(IDataSetService.class);
            Long groupId = HussarUtils.isNotEmpty((Object)wordDataSetInfoDto.getGroupId()) ? wordDataSetInfoDto.getGroupId() : 1L;
            Integer seq = wordDataSetService.getSeqByGroupId(groupId);
            wordDataSetInfoDto.setSeq(Integer.valueOf(seq + 1));
            wordDataSetInfoDto.setGroupId(groupId);
            wordDataSetService.save((Object)wordDataSetInfoDto);
            return wordDataSetInfoDto.getDataSetId();
        }
        catch (Exception e) {
            throw new HussarException(Integer.valueOf(DataSetErrorCodeEnum.DATASET_SAVE_EXCEPTION.getCode()), DataSetErrorCodeEnum.DATASET_SAVE_EXCEPTION.getMessage(), (Throwable)e);
        }
    }

    protected void deleteModel(String dataSetId) {
        try {
            SQLModelService sqlModelService = (SQLModelService)SpringContextHolder.getBean(SQLModelService.class);
            SQLModel sqlModel = sqlModelService.getModelByTfId(dataSetId);
            if (HussarUtils.isNotEmpty((Object)sqlModel)) {
                sqlModelService.removeById((Serializable)sqlModel.getSQLModelId());
            }
        }
        catch (Exception e) {
            throw new HussarException(Integer.valueOf(DataSetErrorCodeEnum.DATASET_SQLMODEL_EXCEPTION.getCode()), DataSetErrorCodeEnum.DATASET_SQLMODEL_EXCEPTION.getMessage(), (Throwable)e);
        }
    }
}

