/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.dataset.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.dataset.dao.WordDataSetGroupMapper;
import com.jxdinfo.hussar.dataset.dao.WordDataSetMapper;
import com.jxdinfo.hussar.dataset.dto.DataSetColumnNameDto;
import com.jxdinfo.hussar.dataset.dto.DataSetConfigInfoDto;
import com.jxdinfo.hussar.dataset.dto.DataSetFileDto;
import com.jxdinfo.hussar.dataset.dto.DataSetGroupDto;
import com.jxdinfo.hussar.dataset.dto.DataSetInfoDto;
import com.jxdinfo.hussar.dataset.dto.DataSetTableNameDto;
import com.jxdinfo.hussar.dataset.dto.ErrorResultDto;
import com.jxdinfo.hussar.dataset.dto.SqlDataSetDto;
import com.jxdinfo.hussar.dataset.enums.DataSetErrorCodeEnum;
import com.jxdinfo.hussar.dataset.factory.DataSetProcessorFactory;
import com.jxdinfo.hussar.dataset.model.DataSetTableFieldInfo;
import com.jxdinfo.hussar.dataset.model.SqlField1;
import com.jxdinfo.hussar.dataset.model.WordDataSetGroup;
import com.jxdinfo.hussar.dataset.model.WordDataSetInfo;
import com.jxdinfo.hussar.dataset.service.IDataSetGroupService;
import com.jxdinfo.hussar.dataset.service.IDataSetService;
import com.jxdinfo.hussar.dataset.service.IDataSetTableNameService;
import com.jxdinfo.hussar.dataset.util.DataSetParamUtil;
import com.jxdinfo.hussar.dataset.vo.SqlDataSetVo;
import com.jxdinfo.hussar.dataset.vo.WordDataSetGroupAllVo;
import com.jxdinfo.hussar.datasource.model.DsTableField;
import com.jxdinfo.hussar.datasource.model.DsTableInfo;
import com.jxdinfo.hussar.datasource.model.SysDataSource;
import com.jxdinfo.hussar.datasource.service.DatasourceDataService;
import com.jxdinfo.hussar.datasource.service.SysDataSourceService;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.base.entity.BaseEntity;
import com.jxdinfo.hussar.platform.core.base.entity.HussarBaseEntity;
import com.jxdinfo.hussar.platform.core.base.entity.HussarDelflagEntity;
import com.jxdinfo.hussar.platform.core.utils.BeanUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.JsonUtil;
import com.jxdinfo.hussar.support.cache.util.HussarCacheUtil;
import com.jxdinfo.hussar.support.exception.HussarException;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.mock.web.MockMultipartFile;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service(value="com.jxdinfo.hussar.dataset.service.impl.DataSetServiceImpl")
public class DataSetServiceImpl
extends HussarServiceImpl<WordDataSetMapper, WordDataSetInfo>
implements IDataSetService {
    private static Logger logger = LoggerFactory.getLogger(DataSetServiceImpl.class);
    @Resource
    private WordDataSetMapper wordDataSetMapper;
    @Resource
    private WordDataSetGroupMapper wordDataSetGroupMapper;
    @Resource
    private SysDataSourceService sysDataSourceService;
    @Resource
    private DatasourceDataService datasourceDataService;
    @Resource
    private IDataSetTableNameService dataSetTableNameService;

    @HussarTransactional
    public ApiResponse<Object> addDataSetInfo(DataSetInfoDto dataSetInfoDto) {
        if (HussarUtils.isEmpty((Object)dataSetInfoDto)) {
            throw new HussarException(Integer.valueOf(DataSetErrorCodeEnum.DATASET_PARAM_ISNULL.getCode()), DataSetErrorCodeEnum.DATASET_PARAM_ISNULL.getMessage());
        }
        String data = dataSetInfoDto.getData();
        if (HussarUtils.isEmpty((Object)data)) {
            throw new HussarException(Integer.valueOf(DataSetErrorCodeEnum.DATASET_DATA_ISNULL.getCode()), String.format("\u6570\u636e\u96c6\u3010%s\u3011\u914d\u7f6e\u4fe1\u606f\u672a\u4f20\u5165\uff01", dataSetInfoDto.getDataSetName()));
        }
        Object result = DataSetProcessorFactory.createDataSetProcessor(dataSetInfoDto.getDataSetType()).save(dataSetInfoDto);
        return ApiResponse.success((Object)result, (String)"\u65b0\u589e\u6210\u529f\uff01");
    }

    @HussarTransactional
    public ApiResponse<Object> editDataSetInfo(DataSetInfoDto dataSetInfoDto) {
        WordDataSetInfo wordDataSetInfo = (WordDataSetInfo)this.getById(dataSetInfoDto.getDataSetId());
        if (HussarUtils.isEmpty((Object)wordDataSetInfo)) {
            this.addDataSetInfo(dataSetInfoDto);
            return ApiResponse.success((Object)dataSetInfoDto.getDataSetId(), (String)"\u4fee\u6539\u6210\u529f\uff01");
        }
        DataSetProcessorFactory.createDataSetProcessor(dataSetInfoDto.getDataSetType()).editModel(dataSetInfoDto);
        if (!this.updateById((BaseEntity)dataSetInfoDto)) {
            throw new HussarException(Integer.valueOf(DataSetErrorCodeEnum.DATASET_UPDATE_FAIL.getCode()), DataSetErrorCodeEnum.DATASET_UPDATE_FAIL.getMessage());
        }
        return ApiResponse.success((Object)dataSetInfoDto.getDataSetId(), (String)"\u4fee\u6539\u6210\u529f\uff01");
    }

    @HussarTransactional(rollbackFor={Exception.class})
    public ApiResponse<Boolean> deleteDataSetInfo(Long dataSetId) {
        try {
            WordDataSetInfo wordDataSetInfo = (WordDataSetInfo)this.getById(dataSetId);
            DataSetProcessorFactory.createDataSetProcessor(wordDataSetInfo.getDataSetType()).delete((DataSetInfoDto)HussarUtils.copyProperties((Object)wordDataSetInfo, DataSetInfoDto.class));
        }
        catch (Exception e) {
            throw new BaseException("\u89e3\u6790\u5f15\u64ce\u76f8\u5173\u4f9d\u8d56\u6570\u636e\u5220\u9664\u5931\u8d25\uff01", (Throwable)e);
        }
        if (!this.removeById(dataSetId)) {
            throw new BaseException("\u5220\u9664\u5931\u8d25\uff01");
        }
        return ApiResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    public List<WordDataSetInfo> getDataSetInfoList(String dataSetName, String dataSetType) {
        LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)lambdaQueryWrapper.like(HussarUtils.isNotEmpty((Object)dataSetName), WordDataSetInfo::getDataSetName, (Object)dataSetName)).eq(HussarUtils.isNotEmpty((Object)dataSetType), WordDataSetInfo::getDataSetType, (Object)dataSetType)).orderByAsc(WordDataSetInfo::getSeq);
        List list = this.wordDataSetMapper.selectList((Wrapper)lambdaQueryWrapper);
        return list;
    }

    public List<WordDataSetInfo> getDataSetInfoListByType(List<String> dataSetType) {
        LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)lambdaQueryWrapper.in(HussarUtils.isNotEmpty(dataSetType), WordDataSetInfo::getDataSetType, dataSetType)).orderByAsc(WordDataSetInfo::getSeq);
        List list = this.wordDataSetMapper.selectList((Wrapper)lambdaQueryWrapper);
        return list;
    }

    public List<WordDataSetGroupAllVo> getDataSetGroupList(String dataSetName, String dataSetType, Long groupId) {
        LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)lambdaQueryWrapper.like(HussarUtils.isNotEmpty((Object)dataSetName), WordDataSetInfo::getDataSetName, (Object)dataSetName)).eq(HussarUtils.isNotEmpty((Object)dataSetType), WordDataSetInfo::getDataSetType, (Object)dataSetType)).eq(HussarUtils.isNotEmpty((Object)groupId), WordDataSetInfo::getGroupId, (Object)groupId)).orderByAsc(WordDataSetInfo::getSeq);
        List dataSetInfoList = this.wordDataSetMapper.selectList((Wrapper)lambdaQueryWrapper);
        if (HussarUtils.isEmpty((Object)dataSetInfoList)) {
            return Collections.emptyList();
        }
        Set groupIds = dataSetInfoList.stream().map(WordDataSetInfo::getGroupId).collect(Collectors.toSet());
        LambdaQueryWrapper groupLambdaQueryWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)groupLambdaQueryWrapper.in(HussarUtils.isNotEmpty(groupIds), WordDataSetGroup::getGroupId, groupIds)).orderByAsc(WordDataSetGroup::getSeq)).orderByAsc(HussarBaseEntity::getCreateTime);
        List wordWordDataSetGroups = this.wordDataSetGroupMapper.selectList((Wrapper)groupLambdaQueryWrapper);
        if (HussarUtils.isNotEmpty((Object)wordWordDataSetGroups)) {
            Map groupMap = wordWordDataSetGroups.stream().map(wordDataSetGroup -> {
                WordDataSetGroupAllVo wordDataSetGroupAllVo = new WordDataSetGroupAllVo();
                BeanUtil.copy((Object)wordDataSetGroup, (Object)wordDataSetGroupAllVo);
                return wordDataSetGroupAllVo;
            }).distinct().collect(Collectors.toMap(WordDataSetGroup::getGroupId, Function.identity()));
            for (WordDataSetInfo WordDataSetInfo2 : dataSetInfoList) {
                WordDataSetGroupAllVo wordDataSetGroupAllVo = (WordDataSetGroupAllVo)groupMap.get(WordDataSetInfo2.getGroupId());
                if (HussarUtils.isEmpty((Object)wordDataSetGroupAllVo)) continue;
                if (HussarUtils.isNotEmpty((Object)wordDataSetGroupAllVo.getDataSetInfoDtos())) {
                    wordDataSetGroupAllVo.getDataSetInfoDtos().add(WordDataSetInfo2);
                }
                if (!HussarUtils.isEmpty((Object)wordDataSetGroupAllVo.getDataSetInfoDtos())) continue;
                ArrayList<WordDataSetInfo> wordWordDataSetInfoList = new ArrayList<WordDataSetInfo>();
                wordWordDataSetInfoList.add(WordDataSetInfo2);
                wordDataSetGroupAllVo.setDataSetInfoDtos(wordWordDataSetInfoList);
            }
            return new ArrayList<WordDataSetGroupAllVo>(groupMap.values());
        }
        return Collections.emptyList();
    }

    public SqlDataSetVo preivewDataBySql(SqlDataSetDto sqlDataSetDto) {
        return DataSetProcessorFactory.createDataSetProcessor(sqlDataSetDto.getDataSetType()).preivewDataBySql(sqlDataSetDto);
    }

    public List<DataSetTableFieldInfo> tableInfoList(String dataSourceName) {
        SysDataSource sysDataSource = this.sysDataSourceService.getByConnName(dataSourceName);
        HussarException.throwBy((boolean)HussarUtils.isEmpty((Object)sysDataSource), (String)String.format("\u8fde\u63a5\u6807\u8bc6\u4e3a\u3010%s\u3011\u7684\u6570\u636e\u6e90\u4fe1\u606f\u4e0d\u5b58\u5728\uff01", dataSourceName));
        return this.tableInfoList(sysDataSource.getId(), Boolean.FALSE);
    }

    public List<DataSetTableFieldInfo> tableInfoList(Long datasourceId, Boolean queryField) {
        ArrayList<DataSetTableFieldInfo> tables = new ArrayList<DataSetTableFieldInfo>();
        try {
            List dataSetTableNameDtos = queryField != false ? this.dataSetTableNameService.getTableInfoListByDataSourceId(datasourceId) : this.dataSetTableNameService.getTableInfoByDataSourceId(datasourceId);
            for (DataSetTableNameDto tableInfo : dataSetTableNameDtos) {
                DataSetTableFieldInfo table = new DataSetTableFieldInfo();
                table.setName(tableInfo.getTableName());
                table.setCode(tableInfo.getTableName());
                table.setComment(tableInfo.getTableComment());
                table.setType("2");
                tables.add(table);
                if (HussarUtils.isEmpty((Object)tableInfo.getColumns())) continue;
                for (DataSetColumnNameDto tableField : tableInfo.getColumns()) {
                    DataSetTableFieldInfo field = new DataSetTableFieldInfo();
                    field.setName(tableField.getColumnName());
                    field.setCode(tableInfo.getTableName() + "_" + tableField.getColumnName());
                    field.setComment(tableField.getColumnComment());
                    field.setDataType(tableField.getDataType());
                    field.setType("3");
                    table.addChild(field);
                }
            }
        }
        catch (Exception e) {
            throw new HussarException(String.format("\u83b7\u53d6\u8868\u548c\u5b57\u6bb5\u4fe1\u606f\u5931\u8d25\uff01\u5931\u8d25\u539f\u56e0\uff1a%s", HussarUtils.isEmpty((Object)e.getCause()) ? e.getMessage() : e.getCause().getMessage()), (Throwable)e);
        }
        return tables;
    }

    public List<DataSetTableFieldInfo> tableInfoList(Long datasourceId, String type) {
        ArrayList<DataSetTableFieldInfo> tables = new ArrayList<DataSetTableFieldInfo>();
        try {
            List tableInfos = this.datasourceDataService.getTableInfoWithFieldInfoById(datasourceId, HussarUtils.isEmpty((Object)type) ? "ALL" : type);
            HussarException.throwBy((boolean)HussarUtils.isEmpty((Object)tableInfos), (String)"\u8868\u4fe1\u606f\u83b7\u53d6\u4e3a\u7a7a\uff01");
            for (DsTableInfo tableInfo : tableInfos) {
                DataSetTableFieldInfo table = new DataSetTableFieldInfo();
                table.setName(tableInfo.getName());
                table.setCode(tableInfo.getName());
                table.setComment(tableInfo.getComment());
                table.setType("2");
                tables.add(table);
                if (HussarUtils.isEmpty((Object)tableInfo.getFields())) continue;
                for (DsTableField tableField : tableInfo.getFields()) {
                    DataSetTableFieldInfo field = new DataSetTableFieldInfo();
                    field.setName(tableField.getName());
                    field.setCode(tableInfo.getName() + "_" + tableField.getName());
                    field.setComment(tableField.getComment());
                    field.setDataType(tableField.getType());
                    field.setType("3");
                    table.addChild(field);
                }
            }
        }
        catch (Exception e) {
            throw new HussarException(String.format("\u83b7\u53d6\u8868\u548c\u5b57\u6bb5\u4fe1\u606f\u5931\u8d25\uff01\u5931\u8d25\u539f\u56e0\uff1a%s", HussarUtils.isEmpty((Object)e.getCause()) ? e.getMessage() : e.getCause().getMessage()), (Throwable)e);
        }
        return tables;
    }

    public List<WordDataSetInfo> getDataSetInfoByGroupId(Long groupId) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)queryWrapper.eq(WordDataSetInfo::getGroupId, (Object)groupId)).orderByAsc(WordDataSetInfo::getSeq);
        return this.wordDataSetMapper.selectList((Wrapper)queryWrapper);
    }

    public List<DataSetTableFieldInfo> getColumnByTableName(Long datasourceId, String tableName) {
        HussarException.throwBy((boolean)HussarUtils.isEmpty((Object)tableName), (String)"\u8868\u540d\u672a\u4f20\u5165\uff01");
        try {
            List<Object> tableFieldInfos = new ArrayList<DataSetTableFieldInfo>();
            List columns = this.dataSetTableNameService.getColumnByTableName(datasourceId, tableName.toUpperCase());
            if (HussarUtils.isNotEmpty((Object)columns)) {
                tableFieldInfos = columns.stream().map(field -> {
                    DataSetTableFieldInfo tableFieldInfo = new DataSetTableFieldInfo();
                    tableFieldInfo.setColumnId(field.getColumnId());
                    tableFieldInfo.setName(field.getColumnName());
                    tableFieldInfo.setCode(field.getColumnName());
                    tableFieldInfo.setComment(field.getColumnComment());
                    tableFieldInfo.setDataType(field.getDataType());
                    tableFieldInfo.setJavaType(field.getJavaType());
                    tableFieldInfo.setType("3");
                    return tableFieldInfo;
                }).collect(Collectors.toList());
            }
            return tableFieldInfos;
        }
        catch (Exception e) {
            throw new HussarException(String.format("\u83b7\u53d6\u8868\u3010%s\u3011\u5b57\u6bb5\u4fe1\u606f\u5931\u8d25\uff01\u5931\u8d25\u539f\u56e0\uff1a%s", tableName, HussarUtils.isEmpty((Object)e.getCause()) ? e.getMessage() : e.getCause().getMessage()), (Throwable)e);
        }
    }

    public List<DataSetTableFieldInfo> getColumnByTableName(Long datasourceId, String tableName, String type) {
        HussarException.throwBy((boolean)HussarUtils.isEmpty((Object)tableName), (String)"\u8868\u540d\u672a\u4f20\u5165\uff01");
        try {
            List<Object> tableFieldInfos = new ArrayList<DataSetTableFieldInfo>();
            DsTableInfo tableInfo = this.datasourceDataService.filterTable(datasourceId, HussarUtils.isEmpty((Object)type) ? "ALL" : type, tableName.toUpperCase()).orElse(null);
            HussarException.throwBy((boolean)HussarUtils.isEmpty((Object)tableInfo), (String)String.format("\u8868\u3010%s\u3011\u4fe1\u606f\u4e0d\u5b58\u5728!", tableName));
            List fields = tableInfo.getFields();
            if (HussarUtils.isNotEmpty((Object)fields)) {
                tableFieldInfos = fields.stream().map(field -> {
                    DataSetTableFieldInfo dataSetTableFieldInfo = new DataSetTableFieldInfo();
                    dataSetTableFieldInfo.setName(field.getName());
                    dataSetTableFieldInfo.setCode(field.getName());
                    dataSetTableFieldInfo.setComment(field.getComment());
                    dataSetTableFieldInfo.setDataType(field.getType());
                    dataSetTableFieldInfo.setType("3");
                    return dataSetTableFieldInfo;
                }).collect(Collectors.toList());
            }
            return tableFieldInfos;
        }
        catch (Exception e) {
            throw new HussarException(String.format("\u83b7\u53d6\u8868\u3010%s\u3011\u5b57\u6bb5\u4fe1\u606f\u5931\u8d25\uff01\u5931\u8d25\u539f\u56e0\uff1a%s", tableName, HussarUtils.isEmpty((Object)e.getCause()) ? e.getMessage() : e.getCause().getMessage()), (Throwable)e);
        }
    }

    public List<DataSetTableFieldInfo> getOnlyTables(Long datasourceId, String type) {
        try {
            List<Object> tables = new ArrayList<DataSetTableFieldInfo>();
            List tableInfos = this.datasourceDataService.getTableInfoById(datasourceId, HussarUtils.isEmpty((Object)type) ? "ALL" : type);
            if (HussarUtils.isNotEmpty((Object)tableInfos)) {
                tables = tableInfos.stream().map(tableInfo -> {
                    DataSetTableFieldInfo table = (DataSetTableFieldInfo)HussarUtils.copyProperties((Object)tableInfo, DataSetTableFieldInfo.class);
                    table.setType("2");
                    return table;
                }).collect(Collectors.toList());
            }
            return tables;
        }
        catch (Exception e) {
            throw new HussarException(String.format("\u83b7\u53d6\u8868\u4fe1\u606f\u5931\u8d25\uff01\u5931\u8d25\u539f\u56e0\uff1a%s", HussarUtils.isEmpty((Object)e.getCause()) ? e.getMessage() : e.getCause().getMessage()), (Throwable)e);
        }
    }

    public List<DataSetTableFieldInfo> getOnlyTables(Long datasourceId) {
        try {
            List<Object> tables = new ArrayList<DataSetTableFieldInfo>();
            List tableInfos = this.dataSetTableNameService.getTableInfoByDataSourceId(datasourceId);
            if (HussarUtils.isNotEmpty((Object)tableInfos)) {
                tables = tableInfos.stream().filter(obj -> !this.startWithDigits(obj.getTableName())).map(tableInfo -> {
                    DataSetTableFieldInfo table = new DataSetTableFieldInfo();
                    table.setName(tableInfo.getTableName());
                    table.setCode(tableInfo.getTableName());
                    table.setComment(tableInfo.getTableComment());
                    table.setType("2");
                    return table;
                }).collect(Collectors.toList());
            }
            return tables;
        }
        catch (Exception e) {
            throw new HussarException(String.format("\u83b7\u53d6\u8868\u4fe1\u606f\u5931\u8d25\uff01\u5931\u8d25\u539f\u56e0\uff1a%s", HussarUtils.isEmpty((Object)e.getCause()) ? e.getMessage() : e.getCause().getMessage()), (Throwable)e);
        }
    }

    private boolean startWithDigits(String tableName) {
        if (HussarUtils.isEmpty((Object)tableName)) {
            return true;
        }
        String regex = "^[0-9].*";
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(tableName);
        return matcher.lookingAt();
    }

    public List<ErrorResultDto> importDataSet(MultipartFile file) {
        InputStream in = null;
        String json = "";
        try {
            in = file.getInputStream();
            byte[] bytes = new byte[in.available()];
            in.read(bytes);
            json = new String(bytes, Charset.defaultCharset());
        }
        catch (Exception e) {
            throw new HussarException("\u6587\u4ef6\u6d41\u8f6c\u5b57\u7b26\u4e32\u5931\u8d25\uff01", (Throwable)e);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (Exception exception) {}
            }
        }
        return this.importDataSet(json);
    }

    public List<ErrorResultDto> importDataSet(String json) {
        DataSetFileDto dataSetFileDto = (DataSetFileDto)JSONObject.parseObject((String)json, DataSetFileDto.class);
        List groupDtos = dataSetFileDto.getDataSetGroupDtos();
        if (HussarUtils.isNotEmpty((Object)groupDtos)) {
            IDataSetGroupService dataSetGroupService = (IDataSetGroupService)SpringContextHolder.getBean(IDataSetGroupService.class);
            dataSetGroupService.importDataSetGroup(groupDtos);
        }
        List infoDtos = dataSetFileDto.getDataSetInfoDtos();
        return this.processDataSets(infoDtos);
    }

    private List<ErrorResultDto> processDataSets(List<DataSetInfoDto> infoDtos) {
        ArrayList<ErrorResultDto> errorList = new ArrayList<ErrorResultDto>();
        if (HussarUtils.isNotEmpty(infoDtos)) {
            Map<Long, DataSetInfoDto> dataSetInfoMap = infoDtos.stream().collect(Collectors.toMap(WordDataSetInfo::getDataSetId, wordDataSetInfo -> wordDataSetInfo));
            List<WordDataSetInfo> dataSetInfos = this.getDataSetInfoByIds(new ArrayList<Long>(dataSetInfoMap.keySet()));
            if (HussarUtils.isEmpty(dataSetInfos)) {
                infoDtos.forEach(dataSetInfoDto -> {
                    try {
                        this.addDataSetInfo((DataSetInfoDto)dataSetInfoDto);
                    }
                    catch (HussarException e) {
                        logger.error("\u65b0\u589e\u6570\u636e\u96c6\u5931\u8d25", (Throwable)e);
                        errorList.add(this.exceptionProcess((Exception)((Object)e), (WordDataSetInfo)dataSetInfoDto));
                    }
                });
            } else {
                dataSetInfos.forEach(dataSetInfo -> {
                    Long dataSetId = dataSetInfo.getDataSetId();
                    if (dataSetInfoMap.containsKey(dataSetId)) {
                        try {
                            this.editDataSetInfo((DataSetInfoDto)dataSetInfoMap.get(dataSetId));
                        }
                        catch (HussarException e) {
                            logger.error("\u4fee\u6539\u6570\u636e\u96c6\u5931\u8d25", (Throwable)e);
                            errorList.add(this.exceptionProcess((Exception)((Object)e), (WordDataSetInfo)dataSetInfo));
                        }
                        dataSetInfoMap.remove(dataSetId);
                    }
                });
                ArrayList<DataSetInfoDto> addList = new ArrayList<DataSetInfoDto>(dataSetInfoMap.values());
                if (HussarUtils.isNotEmpty(addList)) {
                    addList.forEach(dataSetInfoDto -> {
                        try {
                            this.addDataSetInfo((DataSetInfoDto)dataSetInfoDto);
                        }
                        catch (Exception e) {
                            logger.error("\u65b0\u589e\u6570\u636e\u96c6\u5931\u8d25", (Throwable)e);
                            errorList.add(this.exceptionProcess(e, (WordDataSetInfo)dataSetInfoDto));
                        }
                    });
                }
            }
        }
        return errorList;
    }

    private ErrorResultDto exceptionProcess(Exception exception, WordDataSetInfo dataSetInfoDto) {
        Integer code = DataSetErrorCodeEnum.DATASET_OTHER_EXCEPTION.getCode();
        String message = exception.getMessage();
        for (Throwable e = exception; e != null; e = e.getCause()) {
            if (!HussarUtils.isEmpty((Object)e.getCause()) || !(e instanceof HussarException)) continue;
            HussarException hussarException = (HussarException)e;
            code = hussarException.getExceptionCode();
            message = hussarException.getMessage();
        }
        return new ErrorResultDto(code, dataSetInfoDto.getDataSetId(), dataSetInfoDto.getDataSetName(), message);
    }

    public MultipartFile exportDataSet(List<Long> dataSetIds) {
        String dataSetFileStr = this.processDataSetExport(dataSetIds);
        String tempFileName = File.separator + "export";
        File file1 = new File(tempFileName);
        if (!file1.exists()) {
            file1.mkdirs();
        }
        tempFileName = tempFileName + File.separator;
        String date = HussarUtils.formatDate((Date)new Date());
        String fileName = String.format("\u6570\u636e\u96c6_%s", date);
        String fileType = ".json";
        tempFileName = String.format("%s%s%s", tempFileName, fileName, fileType);
        this.writeFile(tempFileName, dataSetFileStr);
        FileInputStream fileInputStream = null;
        try {
            MockMultipartFile multipartFile;
            fileInputStream = new FileInputStream(tempFileName);
            MockMultipartFile mockMultipartFile = multipartFile = new MockMultipartFile(fileName + fileType, fileName + fileType, fileType, (InputStream)fileInputStream);
            return mockMultipartFile;
        }
        catch (IOException e) {
            logger.error("\u8bfb\u53d6\u4e34\u65f6\u6587\u4ef6\u65f6\u53d1\u751f\u5f02\u5e38", (Throwable)e);
            throw new RuntimeException("\u8bfb\u53d6\u4e34\u65f6\u6587\u4ef6\u5931\u8d25", e);
        }
        finally {
            if (fileInputStream != null) {
                try {
                    fileInputStream.close();
                }
                catch (IOException e) {
                    logger.error("\u5173\u95ed\u6587\u4ef6\u8f93\u5165\u6d41\u65f6\u53d1\u751f\u5f02\u5e38", (Throwable)e);
                }
            }
        }
    }

    private void writeFile(String tempFileName, String dataSetFileStr) {
        FileWriter writer = null;
        try {
            writer = new FileWriter(tempFileName);
            writer.write(dataSetFileStr);
        }
        catch (IOException e) {
            throw new HussarException("\u6570\u636e\u96c6\u4fe1\u606f\u5199\u5165\u5931\u8d25\uff01", (Throwable)e);
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException e) {
                    throw new HussarException("\u6570\u636e\u96c6\u4fe1\u606f\u5199\u5165\u5931\u8d25\uff01", (Throwable)e);
                }
            }
        }
    }

    public String processDataSetExport(List<Long> dataSetIds) {
        if (HussarUtils.isEmpty(dataSetIds)) {
            return null;
        }
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.in(WordDataSetInfo::getDataSetId, dataSetIds);
        List dataSetInfos = this.wordDataSetMapper.selectList((Wrapper)queryWrapper);
        DataSetFileDto dataSetFileDto = new DataSetFileDto();
        if (HussarUtils.isNotEmpty((Object)dataSetInfos)) {
            HashSet groupIds = new HashSet();
            dataSetFileDto.setDataSetInfoDtos(new ArrayList());
            dataSetInfos.forEach(dataSet -> {
                this.processTables((WordDataSetInfo)dataSet);
                dataSetFileDto.getDataSetInfoDtos().add(HussarUtils.copyProperties((Object)dataSet, DataSetInfoDto.class));
                groupIds.add(dataSet.getGroupId());
            });
            List<DataSetGroupDto> dataSetGroupDtos = this.processDataSetGroups(new ArrayList<Long>(groupIds));
            dataSetFileDto.setDataSetGroupDtos(dataSetGroupDtos);
        }
        return JsonUtil.toJson((Object)dataSetFileDto);
    }

    private void processTables(WordDataSetInfo dataSetInfo) {
        DataSetConfigInfoDto dataSetConfigInfoDto = (DataSetConfigInfoDto)JSONObject.parseObject((String)dataSetInfo.getData(), DataSetConfigInfoDto.class);
        if (HussarUtils.isNotEmpty((Object)dataSetConfigInfoDto.getTables())) {
            String tableName;
            Map<String, DsTableInfo> map = dataSetConfigInfoDto.getTables().stream().collect(Collectors.toMap(table -> table.getName().toLowerCase(), table -> table));
            String sql = dataSetConfigInfoDto.getDataSetParam().getSql();
            if (HussarUtils.isNotEmpty((Object)sql) && map.containsKey((tableName = sql.replace("select * from ", "").trim()).toLowerCase())) {
                dataSetConfigInfoDto.setTables(Collections.singletonList(map.get(tableName.toLowerCase())));
                dataSetInfo.setData(JSONObject.toJSONString((Object)dataSetConfigInfoDto));
            }
        }
    }

    public Integer getSeqByGroupId(Long groupId) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)queryWrapper.select(new SFunction[]{WordDataSetInfo::getSeq}).eq(WordDataSetInfo::getGroupId, (Object)groupId)).orderByDesc(WordDataSetInfo::getSeq);
        Page page = new Page(1L, 1L);
        Page resultPage = (Page)this.wordDataSetMapper.selectPage((IPage)page, (Wrapper)queryWrapper);
        List records = resultPage.getRecords();
        return HussarUtils.isNotEmpty((Object)records) ? ((WordDataSetInfo)records.get(0)).getSeq() : 0;
    }

    public Boolean flushed(Long dataSourceId) {
        HussarException.throwBy((boolean)HussarUtils.isEmpty((Object)dataSourceId), (String)"\u540c\u6b65\u6570\u636e\u6e90\u8868\u4fe1\u606f\u65f6\uff0c\u6570\u636e\u6e90\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        String dataSourceFlushedName = String.format("%s_%s", "dataset_table_name_flushed", dataSourceId);
        Boolean flushing = (Boolean)HussarCacheUtil.get((String)dataSourceFlushedName, (Object)"flushed_key");
        if (HussarUtils.isNotEmpty((Object)flushing) && flushing.booleanValue()) {
            return Boolean.FALSE;
        }
        HussarCacheUtil.put((String)dataSourceFlushedName, (Object)"flushed_key", (Object)true, (long)600L);
        try {
            this.dataSetTableNameService.flushed(dataSourceId);
        }
        catch (Exception e) {
            throw new HussarException("\u540c\u6b65\u5f53\u524d\u6570\u636e\u6e90\u8868\u4fe1\u606f\u5931\u8d25\uff01", (Throwable)e);
        }
        finally {
            HussarCacheUtil.evict((String)dataSourceFlushedName, (Object)"flushed_key");
        }
        return Boolean.TRUE;
    }

    public void flushedAllDb() {
        List<Object> sysDataSources = new ArrayList<SysDataSource>();
        try {
            LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)((LambdaQueryWrapper)queryWrapper.eq(HussarDelflagEntity::getDelFlag, (Object)0)).eq(SysDataSource::getTenantCode, (Object)"0")).orderByDesc(HussarBaseEntity::getCreateTime);
            sysDataSources = this.sysDataSourceService.list((Wrapper)queryWrapper);
        }
        catch (Exception e) {
            logger.error("\u6570\u636e\u6e90\u67e5\u8be2\u5931\u8d25\uff01\u5931\u8d25\u539f\u56e0\uff1a", (Throwable)e);
        }
        if (HussarUtils.isNotEmpty(sysDataSources)) {
            this.asyncProcess(sysDataSources);
        }
    }

    public List<SqlField1> flushedSqlField(Long dataSourceId, String tableName, String dataSourceName) {
        return DataSetParamUtil.getProjection(dataSourceId, tableName, dataSourceName);
    }

    private List<DataSetGroupDto> processDataSetGroups(List<Long> groupIds) {
        IDataSetGroupService dataSetGroupService = (IDataSetGroupService)SpringContextHolder.getBean(IDataSetGroupService.class);
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.in(WordDataSetGroup::getGroupId, groupIds);
        List wordDataSetGroups = dataSetGroupService.list((Wrapper)queryWrapper);
        List<Object> dataSetGroupDtos = new ArrayList<DataSetGroupDto>();
        if (HussarUtils.isNotEmpty((Object)wordDataSetGroups)) {
            dataSetGroupDtos = wordDataSetGroups.stream().map(wordDataSetGroup -> (DataSetGroupDto)HussarUtils.copyProperties((Object)wordDataSetGroup, DataSetGroupDto.class)).collect(Collectors.toList());
        }
        return dataSetGroupDtos;
    }

    public List<WordDataSetInfo> getDataSetInfoByIds(List<Long> ids) {
        LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
        lambdaQueryWrapper.in(HussarUtils.isNotEmpty(ids), WordDataSetInfo::getDataSetId, ids);
        return this.wordDataSetMapper.selectList((Wrapper)lambdaQueryWrapper);
    }

    private void asyncProcess(List<SysDataSource> sysDataSources) {
        ThreadPoolTaskExecutor hussarAsyncPoolTaskExecutor = (ThreadPoolTaskExecutor)SpringContextHolder.getBean((String)"hussarAsyncPoolTaskExecutor");
        try {
            sysDataSources.stream().forEach(sysDataSource -> CompletableFuture.runAsync(() -> {
                try {
                    this.dataSetTableNameService.syncTable(sysDataSource, Boolean.FALSE);
                }
                catch (Exception e) {
                    logger.error("\u6570\u636e\u6e90\u3010{}\u3011\u540c\u6b65\u6570\u636e\u6e90\u5931\u8d25\uff01\u5931\u8d25\u539f\u56e0\uff1a", (Object)sysDataSource.getDbName(), (Object)e);
                }
            }, (Executor)hussarAsyncPoolTaskExecutor));
        }
        catch (Exception e) {
            logger.error("\u6570\u636e\u8868\u540c\u6b65\u5931\u8d25\uff01\u5931\u8d25\u539f\u56e0\uff1a", (Throwable)e);
        }
    }

    private List<DsTableInfo> getTablesByDb(SysDataSource sysDataSource) {
        return this.dataSetTableNameService.getTablesByDb(sysDataSource, Boolean.valueOf(false));
    }
}

