/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.dataset.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.dataset.dao.WordDataSetGroupMapper;
import com.jxdinfo.hussar.dataset.dto.DataSetGroupDto;
import com.jxdinfo.hussar.dataset.dto.DataSetInfoDto;
import com.jxdinfo.hussar.dataset.enums.DataSetTypeEnum;
import com.jxdinfo.hussar.dataset.model.WordDataSetGroup;
import com.jxdinfo.hussar.dataset.model.WordDataSetInfo;
import com.jxdinfo.hussar.dataset.service.IDataSetGroupService;
import com.jxdinfo.hussar.dataset.service.IDataSetService;
import com.jxdinfo.hussar.dataset.vo.WordDataSetGroupAllVo;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.base.entity.BaseEntity;
import com.jxdinfo.hussar.platform.core.base.entity.HussarBaseEntity;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.exception.HussarException;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service(value="com.jxdinfo.hussar.dataset.service.impl.DataSetGroupServiceImpl")
public class DataSetGroupServiceImpl
extends HussarServiceImpl<WordDataSetGroupMapper, WordDataSetGroup>
implements IDataSetGroupService {
    @Resource
    private IDataSetService dataSetService;
    @Resource
    private WordDataSetGroupMapper wordDataSetGroupMapper;

    public ApiResponse<Boolean> addGroup(DataSetGroupDto dataSetGroupDto) {
        boolean flag;
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        wrapper.eq(WordDataSetGroup::getGroupName, (Object)dataSetGroupDto.getGroupName());
        List groups = this.list((Wrapper)wrapper);
        if (HussarUtils.isNotEmpty((Object)groups)) {
            throw new BaseException("\u65b0\u589e\u5931\u8d25\uff01\u5e94\u7528\u5206\u7ec4\u540d\u79f0\u5df2\u5b58\u5728\uff01");
        }
        if (HussarUtils.isEmpty((Object)dataSetGroupDto.getGroupType())) {
            dataSetGroupDto.setGroupType("2");
        }
        if (HussarUtils.isNotEmpty((Object)dataSetGroupDto.getSeq())) {
            Integer seq = this.wordDataSetGroupMapper.getMaxSeq();
            seq = HussarUtils.isEmpty((Object)seq) ? 1 : seq + 1;
            dataSetGroupDto.setSeq(seq.intValue());
        }
        if (!(flag = this.save((BaseEntity)dataSetGroupDto))) {
            throw new BaseException("\u65b0\u589e\u5931\u8d25");
        }
        return ApiResponse.success((String)"\u65b0\u589e\u6210\u529f");
    }

    public ApiResponse<Boolean> updateGroup(DataSetGroupDto dataSetGroupDto) {
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        ((LambdaQueryWrapper)wrapper.eq(WordDataSetGroup::getGroupName, (Object)dataSetGroupDto.getGroupName())).ne(WordDataSetGroup::getGroupId, (Object)dataSetGroupDto.getGroupId());
        List groups = this.list((Wrapper)wrapper);
        if (HussarUtils.isNotEmpty((Object)groups)) {
            throw new BaseException("\u4fee\u6539\u5931\u8d25\uff01\u5e94\u7528\u5206\u7ec4\u540d\u79f0\u5df2\u5b58\u5728\uff01");
        }
        WordDataSetGroup group = (WordDataSetGroup)this.getById(dataSetGroupDto.getGroupId());
        group.setGroupName(dataSetGroupDto.getGroupName());
        group.setGroupDesc(dataSetGroupDto.getGroupDesc());
        group.setGroupIcon(dataSetGroupDto.getGroupIcon());
        group.setGroupIconType(dataSetGroupDto.getGroupIconType());
        group.setGroupIconColor(dataSetGroupDto.getGroupIconColor());
        boolean flag = this.updateById((BaseEntity)group);
        if (!flag) {
            throw new BaseException("\u66f4\u65b0\u5931\u8d25");
        }
        return ApiResponse.success((String)"\u66f4\u65b0\u6210\u529f");
    }

    public ApiResponse<Boolean> deleteGroup(Long groupId) {
        List dataSetInfos = this.dataSetService.getDataSetInfoByGroupId(groupId);
        if (HussarUtils.isNotEmpty((Object)dataSetInfos)) {
            throw new BaseException("\u5220\u9664\u5931\u8d25\uff01\u5206\u7ec4\u4e0b\u5b58\u5728\u6570\u636e\u96c6\uff01");
        }
        boolean flag = this.removeById(groupId);
        if (!flag) {
            throw new BaseException("\u5220\u9664\u5931\u8d25");
        }
        return ApiResponse.success((String)"\u5220\u9664\u6210\u529f");
    }

    public ApiResponse<List<WordDataSetGroup>> getGroupList() {
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        wrapper.orderByAsc(HussarBaseEntity::getCreateTime);
        return ApiResponse.success((Object)this.list((Wrapper)wrapper));
    }

    public ApiResponse<List<WordDataSetGroup>> getGroupListByType(String groupType) {
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        if (HussarUtils.isNotEmpty((Object)groupType)) {
            if (HussarUtils.equals((Object)DataSetTypeEnum.DATASTREAM.getCode(), (Object)groupType)) {
                wrapper.eq(WordDataSetGroup::getGroupType, (Object)groupType);
            } else {
                wrapper.ne(WordDataSetGroup::getGroupType, (Object)DataSetTypeEnum.DATASTREAM.getCode());
            }
        }
        wrapper.orderByAsc(HussarBaseEntity::getCreateTime);
        return ApiResponse.success((Object)this.list((Wrapper)wrapper));
    }

    public ApiResponse<Page<WordDataSetGroup>> getDataSetGroupByGroupName(String groupName, int pageNum, int pageSize) {
        Page page = new Page((long)pageNum, (long)pageSize);
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.like(HussarUtils.isNotEmpty((Object)groupName), WordDataSetGroup::getGroupName, (Object)groupName);
        return ApiResponse.success((Object)this.wordDataSetGroupMapper.selectPage((IPage)page, (Wrapper)queryWrapper));
    }

    @HussarTransactional
    public ApiResponse<Boolean> editGroupAndDataSet(List<DataSetGroupDto> dataSetGroupDtos) {
        ArrayList<Object> dataSetInfos = new ArrayList<Object>();
        for (int i = 0; i < dataSetGroupDtos.size(); ++i) {
            DataSetGroupDto dataSetGroupDto2 = dataSetGroupDtos.get(i);
            dataSetGroupDto2.setSeq(i);
            List dataSetInfoDtos = dataSetGroupDto2.getDataSetInfoDtos();
            if (HussarUtils.isEmpty((Object)dataSetInfoDtos)) continue;
            for (int j = 0; j < dataSetInfoDtos.size(); ++j) {
                DataSetInfoDto dataSetInfoDto = (DataSetInfoDto)dataSetInfoDtos.get(j);
                dataSetInfoDto.setSeq(Integer.valueOf(j));
                dataSetInfoDto.setGroupId(dataSetGroupDto2.getGroupId());
                dataSetInfos.add(HussarUtils.copy((Object)dataSetInfoDto, WordDataSetInfo.class));
            }
        }
        List wordDataSetGroups = dataSetGroupDtos.stream().map(dataSetGroupDto -> (WordDataSetGroup)HussarUtils.copyProperties((Object)dataSetGroupDto, WordDataSetGroup.class)).collect(Collectors.toList());
        this.updateBatchById(wordDataSetGroups);
        Boolean flag = this.dataSetService.updateBatchById(dataSetInfos);
        return ApiResponse.success((Object)flag);
    }

    public ApiResponse<List<WordDataSetGroupAllVo>> getAllDataSetAndGroup() {
        List<Object> wordDataSetGroupAllVos = new ArrayList();
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.orderByAsc(WordDataSetGroup::getSeq);
        List wordDataSetGroups = this.wordDataSetGroupMapper.selectList((Wrapper)queryWrapper);
        List dataSetInfos = this.dataSetService.getDataSetInfoList(null, null);
        if (HussarUtils.isNotEmpty((Object)wordDataSetGroups)) {
            Map<Long, List<WordDataSetInfo>> dataSetInfoMap = dataSetInfos.stream().collect(Collectors.groupingBy(WordDataSetInfo::getGroupId));
            wordDataSetGroupAllVos = wordDataSetGroups.stream().map(wordDataSetGroup -> {
                WordDataSetGroupAllVo wordDataSetGroupAllVo = (WordDataSetGroupAllVo)HussarUtils.copyProperties((Object)wordDataSetGroup, WordDataSetGroupAllVo.class);
                List groupDataSets = dataSetInfoMap.getOrDefault(wordDataSetGroup.getGroupId(), new ArrayList());
                wordDataSetGroupAllVo.setDataSetInfoDtos(groupDataSets);
                return wordDataSetGroupAllVo;
            }).collect(Collectors.toList());
        }
        return ApiResponse.success(wordDataSetGroupAllVos);
    }

    public ApiResponse<List<WordDataSetGroupAllVo>> getAllDataSetAndGroup(String dataSetType) {
        List<Object> wordDataSetGroupAllVos = new ArrayList();
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        if (HussarUtils.isNotEmpty((Object)dataSetType)) {
            if (HussarUtils.equals((Object)DataSetTypeEnum.DATASTREAM.getCode(), (Object)dataSetType)) {
                queryWrapper.eq(WordDataSetGroup::getGroupType, (Object)dataSetType);
            } else {
                queryWrapper.ne(WordDataSetGroup::getGroupType, (Object)DataSetTypeEnum.DATASTREAM.getCode());
            }
        }
        queryWrapper.orderByAsc(WordDataSetGroup::getSeq);
        List wordDataSetGroups = this.wordDataSetGroupMapper.selectList((Wrapper)queryWrapper);
        List dataSetInfos = new ArrayList();
        if (HussarUtils.isNotEmpty((Object)dataSetType)) {
            if (HussarUtils.equals((Object)DataSetTypeEnum.DATASTREAM.getCode(), (Object)dataSetType)) {
                dataSetInfos = this.dataSetService.getDataSetInfoList(null, dataSetType);
            } else {
                ArrayList<String> dataSetTypes = new ArrayList<String>();
                dataSetTypes.add(DataSetTypeEnum.DB.getCode());
                dataSetTypes.add(DataSetTypeEnum.SQL.getCode());
                dataSetTypes.add(DataSetTypeEnum.FILE.getCode());
                dataSetTypes.add(DataSetTypeEnum.API.getCode());
                dataSetInfos = this.dataSetService.getDataSetInfoListByType(dataSetTypes);
            }
        } else {
            dataSetInfos = this.dataSetService.getDataSetInfoList(null, null);
        }
        if (HussarUtils.isNotEmpty((Object)wordDataSetGroups)) {
            Map<Object, Object> dataSetInfoMap = HussarUtils.isNotEmpty(dataSetInfos) ? dataSetInfos.stream().collect(Collectors.groupingBy(WordDataSetInfo::getGroupId)) : new HashMap();
            wordDataSetGroupAllVos = wordDataSetGroups.stream().map(wordDataSetGroup -> {
                WordDataSetGroupAllVo wordDataSetGroupAllVo = (WordDataSetGroupAllVo)HussarUtils.copyProperties((Object)wordDataSetGroup, WordDataSetGroupAllVo.class);
                List groupDataSets = dataSetInfoMap.getOrDefault(wordDataSetGroup.getGroupId(), new ArrayList());
                wordDataSetGroupAllVo.setDataSetInfoDtos(groupDataSets);
                return wordDataSetGroupAllVo;
            }).collect(Collectors.toList());
        }
        return ApiResponse.success(wordDataSetGroupAllVos);
    }

    @HussarTransactional
    public Boolean importDataSetGroup(MultipartFile file) {
        InputStream in = null;
        String json = "";
        try {
            in = file.getInputStream();
            byte[] bytes = new byte[in.available()];
            in.read(bytes);
            json = new String(bytes, Charset.defaultCharset());
        }
        catch (Exception e) {
            throw new HussarException("\u6587\u4ef6\u6d41\u8f6c\u5b57\u7b26\u4e32\u5931\u8d25\uff01", (Throwable)e);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (Exception exception) {}
            }
        }
        List dataSetGroupDtos = JSONObject.parseArray((String)json, DataSetGroupDto.class);
        return this.importDataSetGroup(dataSetGroupDtos);
    }

    @HussarTransactional
    public Boolean importDataSetGroup(List<DataSetGroupDto> dataSetGroupDtos) {
        try {
            this.processDataSetGroups(dataSetGroupDtos);
        }
        catch (Exception e) {
            throw new HussarException("\u6570\u636e\u96c6\u5206\u7ec4\u5bfc\u5165\u5931\u8d25\uff01", (Throwable)e);
        }
        return Boolean.TRUE;
    }

    public String exportDataSetGroup(List<Long> groupIds) {
        return "";
    }

    private void processDataSetGroups(List<DataSetGroupDto> groupDtos) {
        if (HussarUtils.isNotEmpty(groupDtos)) {
            List dataSetGroups = this.wordDataSetGroupMapper.selectList((Wrapper)new LambdaQueryWrapper());
            if (HussarUtils.isEmpty((Object)dataSetGroups)) {
                List newGroups = groupDtos.stream().map(group -> (WordDataSetGroup)HussarUtils.copyProperties((Object)group, WordDataSetGroup.class)).collect(Collectors.toList());
                this.saveBatch(newGroups);
            } else {
                Map<Long, WordDataSetGroup> map = dataSetGroups.stream().collect(Collectors.toMap(WordDataSetGroup::getGroupId, wordDataSetGroup -> wordDataSetGroup));
                ArrayList updateGroups = new ArrayList();
                ArrayList saveGroups = new ArrayList();
                groupDtos.forEach(group -> {
                    WordDataSetGroup wordDataSetGroup = (WordDataSetGroup)HussarUtils.copyProperties((Object)group, WordDataSetGroup.class);
                    if (map.containsKey(group.getGroupId())) {
                        updateGroups.add(wordDataSetGroup);
                    } else {
                        saveGroups.add(wordDataSetGroup);
                    }
                });
                if (HussarUtils.isNotEmpty(updateGroups)) {
                    this.updateBatchById(updateGroups);
                }
                if (HussarUtils.isNotEmpty(saveGroups)) {
                    this.saveBatch(saveGroups);
                }
            }
        }
    }
}

