/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.dataset.factory;

import com.jxdinfo.hussar.dataset.enums.DataSetTypeEnum;
import com.jxdinfo.hussar.dataset.service.IDataSetProcessor;
import com.jxdinfo.hussar.dataset.strategy.dataset.ApiDataSetProcessor;
import com.jxdinfo.hussar.dataset.strategy.dataset.DataSetCommonProcessor;
import com.jxdinfo.hussar.dataset.strategy.dataset.DataStreamRrocessor;
import com.jxdinfo.hussar.dataset.strategy.dataset.DbDataSetProcessor;
import com.jxdinfo.hussar.dataset.strategy.dataset.FileDataSetProcessor;
import com.jxdinfo.hussar.dataset.strategy.dataset.SqlDataSetProcessor;
import com.jxdinfo.hussar.support.exception.HussarException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class DataSetProcessorFactory {
    private static Map<String, IDataSetProcessor> dataSetProcessServiceMap = new ConcurrentHashMap<String, IDataSetProcessor>();

    public static IDataSetProcessor createDataSetProcessor(String dataSetType) {
        if (dataSetProcessServiceMap.containsKey(dataSetType)) {
            return dataSetProcessServiceMap.get(dataSetType);
        }
        DataSetCommonProcessor IDataSetProcessor2 = null;
        DataSetTypeEnum dataSetTypeEnum = DataSetTypeEnum.valueOfCode(dataSetType);
        if (dataSetTypeEnum == null) {
            dataSetTypeEnum = DataSetTypeEnum.valueOfName(dataSetType);
        }
        switch (dataSetTypeEnum) {
            case API: {
                IDataSetProcessor2 = new ApiDataSetProcessor();
                break;
            }
            case DB: {
                IDataSetProcessor2 = new DbDataSetProcessor();
                break;
            }
            case FILE: {
                IDataSetProcessor2 = new FileDataSetProcessor();
                break;
            }
            case SQL: {
                IDataSetProcessor2 = new SqlDataSetProcessor();
                break;
            }
            case DATASTREAM: {
                IDataSetProcessor2 = new DataStreamRrocessor();
            }
            default: {
                throw new HussarException("\u6570\u636e\u96c6\u7c7b\u578b\u3010dataSetType\u3011\u4e0d\u5b58\u5728\uff01");
            }
        }
        dataSetProcessServiceMap.put(dataSetType, (IDataSetProcessor)IDataSetProcessor2);
        return IDataSetProcessor2;
    }
}

