/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.dataset.enums.jdbc;

import java.sql.Date;
import java.time.LocalDateTime;
import org.apache.ibatis.type.JdbcType;

public enum OracleDataTypeEnum {
    VARCHAR2("VARCHAR2", JdbcType.VARCHAR.name(), String.class, "string"),
    NVARCHAR("NVARCHAR", JdbcType.NVARCHAR.name(), String.class, "string"),
    NUMBER("NUMBER", JdbcType.NUMERIC.name(), Double.class, "double"),
    FLOAT("FLOAT", JdbcType.FLOAT.name(), Double.class, "double"),
    LONG("LONG", JdbcType.LONGVARCHAR.name(), Long.class, "long"),
    DATE("DATE", JdbcType.DATE.name(), Date.class, "date"),
    BINARY_FLOAT("BINARY FLOAT", JdbcType.FLOAT.name(), Double.class, "double"),
    BINARY_DOUBLE("BINARY DOUBLE", JdbcType.DOUBLE.name(), Double.class, "double"),
    TIMESTAMP("TIMESTAMP", JdbcType.TIMESTAMP.name(), LocalDateTime.class, "timestamp"),
    TIMESTAMP_WITH_TIME_ZONE("TIMESTAMP WITH TIME ZONE", JdbcType.TIME_WITH_TIMEZONE.name(), LocalDateTime.class, "timestamp"),
    TIMESTAMP_WITH_LOCAL_TIME_ZONE("TIMESTAMP WITH LOCAL TIME ZONE", JdbcType.TIMESTAMP_WITH_TIMEZONE.name(), LocalDateTime.class, "timestamp"),
    INTERVAL_YEAR_TO_MONTH("INTERVAL YEAR TO MONTH", JdbcType.DATE.name(), String.class, "string"),
    INTERVAL_DAY_TO_SECOND("INTERVAL DAY TO SECOND", JdbcType.DATE.name(), String.class, "string"),
    PLSQL_BOOLEAN("PLSQL_BOOLEAN", JdbcType.BOOLEAN.name(), Boolean.class, "boolean"),
    RAW("RAW", JdbcType.OTHER.name(), String.class, "string"),
    LONG_RAW("LONG RAW", JdbcType.OTHER.name(), String.class, "string"),
    ROWID("ROWID", JdbcType.ROWID.name(), String.class, "string"),
    UROWID("UROWID", JdbcType.OTHER.name(), String.class, "string"),
    CHAR("CHAR", JdbcType.CHAR.name(), String.class, "string"),
    CLOB("CLOB", JdbcType.CLOB.name(), String.class, "string"),
    NCLOB("NCLOB", JdbcType.NCLOB.name(), String.class, "string"),
    BLOB("BLOB", JdbcType.BLOB.name(), String.class, "string"),
    BFILE("BFILE", JdbcType.OTHER.name(), String.class, "string"),
    JSON("JSON", JdbcType.OTHER.name(), String.class, "string"),
    OBJECT("OBJECT", JdbcType.JAVA_OBJECT.name(), String.class, "string"),
    REF("REF", JdbcType.REF.name(), String.class, "string"),
    VARRAY("VARRAY", JdbcType.OTHER.name(), String.class, "string"),
    NESTED_TABLE("NESTED_TABLE", JdbcType.OTHER.name(), String.class, "string"),
    ANYTYPE("ANYTYPE", JdbcType.OTHER.name(), String.class, "string"),
    ANYDATA("ANYDATA", JdbcType.OTHER.name(), String.class, "string"),
    ANYDATASET("ANYDATASET", JdbcType.OTHER.name(), String.class, "string"),
    XMLTYPE("XMLTYPE", JdbcType.OTHER.name(), String.class, "string"),
    HTTPURITYPE("HTTPURITYPE", JdbcType.OTHER.name(), String.class, "string"),
    XDBURITYPE("XDBURITYPE", JdbcType.OTHER.name(), String.class, "string"),
    DBURITYPE("DBURITYPE", JdbcType.OTHER.name(), String.class, "string"),
    SDO_GEOMETRY("SDO_GEOMETRY", JdbcType.OTHER.name(), String.class, "string"),
    SDO_TOPO_GEOMETRY("SDO_TOPO_GEOMETRY", JdbcType.OTHER.name(), String.class, "string"),
    SDO_GEORASTER("SDO_GEORASTER", JdbcType.OTHER.name(), String.class, "string"),
    ORDAUDIO("ORDAUDIO", JdbcType.OTHER.name(), String.class, "string"),
    ORDDICOM("ORDDICOM", JdbcType.OTHER.name(), String.class, "string"),
    ORDDOC("ORDDOC", JdbcType.OTHER.name(), String.class, "string"),
    ORDIMAGE("ORDIMAGE", JdbcType.OTHER.name(), String.class, "string"),
    ORDVIDEO("ORDVIDEO", JdbcType.OTHER.name(), String.class, "string"),
    SI_AVERAGE_COLOR("SI_AVERAGE_COLOR", JdbcType.OTHER.name(), String.class, "string"),
    SI_COLOR("SI_COLOR", JdbcType.OTHER.name(), String.class, "string"),
    SI_COLOR_HISTOGRAM("SI_COLOR_HISTOGRAM", JdbcType.OTHER.name(), String.class, "string"),
    SI_FEATURE_LIST("SI_FEATURE_LIST", JdbcType.OTHER.name(), String.class, "string"),
    SI_POSITIONAL_COLOR("SI_POSITIONAL_COLOR", JdbcType.OTHER.name(), String.class, "string"),
    SI_STILL_IMAGE("SI_STILL_IMAGE", JdbcType.OTHER.name(), String.class, "string"),
    SI_TEXTURE("SI_TEXTURE", JdbcType.OTHER.name(), String.class, "string"),
    OTHER("other", JdbcType.OTHER.name(), String.class, "string");

    private String jdbcType;
    private String ibatisJdbcType;
    private Class<?> javaType;
    private String frontType;

    private OracleDataTypeEnum(String jdbcType, String ibatisJdbcType, Class<?> javaType, String frontType) {
        this.javaType = javaType;
        this.ibatisJdbcType = ibatisJdbcType;
        this.jdbcType = jdbcType;
        this.frontType = frontType;
    }

    public String getJdbcType() {
        return this.jdbcType;
    }

    public void setJdbcType(String jdbcType) {
        this.jdbcType = jdbcType;
    }

    public Class<?> getJavaType() {
        return this.javaType;
    }

    public void setJavaType(Class<?> javaType) {
        this.javaType = javaType;
    }

    public String getIbatisJdbcType() {
        return this.ibatisJdbcType;
    }

    public String getFrontType() {
        return this.frontType;
    }

    public static OracleDataTypeEnum valueOfJdbcType(String jdbcType) {
        for (OracleDataTypeEnum value : OracleDataTypeEnum.values()) {
            if (!value.getJdbcType().equalsIgnoreCase(jdbcType)) continue;
            return value;
        }
        return OTHER;
    }
}

