/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.dataset.enums.jdbc;

import java.sql.Date;
import java.sql.Time;
import java.time.LocalDateTime;
import org.apache.ibatis.type.JdbcType;

public enum MysqlDataTypeEnum {
    DECIMAL("DECIMAL", JdbcType.DECIMAL.name(), Double.class, "double"),
    DECIMAL_UNSIGNED("DECIMAL UNSIGNED", JdbcType.DECIMAL.name(), Double.class, "double"),
    TINYINT("TINYINT", JdbcType.TINYINT.name(), Integer.class, "int"),
    TINYINT_UNSIGNED("TINYINT UNSIGNED", JdbcType.TINYINT.name(), Integer.class, "int"),
    BOOLEAN("BOOLEAN", JdbcType.BOOLEAN.name(), Boolean.class, "boolean"),
    SMALLINT("SMALLINT", JdbcType.SMALLINT.name(), Integer.class, "int"),
    SMALLINT_UNSIGNED("SMALLINT UNSIGNED", JdbcType.SMALLINT.name(), Integer.class, "int"),
    INT("INT", JdbcType.INTEGER.name(), Integer.class, "int"),
    INT_UNSIGNED("INT UNSIGNED", JdbcType.INTEGER.name(), Long.class, "long"),
    FLOAT("FLOAT", JdbcType.REAL.name(), Double.class, "double"),
    FLOAT_UNSIGNED("FLOAT UNSIGNED", JdbcType.REAL.name(), Double.class, "double"),
    DOUBLE("DOUBLE", JdbcType.DOUBLE.name(), Double.class, "double"),
    DOUBLE_UNSIGNED("DOUBLE UNSIGNED", JdbcType.DOUBLE.name(), Double.class, "double"),
    NULL("NULL", JdbcType.NULL.name(), String.class, "string"),
    TIMESTAMP("TIMESTAMP", JdbcType.TIMESTAMP.name(), LocalDateTime.class, "timestamp"),
    BIGINT("BIGINT", JdbcType.BIGINT.name(), Long.class, "long"),
    BIGINT_UNSIGNED("BIGINT UNSIGNED", JdbcType.BIGINT.name(), Long.class, "long"),
    MEDIUMINT("MEDIUMINT", JdbcType.INTEGER.name(), Integer.class, "int"),
    MEDIUMINT_UNSIGNED("MEDIUMINT UNSIGNED", JdbcType.INTEGER.name(), Integer.class, "int"),
    DATE("DATE", JdbcType.DATE.name(), Date.class, "date"),
    TIME("TIME", JdbcType.TIME.name(), Time.class, "time"),
    DATETIME("DATETIME", JdbcType.DATE.name(), LocalDateTime.class, "timestamp"),
    YEAR("YEAR", JdbcType.DATE.name(), String.class, "string"),
    VARCHAR("VARCHAR", JdbcType.VARCHAR.name(), String.class, "string"),
    VARBINARY("VARBINARY", JdbcType.VARBINARY.name(), String.class, "string"),
    BIT("BIT", JdbcType.BIT.name(), Boolean.class, "boolean"),
    JSON("JSON", JdbcType.LONGNVARCHAR.name(), String.class, "string"),
    ENUM("ENUM", JdbcType.CHAR.name(), String.class, "string"),
    SET("SET", JdbcType.CHAR.name(), String.class, "string"),
    TINYBLOB("TINYBLOB", JdbcType.VARBINARY.name(), String.class, "string"),
    TINYTEXT("TINYTEXT", JdbcType.VARCHAR.name(), String.class, "string"),
    MEDIUMBLOB("MEDIUMBLOB", JdbcType.LONGVARBINARY.name(), String.class, "string"),
    MEDIUMTEXT("MEDIUMTEXT", JdbcType.LONGNVARCHAR.name(), String.class, "string"),
    LONGBLOB("LONGBLOB", JdbcType.LONGVARBINARY.name(), String.class, "string"),
    LONGTEXT("LONGTEXT", JdbcType.LONGNVARCHAR.name(), String.class, "string"),
    BLOB("BLOB", JdbcType.LONGVARBINARY.name(), String.class, "string"),
    TEXT("TEXT", JdbcType.LONGNVARCHAR.name(), String.class, "string"),
    CHAR("CHAR", JdbcType.CHAR.name(), String.class, "string"),
    BINARY("BINARY", JdbcType.BINARY.name(), String.class, "string"),
    GEOMETRY("GEOMETRY", JdbcType.BINARY.name(), String.class, "string"),
    VECTOR("VECTOR", JdbcType.LONGVARBINARY.name(), String.class, "string"),
    UNKNOWN("UNKNOWN", JdbcType.OTHER.name(), String.class, "string"),
    OTHER("OTHER", JdbcType.OTHER.name(), String.class, "string");

    private String jdbcType;
    private String ibatisJdbcType;
    private Class<?> javaType;
    private String frontType;

    private MysqlDataTypeEnum(String jdbcType, String ibatisJdbcType, Class<?> javaType, String frontType) {
        this.javaType = javaType;
        this.ibatisJdbcType = ibatisJdbcType;
        this.jdbcType = jdbcType;
        this.frontType = frontType;
    }

    public String getJdbcType() {
        return this.jdbcType;
    }

    public void setJdbcType(String jdbcType) {
        this.jdbcType = jdbcType;
    }

    public Class<?> getJavaType() {
        return this.javaType;
    }

    public void setJavaType(Class<?> javaType) {
        this.javaType = javaType;
    }

    public String getIbatisJdbcType() {
        return this.ibatisJdbcType;
    }

    public String getFrontType() {
        return this.frontType;
    }

    public void setIbatisJdbcType(String ibatisJdbcType) {
        this.ibatisJdbcType = ibatisJdbcType;
    }

    public static MysqlDataTypeEnum valueOfJdbcType(String jdbcType) {
        for (MysqlDataTypeEnum value : MysqlDataTypeEnum.values()) {
            if (!value.getJdbcType().equalsIgnoreCase(jdbcType)) continue;
            return value;
        }
        return OTHER;
    }
}

