/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.dataset.enums.jdbc;

import java.sql.Date;
import java.sql.Time;
import java.time.LocalDateTime;
import org.apache.ibatis.type.JdbcType;

public enum HighGoDataTypeEnum {
    SMALLINT("SMALLINT", JdbcType.SMALLINT.name(), Integer.class, "int"),
    VARCHAR2("VARCHAR2", JdbcType.VARCHAR.name(), String.class, "string"),
    NUMBER("NUMBER", JdbcType.NUMERIC.name(), Double.class, "double"),
    INTEGER("INTEGER", JdbcType.INTEGER.name(), Integer.class, "int"),
    BIGINT("BIGINT", JdbcType.BIGINT.name(), Long.class, "long"),
    DECIMAL("DECIMAL", JdbcType.DECIMAL.name(), Double.class, "double"),
    NUMERIC("NUMERIC", JdbcType.DECIMAL.name(), Double.class, "double"),
    DOUBLE("DOUBLE", JdbcType.DOUBLE.name(), Double.class, "double"),
    REAL("REAL", JdbcType.REAL.name(), Double.class, "double"),
    SMALLSERIAL("SMALLSERIAL", JdbcType.INTEGER.name(), Integer.class, "int"),
    SERIAL("SERIAL", JdbcType.INTEGER.name(), Integer.class, "int"),
    BIGSERIAL("BIGSERIAL", JdbcType.BIGINT.name(), Long.class, "long"),
    MONEY("MONEY", JdbcType.OTHER.name(), Double.class, "double"),
    VARCHAR("VARCHAR", JdbcType.VARCHAR.name(), String.class, "string"),
    RAW("RAW", JdbcType.OTHER.name(), String.class, "string"),
    UROWID("UROWID", JdbcType.ROWID.name(), String.class, "string"),
    CHAR("CHAR", JdbcType.CHAR.name(), String.class, "string"),
    NCHAR("NCHAR", JdbcType.OTHER.name(), String.class, "string"),
    FLOAT("FLOAT", JdbcType.FLOAT.name(), Double.class, "double"),
    TEXT("TEXT", JdbcType.CLOB.name(), String.class, "string"),
    TIMESTAMP("TIMESTAMP", JdbcType.TIMESTAMP.name(), LocalDateTime.class, "timestamp"),
    DATE("DATE", JdbcType.DATE.name(), Date.class, "date"),
    TIME("TIME", JdbcType.TIME.name(), Time.class, "time"),
    INTERVAL("INTERVAL", JdbcType.OTHER.name(), String.class, "string"),
    BOOLEAN("BOOLEAN", JdbcType.BOOLEAN.name(), Boolean.class, "boolean"),
    BPCHAR("BPCHAR", JdbcType.VARCHAR.name(), String.class, "string"),
    FLOAT4("FLOAT4", JdbcType.FLOAT.name(), Double.class, "double"),
    FLOAT8("FLOAT8", JdbcType.FLOAT.name(), Double.class, "double"),
    OTHER("OTHER", JdbcType.OTHER.name(), String.class, "string");

    private String jdbcType;
    private String ibatisJdbcType;
    private Class<?> javaType;
    private String frontType;

    private HighGoDataTypeEnum(String jdbcType, String ibatisJdbcType, Class<?> javaType, String frontType) {
        this.javaType = javaType;
        this.ibatisJdbcType = ibatisJdbcType;
        this.jdbcType = jdbcType;
        this.frontType = frontType;
    }

    public String getJdbcType() {
        return this.jdbcType;
    }

    public void setJdbcType(String jdbcType) {
        this.jdbcType = jdbcType;
    }

    public Class<?> getJavaType() {
        return this.javaType;
    }

    public void setJavaType(Class<?> javaType) {
        this.javaType = javaType;
    }

    public String getIbatisJdbcType() {
        return this.ibatisJdbcType;
    }

    public String getFrontType() {
        return this.frontType;
    }

    public static HighGoDataTypeEnum valueOfJdbcType(String jdbcType) {
        for (HighGoDataTypeEnum value : HighGoDataTypeEnum.values()) {
            if (!value.getJdbcType().equalsIgnoreCase(jdbcType)) continue;
            return value;
        }
        return OTHER;
    }
}

