/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.dataset.engine;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.dataset.dto.DataSetConfigInfoDto;
import com.jxdinfo.hussar.dataset.dto.DataSetOperationDto;
import com.jxdinfo.hussar.dataset.enums.DataSetTypeEnum;
import com.jxdinfo.hussar.dataset.model.ApiDataStructure;
import com.jxdinfo.hussar.dataset.model.DataSetCommonParam;
import com.jxdinfo.hussar.dataset.model.DataSetCondition;
import com.jxdinfo.hussar.dataset.model.SqlConfigSchema1;
import com.jxdinfo.hussar.dataset.model.SqlParameter1;
import com.jxdinfo.hussar.dataset.model.WordDataSetInfo;
import com.jxdinfo.hussar.dataset.service.IDataSetEngineService;
import com.jxdinfo.hussar.dataset.service.IDataSetService;
import com.jxdinfo.hussar.dataset.util.FileUtil;
import com.jxdinfo.hussar.dataset.util.HussarDataSetThreadUtil;
import com.jxdinfo.hussar.dataset.vo.DataSetExecuteVO;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.JsonUtil;
import com.jxdinfo.hussar.support.choreo.api.entity.ApiNaming;
import com.jxdinfo.hussar.support.choreo.api.service.EngineBussnessdataInvokeService;
import com.jxdinfo.hussar.support.datasource.annotations.HussarDs;
import com.jxdinfo.hussar.support.engine.plugin.rmi.enums.HttpBodyEnum;
import com.jxdinfo.hussar.support.exception.HussarException;
import com.jxdinfo.hussar.support.mp.base.query.dto.SuperQueryConditionDto;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.stereotype.Service;

@Service(value="com.jxdinfo.hussar.dataset.engine.DataSetEngineServiceImpl")
public class DataSetEngineServiceImpl
implements IDataSetEngineService {
    @Resource
    private IDataSetService dataSetService;
    @Resource(name="hussarAsyncPoolTaskExecutor")
    private ThreadPoolTaskExecutor hussarAsyncPoolTaskExecutor;
    @Resource
    private EngineBussnessdataInvokeService engineBussnessdataInvokeService;

    @HussarDs
    public ApiResponse<List<DataSetExecuteVO>> executeDataSetParam(List<DataSetCommonParam> dataSetCommonParams) {
        if (HussarUtils.isEmpty(dataSetCommonParams)) {
            return null;
        }
        List datasetIds = dataSetCommonParams.stream().filter(dataSetCommonParam -> HussarUtils.isNotEmpty((Object)dataSetCommonParam.getDataSetCondition())).map(dataSetCommonParam -> dataSetCommonParam.getDataSetCondition().getDataSetId()).collect(Collectors.toList());
        List wordDataSetInfos = this.dataSetService.listByIds(datasetIds);
        HussarException.throwBy((boolean)HussarUtils.isEmpty((Object)wordDataSetInfos), (String)String.format("\u6570\u636e\u8868\u4e2d\u4e0d\u5b58\u5728\u6307\u5b9a\u6570\u636e\u96c6\u4fe1\u606f\u3010%s\u3011", datasetIds));
        Map<String, WordDataSetInfo> dataSetInfoMap = wordDataSetInfos.stream().collect(Collectors.toMap(dataSetInfo -> dataSetInfo.getDataSetId().toString(), dataSetInfo -> dataSetInfo));
        try {
            ArrayList futureList = new ArrayList();
            for (DataSetCommonParam dataSetCommonParam2 : dataSetCommonParams) {
                CompletableFuture future = new CompletableFuture();
                futureList.add(future);
                HussarDataSetThreadUtil.executeDesignTask(() -> {
                    try {
                        DataSetExecuteVO result = this.processDataSetData(dataSetInfoMap, dataSetCommonParam2);
                        future.complete(result);
                    }
                    catch (Exception e) {
                        future.completeExceptionally(e);
                    }
                });
            }
            CompletionStage allResultsFuture = CompletableFuture.allOf(futureList.toArray(new CompletableFuture[0])).thenApply(v -> futureList.stream().map(CompletableFuture::join).collect(Collectors.toList()));
            List allResults = new ArrayList();
            if (HussarUtils.isNotEmpty(((CompletableFuture)allResultsFuture).get())) {
                allResults = (List)((CompletableFuture)allResultsFuture).get();
            }
            return ApiResponse.success(allResults);
        }
        catch (Exception e) {
            throw new HussarException(String.format("\u6267\u884c\u6570\u636e\u96c6\u4efb\u52a1\u5931\u8d25\uff01\u5931\u8d25\u539f\u56e0\uff1a%s", HussarUtils.isNotEmpty((Object)e.getCause()) ? e.getCause().getMessage() : e.getMessage()), (Throwable)e);
        }
    }

    private DataSetExecuteVO processDataSetData(Map<String, WordDataSetInfo> dataSetInfoMap, DataSetCommonParam dataSetCommonParam) {
        DataSetCondition dataSetCondition = dataSetCommonParam.getDataSetCondition();
        WordDataSetInfo wordDataSetInfo = dataSetInfoMap.get(dataSetCondition.getDataSetId());
        HussarException.throwBy((boolean)HussarUtils.isEmpty((Object)wordDataSetInfo), (String)String.format("\u5f53\u524d\u6570\u636e\u96c6\u4fe1\u606f\u4e0d\u5b58\u5728\uff0c\u6570\u636e\u96c6\u4e3b\u952e\u3010%s\u3011", dataSetCondition.getDataSetId()));
        if (wordDataSetInfo.getDataSetType().equals(DataSetTypeEnum.API.getCode())) {
            return this.processApiDataSet(wordDataSetInfo, dataSetCondition, dataSetCommonParam.getUnifiedId());
        }
        if (wordDataSetInfo.getDataSetType().equals(DataSetTypeEnum.DATASTREAM.getCode())) {
            return this.processStreamDataSet(wordDataSetInfo, dataSetCondition, dataSetCommonParam.getUnifiedId());
        }
        return this.processSqlDataSet(wordDataSetInfo, dataSetCondition, dataSetCommonParam.getUnifiedId());
    }

    private DataSetExecuteVO processStreamDataSet(WordDataSetInfo wordDataSetInfo, DataSetCondition dataSetCondition, String unifiedId) {
        DataSetConfigInfoDto dataSetConfigInfoDto = (DataSetConfigInfoDto)JSONObject.parseObject((String)wordDataSetInfo.getData(), DataSetConfigInfoDto.class);
        try {
            DataSetExecuteVO dataSetExecuteVO = new DataSetExecuteVO();
            return dataSetExecuteVO;
        }
        catch (Exception e) {
            throw new HussarException(String.format("\u901a\u8fc7\u6570\u636e\u96c6\u83b7\u53d6\u6570\u636e\u5f02\u5e38\uff0c\u65b9\u6cd5\u540d\u3010processDataSetData\u3011,\u5f02\u5e38\u4fe1\u606f\uff1a%s", HussarUtils.isNotEmpty((Object)e.getCause()) ? e.getCause().getCause() : e.getMessage()));
        }
    }

    private DataSetExecuteVO processSqlDataSet(WordDataSetInfo wordDataSetInfo, DataSetCondition dataSetCondition, String unifiedId) {
        DataSetConfigInfoDto dataSetConfigInfoDto = (DataSetConfigInfoDto)JSONObject.parseObject((String)wordDataSetInfo.getData(), DataSetConfigInfoDto.class);
        SqlConfigSchema1 sqlConfigSchema = dataSetConfigInfoDto.getDataSetParam();
        Map<Object, Object> params = new HashMap<String, List>();
        List sqlParameter1s = sqlConfigSchema.getParameterValues();
        if (HussarUtils.isNotEmpty((Object)sqlParameter1s) && HussarUtils.isEmpty(params = sqlParameter1s.stream().collect(Collectors.toMap(SqlParameter1::getCode, sqlParameter1 -> StringUtils.isEmpty((CharSequence)sqlParameter1.getValue()) ? "" : sqlParameter1.getValue())))) {
            params = new HashMap();
        }
        if (HussarUtils.isNotEmpty((Object)dataSetCondition.getOrders())) {
            params.put("orders", dataSetCondition.getOrders());
        }
        if (HussarUtils.isNotEmpty((Object)dataSetCondition.getCurrent()) && dataSetCondition.getCurrent() > 0) {
            params.put("current", dataSetCondition.getCurrent());
        } else {
            params.put("current", 1);
        }
        if (HussarUtils.isNotEmpty((Object)dataSetCondition.getSize()) && dataSetCondition.getSize() > 0) {
            params.put("size", dataSetCondition.getSize());
        } else {
            params.put("size", 2000);
        }
        if (HussarUtils.isNotEmpty((Object)dataSetCondition.getSuperQueryConditionDto())) {
            params.put("superQueryConditionDto", dataSetCondition.getSuperQueryConditionDto());
        }
        params.put("tfModelId", wordDataSetInfo.getDataSetId().toString());
        try {
            String businessId = String.format("%s /%s", "POST", FileUtil.posixPath("sqlModelCustomSql"));
            ApiResponse queryResult = this.engineBussnessdataInvokeService.invoke(businessId, params);
            DataSetExecuteVO dataSetExecuteVO = new DataSetExecuteVO();
            dataSetExecuteVO.setUnifiedId(unifiedId);
            dataSetExecuteVO.setDataSetId(wordDataSetInfo.getDataSetId().toString());
            if (queryResult.isSuccess()) {
                Object data = queryResult.getData();
                if (data instanceof Page) {
                    Page page = (Page)data;
                    dataSetExecuteVO.setCount(Long.valueOf(page.getTotal()).intValue());
                    dataSetExecuteVO.setReturnValue(JsonUtil.toJson((Object)page.getRecords()));
                } else if (data instanceof List) {
                    dataSetExecuteVO.setCount(((List)data).size());
                    dataSetExecuteVO.setReturnValue(JsonUtil.toJson((Object)queryResult.getData()));
                }
            }
            return dataSetExecuteVO;
        }
        catch (Exception e) {
            throw new HussarException(String.format("\u901a\u8fc7\u6570\u636e\u96c6\u83b7\u53d6\u6570\u636e\u5f02\u5e38\uff0c\u65b9\u6cd5\u540d\u3010processDataSetData\u3011,\u5f02\u5e38\u4fe1\u606f\uff1a%s", HussarUtils.isNotEmpty((Object)e.getCause()) ? e.getCause().getCause() : e.getMessage()));
        }
    }

    private DataSetExecuteVO processApiDataSet(WordDataSetInfo wordDataSetInfo, DataSetCondition dataSetCondition, String unifiedId) {
        DataSetConfigInfoDto dataSetConfigInfoDto = (DataSetConfigInfoDto)JSONObject.parseObject((String)wordDataSetInfo.getData(), DataSetConfigInfoDto.class);
        HussarException.throwBy((boolean)HussarUtils.isEmpty((Object)dataSetConfigInfoDto), (String)String.format("\u5f53\u524d\u6570\u636e\u96c6\u3010%s\u3011\u4fe1\u606f\u4e0d\u5b58\u5728!", wordDataSetInfo.getDataSetName()));
        List superQueryConditionDtos = dataSetCondition.getSuperQueryConditionDto();
        Map<String, Object> params = new HashMap<String, Object>();
        if (HussarUtils.isNotEmpty((Object)superQueryConditionDtos)) {
            params = superQueryConditionDtos.stream().collect(Collectors.toMap(SuperQueryConditionDto::getField, SuperQueryConditionDto::getVal));
            for (String key : params.keySet()) {
                if (!(params.get(key) instanceof List)) continue;
                String val = (String)((List)params.get(key)).get(0);
                for (int i = 1; i < ((List)params.get(key)).size(); ++i) {
                    val = val + "," + (String)((List)params.get(key)).get(i);
                }
                params.put(key, val);
            }
        }
        Map<String, Object> defaultValueMap = this.processApiInParamsDefaultValue(dataSetConfigInfoDto, wordDataSetInfo, params);
        params.putAll(defaultValueMap);
        ApiNaming apiNaming = new ApiNaming();
        apiNaming.setServiceName(wordDataSetInfo.getDataSetId().toString());
        try {
            ApiResponse queryResult = this.engineBussnessdataInvokeService.invoke(apiNaming, params);
            DataSetExecuteVO dataSetExecuteVO = new DataSetExecuteVO();
            dataSetExecuteVO.setUnifiedId(unifiedId);
            dataSetExecuteVO.setDataSetId(wordDataSetInfo.getDataSetId().toString());
            if (queryResult.isSuccess()) {
                dataSetExecuteVO.setReturnValue(JsonUtil.toJson((Object)queryResult.getData()));
            }
            return dataSetExecuteVO;
        }
        catch (Exception e) {
            throw new HussarException(String.format("\u901a\u8fc7\u6570\u636e\u96c6\u83b7\u53d6\u6570\u636e\u5f02\u5e38\uff0c\u65b9\u6cd5\u540d\u3010processDataSetData\u3011,\u5f02\u5e38\u4fe1\u606f\uff1a%s", HussarUtils.isNotEmpty((Object)e.getCause()) ? e.getCause().getMessage() : e.getMessage()));
        }
    }

    private Map<String, Object> processApiInParamsDefaultValue(DataSetConfigInfoDto dataSetConfigInfoDto, WordDataSetInfo wordDataSetInfo, Map<String, Object> params) {
        DataSetOperationDto operationDto = (DataSetOperationDto)dataSetConfigInfoDto.getOperations().get(0);
        HussarException.throwBy((boolean)HussarUtils.isEmpty((Object)operationDto), (String)String.format("\u5f53\u524d\u6570\u636e\u96c6\u3010%s\u3011\u6ca1\u6709\u914d\u7f6eAPI\u63a5\u53e3\u4fe1\u606f!", wordDataSetInfo.getDataSetName()));
        List querys = operationDto.getQuery();
        Map<String, Object> defaultValueMap = new HashMap<String, Object>();
        if (HussarUtils.isNotEmpty((Object)querys)) {
            Map<String, Object> finalParams = params;
            defaultValueMap = querys.stream().filter(query -> !finalParams.containsKey(query.getName())).filter(query -> HussarUtils.isNotEmpty((Object)query.getDefaultValue())).collect(Collectors.toMap(ApiDataStructure::getName, ApiDataStructure::getDefaultValue));
        }
        if (HussarUtils.isNotEmpty((Object)operationDto.getBody())) {
            if (HttpBodyEnum.JSON.getType().equalsIgnoreCase(operationDto.getContentType())) {
                defaultValueMap.putAll(DataSetEngineServiceImpl.recursiveBody(operationDto.getBody(), params));
            } else {
                Map<String, Object> bodyMap = operationDto.getBody().stream().filter(query -> !params.containsKey(query.getName())).filter(query -> HussarUtils.isNotEmpty((Object)query.getDefaultValue())).collect(Collectors.toMap(ApiDataStructure::getName, query -> query.getDefaultValue()));
                defaultValueMap.putAll(bodyMap);
            }
        }
        return defaultValueMap;
    }

    private static Map<String, Object> recursiveBody(List<ApiDataStructure> body, Map<String, Object> params) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        body.forEach(apiDataStructure -> {
            if (HussarUtils.isNotEmpty((Object)apiDataStructure.getProperties())) {
                map.putAll(DataSetEngineServiceImpl.recursiveBody(apiDataStructure.getProperties(), params));
            } else if (!params.containsKey(apiDataStructure.getName())) {
                map.put(apiDataStructure.getName(), apiDataStructure.getDefaultValue());
            }
        });
        return map;
    }

    public static void main(String[] args) {
        String str = "{\"id\":\"08bf4e30-5d74-11f0-8015-3d0952b5ee3e\",\"name\":\"\",\"type\":\"\",\"comment\":\"\",\"url\":\"dad\",\"requestMode\":\"GET\",\"query\":[],\"body\":[{\"id\":\"0fec2890-5d74-11f0-8015-3d0952b5ee3e\",\"name\":\"body\",\"comment\":\"body\",\"dataType\":\"object\",\"objectType\":\"\",\"properties\":[{\"id\":\"169b4770-5d74-11f0-8015-3d0952b5ee3e\",\"name\":\"id\",\"comment\":\"id\",\"dataType\":\"string\",\"objectType\":\"\",\"properties\":[],\"baseDataType\":\"\",\"parentId\":\"0fec2890-5d74-11f0-8015-3d0952b5ee3e\",\"reference\":\"\",\"defaultValue\":\"2\"},{\"id\":\"1d9be1b0-5d74-11f0-8015-3d0952b5ee3e\",\"name\":\"data\",\"comment\":\"data\",\"dataType\":\"array\",\"objectType\":\"\",\"properties\":[{\"id\":\"248b3de0-5d74-11f0-8015-3d0952b5ee3e\",\"name\":\"name\",\"comment\":\"name\",\"dataType\":\"string\",\"objectType\":\"\",\"properties\":[],\"baseDataType\":\"\",\"parentId\":\"1d9be1b0-5d74-11f0-8015-3d0952b5ee3e\",\"reference\":\"\",\"defaultValue\":\"1\"}],\"baseDataType\":\"\",\"parentId\":\"0fec2890-5d74-11f0-8015-3d0952b5ee3e\",\"reference\":\"\"}],\"baseDataType\":\"\",\"parentId\":\"\",\"reference\":\"\"}],\"returnValue\":{\"objectType\":\"object\",\"properties\":[]},\"nodePath\":\"\",\"hostPortConfigCode\":\"report.API_LOCAL\"}";
        DataSetOperationDto operationDto = (DataSetOperationDto)JSONObject.parseObject((String)str, DataSetOperationDto.class);
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("id", "1");
        Map<String, Object> defaultValueMap = DataSetEngineServiceImpl.recursiveBody(operationDto.getBody(), params);
        System.out.println(JSONObject.toJSONString(defaultValueMap));
    }
}

