/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.dataset.util;

import com.alibaba.fastjson.JSON;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.jxdinfo.hussar.dataset.enums.DataSetErrorCodeEnum;
import com.jxdinfo.hussar.dataset.enums.ParamTypeEnum;
import com.jxdinfo.hussar.dataset.model.ApiDataContent;
import com.jxdinfo.hussar.dataset.model.ApiProperty;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.exception.HussarException;
import com.jxdinfo.hussar.support.jsonschema.plugin.genertor.constants.JsonSchemaKeywords;
import com.jxdinfo.hussar.support.jsonschema.plugin.genertor.support.generator.config.JsonSchemaConfig;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonSchemaUtil {
    private static final Logger log = LoggerFactory.getLogger(JsonSchemaUtil.class);
    private static final String CONVERSION = "conversion";
    private static final String CONVERSION_KEY = "mapping";
    private static final String ITEMS_PREFIX = "$item.";
    private static final String ROOT = "$root";

    public static String generateJsonSchema(ApiDataContent data) {
        Gson gson = new Gson();
        try {
            JsonObject jsonSchemaObject = new JsonObject();
            JsonSchemaConfig jsonSchemaConfig = new JsonSchemaConfig();
            jsonSchemaObject.addProperty(JsonSchemaKeywords.SCHEMA.toString(), jsonSchemaConfig.getVersion());
            jsonSchemaObject.addProperty(CONVERSION, Boolean.valueOf(true));
            if (HussarUtils.isEmpty((Object)data) || HussarUtils.isEmpty((Object)data.getObjectType())) {
                jsonSchemaObject.addProperty(JsonSchemaKeywords.TYPE.toString(), "null");
            } else {
                String objectType = data.getObjectType();
                jsonSchemaObject.addProperty(JsonSchemaKeywords.TYPE.toString(), objectType);
                jsonSchemaObject.addProperty(CONVERSION_KEY, ROOT);
                List properties = data.getProperties();
                if (HussarUtils.isNotEmpty((Object)properties)) {
                    if (ParamTypeEnum.OBJECT.getValue().equals(objectType)) {
                        JsonObject propertiesObject = JsonSchemaUtil.processProperties(properties, false, jsonSchemaObject.get(CONVERSION_KEY).getAsString());
                        jsonSchemaObject.add(JsonSchemaKeywords.PROPERTIES.toString(), (JsonElement)propertiesObject);
                    } else {
                        JsonObject propertiesObject = JsonSchemaUtil.processProperties(properties, true, jsonSchemaObject.get(CONVERSION_KEY).getAsString());
                        jsonSchemaObject.add(JsonSchemaKeywords.ITEMS.toString(), (JsonElement)propertiesObject);
                    }
                }
            }
            return gson.toJson((JsonElement)jsonSchemaObject);
        }
        catch (Exception e) {
            throw new HussarException(Integer.valueOf(DataSetErrorCodeEnum.DATASET_OUT_TO_JSONSCHEMA_EXCEPTION.getCode()), DataSetErrorCodeEnum.DATASET_OUT_TO_JSONSCHEMA_EXCEPTION.getMessage(), (Throwable)e);
        }
    }

    private static JsonObject processProperties(List<ApiProperty> properties, boolean parentIsArray, String parentName) {
        JsonObject propertiesObject = new JsonObject();
        for (ApiProperty apiProperty : properties) {
            JsonObject jsonElment = JsonSchemaUtil.processDataType(apiProperty, parentIsArray, parentName);
            propertiesObject.add(apiProperty.getName(), (JsonElement)jsonElment);
        }
        return propertiesObject;
    }

    private static JsonObject processDataType(ApiProperty apiProperty, boolean parentIsArray, String parentName) {
        JsonObject jsonElment = JsonSchemaUtil.makeSchemaElement(apiProperty, parentIsArray, parentName);
        ParamTypeEnum paramType = ParamTypeEnum.fromValue(apiProperty.getDataType());
        switch (paramType) {
            case ARRAY_PRIMARY: {
                JsonObject element = new JsonObject();
                element.addProperty(JsonSchemaKeywords.TYPE.toString(), ParamTypeEnum.STRING.getValue());
                jsonElment.add(JsonSchemaKeywords.ITEMS.toString(), (JsonElement)element);
                break;
            }
            case OBJECT: {
                if (!HussarUtils.isNotEmpty((Object)apiProperty.getProperties())) break;
                JsonObject jsonObject = JsonSchemaUtil.processProperties(apiProperty.getProperties(), false, jsonElment.get(CONVERSION_KEY).getAsString());
                jsonElment.add(JsonSchemaKeywords.PROPERTIES.toString(), (JsonElement)jsonObject);
                break;
            }
            case ARRAY_OBJECT: {
                if (!HussarUtils.isNotEmpty((Object)apiProperty.getProperties())) break;
                JsonObject jsonElement = JsonSchemaUtil.processProperties(apiProperty.getProperties(), true, jsonElment.get(CONVERSION_KEY).getAsString());
                JsonObject jsonObject = new JsonObject();
                jsonObject.addProperty(JsonSchemaKeywords.TYPE.toString(), ParamTypeEnum.OBJECT.getValue());
                jsonObject.add(JsonSchemaKeywords.PROPERTIES.toString(), (JsonElement)jsonElement);
                jsonElment.add(JsonSchemaKeywords.ITEMS.toString(), (JsonElement)jsonObject);
                break;
            }
        }
        return jsonElment;
    }

    private static JsonObject makeSchemaElement(ApiProperty apiProperty, boolean parentIsArray, String parentName) {
        JsonObject jsonElement = new JsonObject();
        if (ParamTypeEnum.ARRAY_PRIMARY.getValue().equalsIgnoreCase(apiProperty.getDataType())) {
            jsonElement.addProperty(JsonSchemaKeywords.TYPE.toString(), ParamTypeEnum.ARRAY_OBJECT.getValue());
        } else {
            jsonElement.addProperty(JsonSchemaKeywords.TYPE.toString(), apiProperty.getDataType());
        }
        jsonElement.addProperty(JsonSchemaKeywords.DESCRIPTION.toString(), apiProperty.getComment());
        String mapping = apiProperty.getName();
        mapping = parentIsArray ? ITEMS_PREFIX + mapping : parentName + "." + mapping;
        jsonElement.addProperty(CONVERSION_KEY, mapping);
        return jsonElement;
    }

    public static void main(String[] args) {
        String str = "{\"objectType\":\"object\",\"properties\":[{\"id\":\"8eb98640-74f8-11f0-8321-85a0afd57d62\",\"name\":\"code\",\"comment\":\"\u72b6\u6001\u7801\",\"dataType\":\"int\",\"objectType\":\"\",\"properties\":[],\"baseDataType\":\"string\",\"reference\":\"\"},{\"id\":\"8efaadf0-74f8-11f0-8321-85a0afd57d62\",\"name\":\"success\",\"comment\":\"\u662f\u5426\u6210\u529f\",\"dataType\":\"boolean\",\"objectType\":\"\",\"properties\":[],\"baseDataType\":\"string\",\"reference\":\"\"},{\"id\":\"8f1d2a10-74f8-11f0-8321-85a0afd57d62\",\"name\":\"data\",\"comment\":\"\u627f\u8f7d\u6570\u636e\",\"dataType\":\"object\",\"objectType\":\"\",\"properties\":[{\"id\":\"8f1d2a10-74f8-11f0-8321-85a0afd57d62\",\"name\":\"data\",\"comment\":\"\u627f\u8f7d\u6570\u636e\",\"dataType\":\"object\",\"objectType\":\"\",\"properties\":[{\"id\":\"8f1d2a10-74f8-11f0-8321-85a0afd57d62\",\"name\":\"data\",\"comment\":\"\u627f\u8f7d\u6570\u636e\",\"dataType\":\"object\",\"objectType\":\"\",\"properties\":[{\"id\":\"8f1d2a10-74f8-11f0-8321-85a0afd57d62\",\"name\":\"data\",\"comment\":\"\u627f\u8f7d\u6570\u636e\",\"dataType\":\"object\",\"objectType\":\"\",\"properties\":[]}]},{\"id\":\"8f1d2a10-74f8-11f0-8321-85a0afd57d62\",\"name\":\"name\",\"comment\":\"\u627f\u8f7d\u6570\u636e\",\"dataType\":\"string\",\"objectType\":\"\",\"properties\":[]}]}]}]}";
        ApiDataContent apiDataContent = (ApiDataContent)JSON.parseObject((String)str, ApiDataContent.class);
        String jsonStr = JsonSchemaUtil.generateJsonSchema(apiDataContent);
        System.out.println(jsonStr);
    }
}

