/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.dataset.enums.jdbc;

import java.sql.Date;
import java.sql.Time;
import java.time.LocalDateTime;
import org.apache.ibatis.type.JdbcType;

public enum OscarDataTypeEnum {
    INT("INT", JdbcType.INTEGER.name(), Integer.class, "int"),
    INTEGER("INTEGER", JdbcType.INTEGER.name(), Integer.class, "int"),
    BIGINT("BIGINT", JdbcType.BIGINT.name(), Long.class, "long"),
    SMALLINT("SMALLINT", JdbcType.SMALLINT.name(), Integer.class, "int"),
    TINYINT("TINYINT", JdbcType.TINYINT.name(), Integer.class, "int"),
    BINARY("BINARY", JdbcType.BINARY.name(), Long.class, "long"),
    BIT("BIT", JdbcType.BIT.name(), Long.class, "long"),
    NUMBER("NUMBER", JdbcType.NUMERIC.name(), Long.class, "long"),
    NUMERIC("NUMERIC", JdbcType.NUMERIC.name(), Long.class, "long"),
    DECIMAL("DECIMAL", JdbcType.DECIMAL.name(), Long.class, "long"),
    REAL("REAL", JdbcType.REAL.name(), Double.class, "double"),
    DOUBLE("DOUBLE", JdbcType.DOUBLE.name(), Double.class, "double"),
    FLOAT("FLOAT", JdbcType.FLOAT.name(), Double.class, "double"),
    SERIAL("SERIAL", JdbcType.INTEGER.name(), Integer.class, "int"),
    CHAR("CHAR", JdbcType.CHAR.name(), String.class, "string"),
    VARCHAR("VARCHAR", JdbcType.VARCHAR.name(), String.class, "string"),
    BLOB("BLOB", JdbcType.BLOB.name(), String.class, "string"),
    CLOB("CLOB", JdbcType.CLOB.name(), String.class, "string"),
    TEXT("TEXT", JdbcType.CLOB.name(), String.class, "string"),
    YEAR("YEAR", JdbcType.VARCHAR.name(), String.class, "string"),
    TIMESTAMP("TIMESTAMP", JdbcType.TIMESTAMP.name(), LocalDateTime.class, "datetime"),
    DATE("DATE", JdbcType.DATE.name(), Date.class, "date"),
    TIME("TIME", JdbcType.TIME.name(), Time.class, "time"),
    BOOL("BOOL", JdbcType.BOOLEAN.name(), Boolean.class, "boolean"),
    OTHER("other", JdbcType.OTHER.name(), String.class, "string");

    private String jdbcType;
    private String ibatisJdbcType;
    private Class<?> javaType;
    private String frontType;

    private OscarDataTypeEnum(String jdbcType, String ibatisJdbcType, Class<?> javaType, String frontType) {
        this.javaType = javaType;
        this.ibatisJdbcType = ibatisJdbcType;
        this.jdbcType = jdbcType;
        this.frontType = frontType;
    }

    public String getJdbcType() {
        return this.jdbcType;
    }

    public void setJdbcType(String jdbcType) {
        this.jdbcType = jdbcType;
    }

    public Class<?> getJavaType() {
        return this.javaType;
    }

    public void setJavaType(Class<?> javaType) {
        this.javaType = javaType;
    }

    public String getIbatisJdbcType() {
        return this.ibatisJdbcType;
    }

    public String getFrontType() {
        return this.frontType;
    }

    public static OscarDataTypeEnum valueOfJdbcType(String jdbcType) {
        for (OscarDataTypeEnum value : OscarDataTypeEnum.values()) {
            if (!value.getJdbcType().equalsIgnoreCase(jdbcType)) continue;
            return value;
        }
        return OTHER;
    }
}

